/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import org.eclipse.birt.report.designer.core.commands.CmdBaseTestCase;
import org.eclipse.birt.report.designer.core.commands.SetConstraintCommand;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.draw2d.geometry.Dimension;

public class SetConstraintCommandTest
extends CmdBaseTestCase {
    public void notestSetConstraintTableCmd() {
        SetConstraintCommand cmd = new SetConstraintCommand();
        Dimension size = new Dimension(200, 100);
        cmd.setModel((ReportItemHandle)this.table);
        cmd.setSize(size);
        cmd.execute();
        Dimension dim = this.adapter.calculateSize();
        SetConstraintCommandTest.assertEquals((int)200, (int)dim.width);
        SetConstraintCommandTest.assertEquals((int)100, (int)dim.height);
    }

    public void testSetConstraintImageCmd() throws SemanticException {
        ImageHandle newImage = this.getElementFactory().newImage("Test Image");
        newImage.setWidth("150px");
        newImage.setHeight("180px");
        SetConstraintCommandTest.assertEquals((int)150, (int)((int)newImage.getWidth().getMeasure()));
        SetConstraintCommandTest.assertEquals((int)180, (int)((int)newImage.getHeight().getMeasure()));
        SetConstraintCommand cmd = new SetConstraintCommand();
        Dimension size = new Dimension(200, 100);
        cmd.setModel((ReportItemHandle)newImage);
        cmd.setSize(size);
        cmd.execute();
        SetConstraintCommandTest.assertTrue((boolean)newImage.getWidth().getUnits().equals("px"));
        SetConstraintCommandTest.assertTrue((boolean)newImage.getHeight().getUnits().equals("px"));
        SetConstraintCommandTest.assertEquals((int)200, (int)((int)newImage.getWidth().getMeasure()));
        SetConstraintCommandTest.assertEquals((int)100, (int)((int)newImage.getHeight().getMeasure()));
    }

    public void testSetConstraintDataItemCmd() {
        DataItemHandle dataItem = this.getElementFactory().newDataItem("TestDataItem");
        SetConstraintCommand cmd = new SetConstraintCommand();
        Dimension size = new Dimension(100, 50);
        cmd.setModel((ReportItemHandle)dataItem);
        cmd.setSize(size);
        cmd.execute();
        DimensionHandle width = dataItem.getWidth();
        DimensionHandle height = dataItem.getHeight();
        SetConstraintCommandTest.assertTrue((boolean)width.getUnits().equals("in"));
        SetConstraintCommandTest.assertTrue((boolean)height.getUnits().equals("in"));
        double widthPixel = MetricUtility.inchToPixel((double)width.getMeasure());
        double heightPixel = MetricUtility.inchToPixel((double)height.getMeasure());
        SetConstraintCommandTest.assertEquals((int)100, (int)((int)widthPixel));
        SetConstraintCommandTest.assertEquals((int)50, (int)((int)heightPixel));
    }

    public void testSetConstraintLabelCmd() {
        LabelHandle label = this.getElementFactory().newLabel("TestLabel");
        SetConstraintCommand cmd = new SetConstraintCommand();
        Dimension size = new Dimension(50, 100);
        cmd.setModel((ReportItemHandle)label);
        cmd.setSize(size);
        cmd.execute();
        DimensionHandle width = label.getWidth();
        DimensionHandle height = label.getHeight();
        SetConstraintCommandTest.assertTrue((boolean)width.getUnits().equals("in"));
        SetConstraintCommandTest.assertTrue((boolean)height.getUnits().equals("in"));
        double widthPixel = MetricUtility.inchToPixel((double)width.getMeasure());
        double heightPixel = MetricUtility.inchToPixel((double)height.getMeasure());
        SetConstraintCommandTest.assertEquals((int)50, (int)((int)widthPixel));
        SetConstraintCommandTest.assertEquals((int)100, (int)((int)heightPixel));
    }
}

