/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.eclipse.birt.core.script.ScriptContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public abstract class BaseTestCase {
    @Rule
    public TestName testName = new TestName();
    protected PrintStream testOut;
    protected Context jsContext;
    protected Scriptable jsScope;
    protected ScriptContext scriptContext;
    private static final String OUTPUT_FOLDER = "DtETestTempDataoutput";
    private static final String INPUT_FOLDER = "input";
    private static final String GOLDEN_FOLDER = "golden";

    public BaseTestCase() {
        BaseTestCase.deleteFile(BaseTestCase.getOutputFolder());
    }

    @Before
    public void baseSetUp() throws Exception {
        this.openOutputFolder();
        this.openOutputFile();
        this.jsContext = Context.enter();
        this.jsScope = new ImporterTopLevel(this.jsContext);
        this.scriptContext = new ScriptContext().newContext((Object)this.jsScope);
        this.jsScope.put("_testCase", this.jsScope, (Object)this);
        this.jsContext.evaluateString(this.jsScope, "function testPrint(str) { _testCase.testPrint(str); }; function testPrintln(str) { _testCase.testPrintln(str); }; ", "BaseTestCase.setUp", 1, null);
    }

    @After
    public void baseTearDown() throws Exception {
        Context.exit();
        this.closeOutputFile();
    }

    public String getTestName() {
        return this.testName.getMethodName();
    }

    protected InputStream getInputFolder(String dataFileName) {
        return this.getClass().getResourceAsStream(INPUT_FOLDER + File.separator + dataFileName);
    }

    protected static File getOutputFolder() {
        return new File(new File(System.getProperty("java.io.tmpdir")), OUTPUT_FOLDER);
    }

    protected static String getTempDir() {
        return BaseTestCase.getOutputFolder().getAbsolutePath() + File.separator + "DataEngineSessionTemp" + File.separator;
    }

    private void openOutputFolder() {
        File outputFolder = BaseTestCase.getOutputFolder();
        if (!outputFolder.exists()) {
            outputFolder.mkdir();
        }
    }

    protected void openOutputFile() throws IOException {
        File outputFile = new File(BaseTestCase.getOutputFolder(), this.getOutputFileName());
        this.testOut = new PrintStream(new FileOutputStream(outputFile, false));
    }

    protected void closeOutputFile() throws IOException {
        if (this.testOut != null) {
            this.testOut.close();
            this.testOut = null;
        }
    }

    private String getOutputFileName() {
        String className = this.getClass().getName();
        int lastDotIdx = className.lastIndexOf(46);
        if (lastDotIdx >= 0) {
            className = className.substring(lastDotIdx + 1);
        }
        return className + "." + this.getTestName() + ".txt";
    }

    protected void checkOutputFile() throws IOException {
        if (this.testOut != null) {
            this.testOut.flush();
        }
        String name = this.getOutputFileName();
        this.checkOutputFile(name, name);
    }

    private void checkOutputFile(String goldenFileName, String outputFileName) throws IOException {
        InputStream golden = this.getClass().getResourceAsStream(GOLDEN_FOLDER + File.separator + goldenFileName);
        File outputFile = new File(BaseTestCase.getOutputFolder(), outputFileName);
        this.compareTextFile(golden, outputFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compareTextFile(InputStream golden, File outputFile) throws IOException {
        InputStreamReader readerA = new InputStreamReader(golden);
        FileReader readerB = new FileReader(outputFile);
        BufferedReader lineReaderA = new BufferedReader(readerA);
        BufferedReader lineReaderB = new BufferedReader(readerB);
        try {
            String strB;
            do {
                String strA = lineReaderA.readLine();
                strB = lineReaderB.readLine();
                Assert.assertEquals((Object)(strA != null ? strA.trim() : null), (Object)(strB != null ? strB.trim() : null));
                if (strA == null) return;
            } while (strB != null);
            return;
        }
        finally {
            golden.close();
            readerA.close();
            readerB.close();
            lineReaderA.close();
            lineReaderB.close();
        }
    }

    public void testPrint(String str) {
        System.out.print(str);
        if (this.testOut != null) {
            this.testOut.print(str);
        }
    }

    public void testPrintln(String str) {
        System.out.println(str);
        if (this.testOut != null) {
            this.testOut.println(str);
        }
    }

    public static void deleteFile(File f) {
        if (f.isDirectory()) {
            String[] children;
            String[] stringArray = children = f.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                BaseTestCase.deleteFile(new File(f, child));
                ++n2;
            }
        }
        f.delete();
        f.deleteOnExit();
    }
}

