/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScriptedDSTest
extends APITestCase {
    private final String dataSetName = "ScriptedDataSet";
    private static final int TEST_NONE = 0;
    private static final int TEST_SORT = 1;
    private static final int TEST_GROUP = 2;
    private static final int TEST_MAXROW = 3;
    private static final int TEST_TOPN_FILTER = 4;
    private boolean ADD_ALIAS = true;
    private ScriptExpression queryExpr = new ScriptExpression("Total.Count( )");
    private String queryName = "_query_count";
    private ScriptExpression groupExpr = new ScriptExpression("Total.Count( )");
    private String groupName = "_group_count";
    private String[] scriptColumnNames = new String[]{"NUM", "SQUARE", "STR", "ANY"};
    private int[] scriptColumnTypes;
    private String[] scriptColumnTypeNames;
    private String[] scriptColumnAliasNames;
    private IScriptExpression[] scriptExprs;
    private IScriptExpression[] aliasScriptExprs;
    private ScriptDataSourceDesign dsource;
    private ScriptDataSetDesign dset;

    public ScriptedDSTest() {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[1] = 3;
        nArray[2] = 5;
        this.scriptColumnTypes = nArray;
        this.scriptColumnTypeNames = new String[]{"INTEGER", "DOUBLE", "STRING", "ANY"};
        this.scriptColumnAliasNames = new String[]{"NUM2", "SQUARE2", "STR2", "ANY2"};
    }

    @Before
    public void scriptedDSSetUp() throws Exception {
        this.ADD_ALIAS = true;
    }

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return null;
    }

    private void init(boolean dynamicMetadata) throws Exception {
        this.dsource = new ScriptDataSourceDesign("JUST as place folder");
        this.dset = this.newDataSet(null, dynamicMetadata);
        this.dset.setDataSource(this.dsource.getName());
        this.dsource.setBeforeOpenScript("testPrintln(\"@@EVENT:DataSource.beforeOpen\")");
        this.dsource.setBeforeCloseScript("testPrintln(\"@@EVENT:DataSource.beforeClose\")");
        this.dsource.setAfterOpenScript("testPrintln(\"@@EVENT:DataSource.afterOpen\")");
        this.dsource.setAfterCloseScript("testPrintln(\"@@EVENT:DataSource.afterClose\")");
        this.dsource.setOpenScript("testPrintln(\"@@EVENT:DataSource.open\")");
        this.dsource.setCloseScript("testPrintln(\"@@EVENT:DataSource.close\")");
        this.dataEngine.defineDataSource((IBaseDataSourceDesign)this.dsource);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)this.dset);
        this.scriptExprs = new IScriptExpression[]{new ScriptExpression("dataSetRow." + this.scriptColumnNames[0]), new ScriptExpression("dataSetRow." + this.scriptColumnNames[1]), new ScriptExpression("dataSetRow." + this.scriptColumnNames[2]), new ScriptExpression("dataSetRow." + this.scriptColumnNames[3])};
        this.aliasScriptExprs = new IScriptExpression[]{new ScriptExpression("dataSetRow." + this.scriptColumnAliasNames[0]), new ScriptExpression("dataSetRow." + this.scriptColumnAliasNames[1]), new ScriptExpression("dataSetRow." + this.scriptColumnAliasNames[2]), new ScriptExpression("dataSetRow." + this.scriptColumnAliasNames[3])};
    }

    private ScriptDataSetDesign newDataSet(String name, boolean dynamicMetadata) {
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign(name == null ? "ScriptedDataSet" : name);
        dataSet.setOpenScript("testPrintln(\"@@EVENT:ScriptDataSet.open\");count=11; dset_open=true; count--;");
        dataSet.setCloseScript("testPrintln(\"@@EVENT:ScriptDataSet.close\")");
        dataSet.setFetchScript("if (count==0) {return false; } else { row.NUM=count; row.SQUARE=count*count; row.STR=\"row#\" + count;  row[4]=count<5; --count; return true; }");
        if (dynamicMetadata) {
            Object describeScript = new String();
            int i = 0;
            while (i < this.scriptColumnNames.length) {
                String callText = "addDataSetColumn(\"" + this.scriptColumnNames[i] + "\", \"" + this.scriptColumnTypeNames[i] + "\"); ";
                describeScript = (String)describeScript + callText;
                ++i;
            }
            describeScript = (String)describeScript + " return true; ";
            dataSet.setDescribeScript((String)describeScript);
        }
        dataSet.setBeforeOpenScript("testPrintln(\"@@EVENT:DataSet.beforeOpen\")");
        dataSet.setBeforeCloseScript("testPrintln(\"@@EVENT:DataSet.beforeClose\")");
        dataSet.setAfterOpenScript("testPrintln(\"@@EVENT:DataSet.afterOpen\")");
        dataSet.setAfterCloseScript("testPrintln(\"@@EVENT:DataSet.afterClose\")");
        if (!dynamicMetadata) {
            dataSet.getResultSetHints().addAll(this.getColumnHints());
        }
        ComputedColumn cp1 = new ComputedColumn("CP1", "12345", 0);
        ComputedColumn cp2 = new ComputedColumn("CP2", "54321", 0);
        dataSet.addComputedColumn((IComputedColumn)cp1);
        dataSet.addComputedColumn((IComputedColumn)cp2);
        return dataSet;
    }

    private List getColumnHints() {
        ArrayList<ColumnDefinition> list = new ArrayList<ColumnDefinition>();
        int i = 0;
        while (i < this.scriptColumnNames.length) {
            ColumnDefinition col = new ColumnDefinition(this.scriptColumnNames[i]);
            col.setDataType(this.scriptColumnTypes[i]);
            col.setAlias(this.scriptColumnAliasNames[i]);
            list.add(col);
            ++i;
        }
        return list;
    }

    @Test
    public void testGetMetaDataStatic() throws Exception {
        this.getMetadataTestImpl(false);
    }

    @Test
    public void testGetMetaDataDynamic() throws Exception {
        this.getMetadataTestImpl(true);
    }

    public void getMetadataTestImpl(boolean dynamicMetadata) throws Exception {
        this.init(dynamicMetadata);
        IQueryDefinition rqDefn = this.getReportQueryDefn(1);
        IPreparedQuery pq = this.dataEngine.prepare(rqDefn);
        IQueryResults qr = pq.execute(this.jsScope);
        IResultMetaData metaData = qr.getResultMetaData();
        int count = this.getNoneTempColumCount(metaData);
        int i = 0;
        while (i < count) {
            if (i < this.scriptColumnNames.length) {
                Assert.assertEquals((Object)metaData.getColumnName(i + 1), (Object)("_" + this.scriptColumnNames[i]));
                Assert.assertEquals((long)metaData.getColumnType(i + 1), (long)this.scriptColumnTypes[i]);
            } else if (i < this.scriptColumnNames.length + this.scriptColumnAliasNames.length) {
                Assert.assertEquals((Object)metaData.getColumnName(i + 1), (Object)("_" + this.scriptColumnAliasNames[i - this.scriptColumnNames.length]));
            }
            ++i;
        }
    }

    private int getNoneTempColumCount(IResultMetaData metaData) throws BirtException {
        int i = 1;
        while (i <= metaData.getColumnCount()) {
            if (metaData.getColumnName(i).matches("\\Q_{$TEMP\\E.*\\d*\\Q$}_\\E")) {
                return i - 1;
            }
            ++i;
        }
        return metaData.getColumnCount();
    }

    @Test
    public void testMaxRows() throws Exception {
        this.init(false);
        IQueryDefinition rqDefn = this.getReportQueryDefn(3);
        IPreparedQuery pq = this.dataEngine.prepare(rqDefn);
        IQueryResults qr = pq.execute(this.jsScope);
        IResultIterator resultIterator = qr.getResultIterator();
        int rowCount = 0;
        while (resultIterator.next()) {
            ++rowCount;
        }
        Assert.assertEquals((long)rqDefn.getMaxRows(), (long)rowCount);
    }

    @Test
    public void testFetch1() throws Exception {
        this.fetch1_test_impl(false);
    }

    @Test
    public void testFetch1Dynamic() throws Exception {
        this.ADD_ALIAS = false;
        this.fetch1_test_impl(true);
    }

    private void fetch1_test_impl(boolean dynamicMetadata) throws Exception {
        this.init(dynamicMetadata);
        IQueryDefinition rqDefn = this.getReportQueryDefn(1);
        IPreparedQuery pq = this.dataEngine.prepare(rqDefn);
        IQueryResults qr = pq.execute(this.jsScope);
        IResultIterator ri = qr.getResultIterator();
        int rowIndex = 0;
        while (ri.next()) {
            Object outputStr = "";
            int i = 0;
            while (i < this.scriptColumnNames.length) {
                Object value = ri.getValue("_" + this.scriptColumnNames[i]);
                outputStr = (String)outputStr + this.scriptExprs[i].getText().replace("dataSetRow", "row") + " value is:" + value.toString() + "    ";
                ++i;
            }
            ++rowIndex;
            this.testPrintln((String)outputStr);
        }
        ri.close();
        qr.close();
        this.dataEngine.shutdown();
        this.checkOutputFile();
    }

    @Test
    public void testFetchWithAlias() throws Exception {
        this.init(false);
        IQueryDefinition rqDefn = this.getReportQueryDefn(2);
        IPreparedQuery pq = this.dataEngine.prepare(rqDefn);
        IQueryResults qr = pq.execute(this.jsScope);
        IResultIterator ri = qr.getResultIterator();
        int rowIndex = 0;
        while (ri.next()) {
            Object outputStr = "";
            int i = 0;
            while (i < this.scriptColumnAliasNames.length) {
                Object value = ri.getValue("_" + this.scriptColumnAliasNames[i]);
                outputStr = (String)outputStr + this.aliasScriptExprs[i].getText().replace("dataSetRow", "row") + " value is:" + value.toString() + "    ";
                ++i;
            }
            ++rowIndex;
            this.testPrintln((String)outputStr);
        }
        ri.close();
        qr.close();
        this.dataEngine.shutdown();
        this.checkOutputFile();
    }

    @Test
    public void testFetch2() throws Exception {
        this.init(false);
        IQueryDefinition rqDefn = this.getReportQueryDefn(2);
        IPreparedQuery pq = this.dataEngine.prepare(rqDefn);
        IQueryResults qr = pq.execute(this.jsScope);
        IResultIterator ri = qr.getResultIterator();
        int groupLevel = -1;
        int rowIndex = 0;
        while (ri.next()) {
            if (groupLevel == -1) {
                this.testPrintln("Query row count:" + String.valueOf(ri.getValue(this.queryName)));
            }
            if (groupLevel < ri.getEndingGroupLevel()) {
                this.testPrintln("");
                this.testPrintln("Group row count:" + String.valueOf(ri.getValue(this.groupName)));
            }
            groupLevel = ri.getEndingGroupLevel();
            Object outputStr = "";
            int i = 0;
            while (i < this.scriptColumnNames.length) {
                Object value = ri.getValue("_" + this.scriptColumnNames[i]);
                outputStr = (String)outputStr + this.scriptExprs[i].getText().replace("dataSetRow", "row") + " value is:" + value.toString() + "    ";
                ++i;
            }
            ++rowIndex;
            this.testPrintln((String)outputStr);
        }
        ri.close();
        qr.close();
        this.dataEngine.shutdown();
        this.checkOutputFile();
    }

    @Test
    public void testFetch3() throws Exception {
        this.init(false);
        IQueryDefinition rqDefn = this.getReportQueryDefn(4);
        IPreparedQuery pq = this.dataEngine.prepare(rqDefn);
        IQueryResults qr = pq.execute(this.jsScope);
        IResultIterator ri = qr.getResultIterator();
        int rowIndex = 0;
        while (ri.next()) {
            Object outputStr = "";
            int i = 0;
            while (i < this.scriptColumnNames.length) {
                Object value = ri.getValue("_" + this.scriptColumnNames[i]);
                outputStr = (String)outputStr + this.scriptExprs[i].getText().replace("dataSetRow", "row") + " value is:" + value.toString() + "    ";
                ++i;
            }
            ++rowIndex;
            this.testPrintln((String)outputStr);
        }
        ri.close();
        qr.close();
        this.dataEngine.shutdown();
        this.checkOutputFile();
    }

    @Test
    public void testFetchLimit1() throws Exception {
        this.testFetchLimit(-1);
    }

    @Test
    public void testFetchLimit2() throws Exception {
        this.testFetchLimit(0);
    }

    @Test
    public void testFetchLimit3() throws Exception {
        this.testFetchLimit(2);
    }

    private void testFetchLimit(int limit) throws Exception {
        this.init(false);
        this.dset.setRowFetchLimit(limit);
        IQueryDefinition rqDefn = this.getReportQueryDefn(4);
        IPreparedQuery pq = this.dataEngine.prepare(rqDefn);
        IQueryResults qr = pq.execute(this.jsScope);
        IResultIterator ri = qr.getResultIterator();
        int rowIndex = 0;
        while (ri.next()) {
            Object outputStr = "";
            int i = 0;
            while (i < this.scriptColumnNames.length) {
                Object value = ri.getValue("_" + this.scriptColumnNames[i]);
                outputStr = (String)outputStr + this.scriptExprs[i].getText().replace("dataSetRow", "row") + " value is:" + value.toString() + "    ";
                ++i;
            }
            ++rowIndex;
            this.testPrintln((String)outputStr);
        }
        ri.close();
        qr.close();
        this.dataEngine.shutdown();
        this.checkOutputFile();
    }

    @Test
    public void testImportPackage() throws Exception {
        this.init(false);
        IQueryDefinition queryDefn = this.getReportQueryDefn(0);
        try {
            this.dsource.setBeforeOpenScript("importPackage(Packages.javax.swing.tree);");
            this.dset.setBeforeOpenScript("dmtn = new DefaultMutableTreeNode();");
            IPreparedQuery preparedQuery = this.dataEngine.prepare(queryDefn);
            preparedQuery.execute(null);
        }
        catch (Exception e) {
            Assert.fail((String)"Should not arrive here");
        }
    }

    @Test
    public void testGlobalVariable() throws Exception {
        this.init(false);
        try {
            this.dsource.setBeforeOpenScript("i = 100;");
            this.iterateResultSet(this.dset);
        }
        catch (Exception e) {
            Assert.fail((String)"Should not arrive here");
        }
    }

    @Test
    public void testMultipleDataSource() throws Exception {
        this.init(false);
        ScriptDataSetDesign dset1 = this.newDataSet("dset1", false);
        dset1.setDataSource(this.dsource.getName());
        this.dataEngine.defineDataSet((IBaseDataSetDesign)dset1);
        ScriptDataSourceDesign dsource1 = new ScriptDataSourceDesign("datasource1");
        ScriptDataSetDesign dset2 = this.newDataSet("dset2", false);
        dset2.setDataSource(dsource1.getName());
        this.dataEngine.defineDataSource((IBaseDataSourceDesign)dsource1);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)dset2);
        try {
            this.dsource.setBeforeOpenScript("i = 100;");
            this.iterateResultSet(dset2);
            Assert.fail((String)"Sould not arrive here");
        }
        catch (DataException dataException) {
            // empty catch block
        }
        try {
            ScriptDataSetDesign dset3 = this.newDataSet("dset3", false);
            dset3.setDataSource(dsource1.getName());
            this.dataEngine.defineDataSource((IBaseDataSourceDesign)dsource1);
            this.dataEngine.defineDataSet((IBaseDataSetDesign)dset3);
            dsource1.setBeforeOpenScript("i = 100;");
            this.iterateResultSet(dset3);
        }
        catch (DataException e) {
            Assert.fail((String)"Sould not arrive here");
        }
    }

    @Test
    public void testDateTimeValues() throws Exception {
        this.dsource = new ScriptDataSourceDesign("data source");
        this.dset = new ScriptDataSetDesign(" data set");
        this.dset.setDataSource(this.dsource.getName());
        ColumnDefinition c = new ColumnDefinition("d1");
        c.setDataType(6);
        this.dset.addResultSetHint((IColumnDefinition)c);
        c = new ColumnDefinition("d2");
        c.setDataType(6);
        this.dset.addResultSetHint((IColumnDefinition)c);
        this.dset.addComputedColumn((IComputedColumn)new ComputedColumn("CP1", "row.d1.getUTCFullYear()", 2));
        this.dset.addComputedColumn((IComputedColumn)new ComputedColumn("CP2", "row.d2.getUTCFullYear()", 2));
        this.dset.addComputedColumn((IComputedColumn)new ComputedColumn("CP3", "new Date(0)", 6));
        this.dset.setOpenScript("count=0;");
        this.dset.setFetchScript(" if (++count > 1) return false;  row.d1 = new Date(0);row.d2 = new Packages.java.util.Date(0); return true;");
        this.dataEngine.defineDataSource((IBaseDataSourceDesign)this.dsource);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)this.dset);
        QueryDefinition rqDefn = new QueryDefinition();
        rqDefn.setDataSetName(this.dset.getName());
        String e1Name = "_e1";
        String e2Name = "_e2";
        String e3Name = "_e3";
        String e4Name = "_e4";
        String e5Name = "_e5";
        ScriptExpression e1 = new ScriptExpression("dataSetRow.d1");
        ScriptExpression e2 = new ScriptExpression("dataSetRow.d2");
        ScriptExpression e3 = new ScriptExpression("dataSetRow.CP1");
        ScriptExpression e4 = new ScriptExpression("dataSetRow.CP2");
        ScriptExpression e5 = new ScriptExpression("dataSetRow.CP3");
        rqDefn.addResultSetExpression(e1Name, (IBaseExpression)e1);
        rqDefn.addResultSetExpression(e2Name, (IBaseExpression)e2);
        rqDefn.addResultSetExpression(e3Name, (IBaseExpression)e3);
        rqDefn.addResultSetExpression(e4Name, (IBaseExpression)e4);
        rqDefn.addResultSetExpression(e5Name, (IBaseExpression)e5);
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)rqDefn);
        IQueryResults result = preparedQuery.execute(null);
        IResultIterator resultIt = result.getResultIterator();
        Assert.assertTrue((boolean)resultIt.next());
        Assert.assertEquals((long)resultIt.getDate(e1Name).getTime(), (long)0L);
        Assert.assertEquals((long)resultIt.getDate(e2Name).getTime(), (long)0L);
        Assert.assertEquals((long)resultIt.getInteger(e3Name).intValue(), (long)1970L);
        Assert.assertEquals((long)resultIt.getInteger(e4Name).intValue(), (long)1970L);
        Assert.assertEquals((long)resultIt.getDate(e5Name).getTime(), (long)0L);
        Assert.assertFalse((boolean)resultIt.next());
        resultIt.close();
        result.close();
    }

    private void iterateResultSet(ScriptDataSetDesign dataset) throws BirtException {
        dataset.setFetchScript("i++; if(i > 150) return false; else {row.NUM = i;return true;}");
        IPreparedQuery preparedQuery = this.dataEngine.prepare(this.getReportQueryDefn(0, dataset.getName()));
        IQueryResults result = preparedQuery.execute(null);
        IResultIterator resultIt = result.getResultIterator();
        int i = 0;
        while (i < 50) {
            Assert.assertTrue((boolean)resultIt.next());
            ++i;
        }
        resultIt.close();
        result.close();
    }

    private IQueryDefinition getReportQueryDefn(int testUnit) throws BirtException {
        return this.getReportQueryDefn(testUnit, null);
    }

    private IQueryDefinition getReportQueryDefn(int testUnit, String dsetName) throws BirtException {
        QueryDefinition rqDefn = new QueryDefinition();
        rqDefn.setDataSetName(dsetName == null ? "ScriptedDataSet" : dsetName);
        int i = 0;
        while (i < this.scriptExprs.length) {
            ((ScriptExpression)this.scriptExprs[i]).setDataType(this.scriptColumnTypes[i]);
            rqDefn.addResultSetExpression("_" + this.scriptColumnNames[i], (IBaseExpression)this.scriptExprs[i]);
            ++i;
        }
        if (this.ADD_ALIAS) {
            i = 0;
            while (i < this.aliasScriptExprs.length) {
                rqDefn.addResultSetExpression("_" + this.scriptColumnAliasNames[i], (IBaseExpression)this.aliasScriptExprs[i]);
                ++i;
            }
        }
        rqDefn.addResultSetExpression("_groupCol0", (IBaseExpression)new ScriptExpression("dataSetRow.NUM"));
        rqDefn.addResultSetExpression("_sortCol0", (IBaseExpression)new ScriptExpression("dataSetRow.NUM"));
        String[] filterStr = new String[]{"dataSetRow.NUM > 2"};
        rqDefn.addResultSetExpression("_filterCol0", (IBaseExpression)new ScriptExpression(filterStr[0]));
        int i2 = 0;
        while (i2 < filterStr.length) {
            rqDefn.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row._filterCol0")));
            ++i2;
        }
        if (testUnit == 1) {
            SortDefinition sort = new SortDefinition();
            sort.setExpression("row._sortCol0");
            sort.setSortDirection(0);
            rqDefn.addSort(sort);
        }
        if (testUnit == 2) {
            SortDefinition sort = new SortDefinition();
            sort.setExpression("row._sortCol0");
            sort.setSortDirection(0);
            rqDefn.addSort(sort);
            GroupDefinition group = new GroupDefinition("group1");
            group.setKeyExpression("row._groupCol0");
            group.setInterval(99);
            group.setIntervalStart((Object)new Double(3.0));
            group.setIntervalRange(3.0);
            group.setIntervalStart((Object)new Integer(3));
            group.setSortDirection(0);
            this.groupExpr.setGroupName("group1");
            rqDefn.addResultSetExpression(this.groupName, (IBaseExpression)this.groupExpr);
            rqDefn.addGroup((IGroupDefinition)group);
        }
        if (testUnit == 3) {
            IQueryDefinition queryDefinition = this.getReportQueryDefn(0);
            IPreparedQuery pq = this.dataEngine.prepare(queryDefinition);
            IQueryResults qr = pq.execute(this.jsScope);
            IResultIterator resultIterator = qr.getResultIterator();
            int realRows = 0;
            while (resultIterator.next()) {
                ++realRows;
            }
            rqDefn.setMaxRows(realRows / 2);
        }
        if (testUnit == 4) {
            ConditionalExpression conditionExpr = new ConditionalExpression("row._filterCol0", 14, "5");
            FilterDefinition exprFilter = new FilterDefinition((IBaseExpression)conditionExpr);
            rqDefn.addFilter((IFilterDefinition)exprFilter);
        }
        rqDefn.addResultSetExpression(this.queryName, (IBaseExpression)this.queryExpr);
        return rqDefn;
    }
}

