/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class ArchiveUtilTest
extends TestCase {
    static final String ARCHIVE_FILE = "./utest/test.file";
    static final String ARCHIVE_FOLDER = "./utest/test.folder";

    protected static void removeFile(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                ArchiveUtilTest.removeFile(files[i]);
                ++i;
            }
        }
        file.delete();
    }

    @Test
    public void testArchive() throws IOException {
        ArchiveUtilTest.removeFile(new File(ARCHIVE_FOLDER));
        ArchiveUtilTest.removeFile(new File(ARCHIVE_FILE));
        FolderArchiveWriter writer = new FolderArchiveWriter(ARCHIVE_FOLDER);
        writer.initialize();
        this.createArchive((IDocArchiveWriter)writer);
        writer.finish();
        ArchiveUtil.archive((String)ARCHIVE_FOLDER, (String)ARCHIVE_FILE);
        FileArchiveReader reader = new FileArchiveReader(ARCHIVE_FILE);
        reader.open();
        this.checkArchive((IDocArchiveReader)reader);
        reader.close();
    }

    @Test
    public void testExpand() throws IOException {
        ArchiveUtilTest.removeFile(new File(ARCHIVE_FOLDER));
        ArchiveUtilTest.removeFile(new File(ARCHIVE_FILE));
        FileArchiveWriter writer = new FileArchiveWriter(ARCHIVE_FILE);
        writer.initialize();
        this.createArchive((IDocArchiveWriter)writer);
        writer.finish();
        ArchiveUtil.expand((String)ARCHIVE_FILE, (String)ARCHIVE_FOLDER);
        FolderArchiveReader reader = new FolderArchiveReader(ARCHIVE_FOLDER);
        reader.open();
        this.checkArchive((IDocArchiveReader)reader);
        reader.close();
    }

    protected void createArchive(IDocArchiveWriter writer) throws IOException {
        RAOutputStream out = writer.createRandomAccessStream("/core.txt");
        out.writeLong(100L);
        out.seek(0x100000L);
        out.writeLong(100L);
        out.close();
        out = writer.createRandomAccessStream("/folder/core.txt");
        out.seek(100L);
        out.writeLong(100L);
        out.close();
    }

    protected void checkArchive(IDocArchiveReader reader) throws IOException {
        RAInputStream in = reader.getStream("/core.txt");
        ArchiveUtilTest.assertTrue((in != null ? 1 : 0) != 0);
        Assert.assertEquals((long)100L, (long)in.readLong());
        in.seek(0x100000L);
        ArchiveUtilTest.assertEquals((long)100L, (long)in.readLong());
        in.close();
        in = reader.getStream("/folder/core.txt");
        ArchiveUtilTest.assertTrue((in != null ? 1 : 0) != 0);
        in.seek(100L);
        ArchiveUtilTest.assertEquals((long)100L, (long)in.readLong());
        in.close();
    }

    @Test
    public void testSplit() {
        this.assertEQ(new String[]{""}, ArchiveUtil.split((String)"", (char)'/'));
        this.assertEQ(new String[]{"", ""}, ArchiveUtil.split((String)"/", (char)'/'));
        this.assertEQ(new String[]{"", "", ""}, ArchiveUtil.split((String)"//", (char)'/'));
        this.assertEQ(new String[]{"abc"}, ArchiveUtil.split((String)"abc", (char)'/'));
        this.assertEQ(new String[]{"abc", ""}, ArchiveUtil.split((String)"abc/", (char)'/'));
        this.assertEQ(new String[]{"", "abc"}, ArchiveUtil.split((String)"/abc", (char)'/'));
        this.assertEQ(new String[]{"", "abc", ""}, ArchiveUtil.split((String)"/abc/", (char)'/'));
    }

    @Test
    public void testRelativePath() {
        String[][] tests;
        String[][] stringArrayArray = tests = new String[][]{{"/test", "/", "/test"}, {"/test/", "/root/", "/root/test/"}, {"/test/", "/root", "/root/test/"}, {"/test", "/root/", "/root/test"}, {"/test", "/root", "/root/test"}, {"/test", "\\root/", "/root\\test"}, {"/test", "\\root", "/root\\test"}, {"/", "/root", "/root/"}, {"/", "/root/", "/root/"}, {"/", "/root/", "/root"}, {"/", "/root", "/root"}};
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            String[] test = stringArrayArray[n2];
            String relative = test[0];
            String root = test[1];
            String path = test[2];
            ArchiveUtilTest.assertEquals((String)relative, (String)ArchiveUtil.getRelativePath((String)root, (String)path));
            ++n2;
        }
    }

    @Test
    public void testFullPath() {
        String[][] tests;
        String[][] stringArrayArray = tests = new String[][]{{"/root/", "/root", "/"}, {"/root/", "/root/", "/"}, {"/root/", "/root", "/"}, {"/root/abc", "/root", "/abc"}, {"/root/abc", "/root", "abc"}, {"/root/abc", "/root/", "abc"}, {"/root/abc", "/root/", "abc"}, {"/root/abc/", "/root", "/abc/"}, {"/root/abc/", "/root", "abc/"}, {"/root/abc/", "/root/", "abc/"}, {"/root/abc/", "/root/", "abc/"}};
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            String[] test = stringArrayArray[n2];
            String path = test[0];
            String root = test[1];
            String relative = test[2];
            ArchiveUtilTest.assertEquals((String)path, (String)ArchiveUtil.getFullPath((String)root, (String)relative));
            ++n2;
        }
    }

    @Test
    public void testEntryToFile() {
        ArchiveUtilTest.assertEquals((String)"/", (String)ArchiveUtil.getFilePath((String)"/"));
        ArchiveUtilTest.assertEquals((String)"/test", (String)ArchiveUtil.getFilePath((String)"/test"));
        ArchiveUtilTest.assertEquals((String)"/test/", (String)ArchiveUtil.getFilePath((String)"/test/"));
        ArchiveUtilTest.assertEquals((String)"/%2F/test/", (String)ArchiveUtil.getFilePath((String)"//test/"));
        ArchiveUtilTest.assertEquals((String)"/test/%2F/", (String)ArchiveUtil.getFilePath((String)"/test//"));
        ArchiveUtilTest.assertEquals((String)"/%2E", (String)ArchiveUtil.getFilePath((String)"."));
        ArchiveUtilTest.assertEquals((String)"/%2E", (String)ArchiveUtil.getFilePath((String)"/."));
        ArchiveUtilTest.assertEquals((String)"/%2E%2E", (String)ArchiveUtil.getFilePath((String)".."));
        ArchiveUtilTest.assertEquals((String)"/%2E%2E", (String)ArchiveUtil.getFilePath((String)"/.."));
        ArchiveUtilTest.assertEquals((String)"/%2E%2E%2E", (String)ArchiveUtil.getFilePath((String)"/..."));
        ArchiveUtilTest.assertEquals((String)"/%2F/", (String)ArchiveUtil.getFilePath((String)"//"));
        ArchiveUtilTest.assertEquals((String)"/%2F/%2F/", (String)ArchiveUtil.getFilePath((String)"///"));
        ArchiveUtilTest.assertEquals((String)"/%2A", (String)ArchiveUtil.getFilePath((String)"*"));
        ArchiveUtilTest.assertEquals((String)"/%40%23%24%25%5E%26%2A%3E", (String)ArchiveUtil.getFilePath((String)"/@#$%^&*>"));
    }

    @Test
    public void testFileToEntry() {
        ArchiveUtilTest.assertEquals((String)"/", (String)ArchiveUtil.getEntryName((String)"/"));
        ArchiveUtilTest.assertEquals((String)"/.", (String)ArchiveUtil.getEntryName((String)"/%2E"));
        ArchiveUtilTest.assertEquals((String)"/..", (String)ArchiveUtil.getEntryName((String)"/%2E%2E"));
        ArchiveUtilTest.assertEquals((String)"/./", (String)ArchiveUtil.getEntryName((String)"/%2E/"));
        ArchiveUtilTest.assertEquals((String)"/../", (String)ArchiveUtil.getEntryName((String)"/%2E%2E/"));
        ArchiveUtilTest.assertEquals((String)"/...", (String)ArchiveUtil.getEntryName((String)"/%2E%2E%2E"));
        ArchiveUtilTest.assertEquals((String)"//", (String)ArchiveUtil.getEntryName((String)"/%2F/"));
        ArchiveUtilTest.assertEquals((String)"/", (String)ArchiveUtil.getEntryName((String)"/%2F"));
        ArchiveUtilTest.assertEquals((String)"//", (String)ArchiveUtil.getEntryName((String)"/%2F/%2F"));
        ArchiveUtilTest.assertEquals((String)"///", (String)ArchiveUtil.getEntryName((String)"/%2F/%2F/"));
        ArchiveUtilTest.assertEquals((String)"/*", (String)ArchiveUtil.getEntryName((String)"/%2A"));
        ArchiveUtilTest.assertEquals((String)"/@#$%^&*>", (String)ArchiveUtil.getEntryName((String)"/%40%23%24%25%5E%26%2A%3E"));
    }

    @Test
    public void testFolderCreation() {
        String EncodedFileName = ArchiveUtil.getFilePath((String)"/@#$%^&*>");
        File createdFile = new File(ARCHIVE_FOLDER + EncodedFileName);
        ArchiveUtilTest.assertEquals((String)EncodedFileName.substring(1), (String)createdFile.getName());
    }

    private void assertEQ(String[] v1, String[] v2) {
        ArchiveUtilTest.assertEquals((int)v1.length, (int)v2.length);
        int i = 0;
        while (i < v1.length) {
            ArchiveUtilTest.assertEquals((String)v1[i], (String)v2[i]);
            ++i;
        }
    }
}

