/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.shared.common.util.ArrayUtil;

public class ReferencedColumnsDescriptorImpl
implements ReferencedColumns,
Formatable {
    private int[] referencedColumns;
    private int[] referencedColumnsInTriggerAction;

    public ReferencedColumnsDescriptorImpl(int[] referencedColumns) {
        this.referencedColumns = ArrayUtil.copy(referencedColumns);
    }

    public ReferencedColumnsDescriptorImpl(int[] referencedColumns, int[] referencedColumnsInTriggerAction) {
        this.referencedColumns = ArrayUtil.copy(referencedColumns);
        this.referencedColumnsInTriggerAction = ArrayUtil.copy(referencedColumnsInTriggerAction);
    }

    public ReferencedColumnsDescriptorImpl() {
    }

    @Override
    public int[] getReferencedColumnPositions() {
        return ArrayUtil.copy(this.referencedColumns);
    }

    @Override
    public int[] getTriggerActionReferencedColumnPositions() {
        return ArrayUtil.copy(this.referencedColumnsInTriggerAction);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int rcLength;
        int versionNumber = in.readInt();
        if (versionNumber < 0) {
            rcLength = in.readInt();
            if (rcLength < 0) {
                rcLength = 0;
            } else {
                this.referencedColumns = new int[rcLength];
            }
        } else {
            rcLength = versionNumber;
            this.referencedColumns = new int[rcLength];
        }
        for (int i = 0; i < rcLength; ++i) {
            this.referencedColumns[i] = in.readInt();
        }
        if (versionNumber < 0) {
            int rctaLength = in.readInt();
            this.referencedColumnsInTriggerAction = new int[rctaLength];
            for (int i = 0; i < rctaLength; ++i) {
                this.referencedColumnsInTriggerAction[i] = in.readInt();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int versionNumber;
        int n = versionNumber = this.referencedColumnsInTriggerAction == null ? this.referencedColumns.length : -1;
        if (versionNumber < 0) {
            out.writeInt(versionNumber);
            if (this.referencedColumns != null) {
                this.writeReferencedColumns(out);
            } else {
                out.writeInt(versionNumber);
            }
            out.writeInt(this.referencedColumnsInTriggerAction.length);
            for (int i = 0; i < this.referencedColumnsInTriggerAction.length; ++i) {
                out.writeInt(this.referencedColumnsInTriggerAction[i]);
            }
        } else {
            this.writeReferencedColumns(out);
        }
    }

    private void writeReferencedColumns(ObjectOutput out) throws IOException {
        out.writeInt(this.referencedColumns.length);
        for (int i = 0; i < this.referencedColumns.length; ++i) {
            out.writeInt(this.referencedColumns[i]);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 205;
    }

    public String toString() {
        if (this.referencedColumns == null) {
            return "NULL";
        }
        StringBuffer sb = new StringBuffer(60);
        sb.append('(');
        for (int index = 0; index < this.referencedColumns.length; ++index) {
            if (index > 0) {
                sb.append(',');
            }
            sb.append(String.valueOf(this.referencedColumns[index]));
        }
        sb.append(')');
        return sb.toString();
    }
}

