/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.eclipse.birt.report.engine.util.SvgFile;
import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.Area;
import uk.co.spudsoft.birt.emitters.excel.AreaBorders;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.CellImage;
import uk.co.spudsoft.birt.emitters.excel.ClientAnchorConversions;
import uk.co.spudsoft.birt.emitters.excel.Coordinate;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.RichTextRun;
import uk.co.spudsoft.birt.emitters.excel.StyleManager;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;

public class CellContentHandler
extends AbstractHandler {
    private static final long oneDay = 86400000L;
    protected Object lastValue;
    protected String lastFormula;
    protected IContent lastElement;
    protected List<RichTextRun> richTextRuns = new ArrayList<RichTextRun>();
    protected boolean lastCellContentsWasBlock;
    protected boolean lastCellContentsRequiresSpace;
    protected int colSpan;
    protected ContentEmitterVisitor contentVisitor;
    protected CSSValue preferredAlignment;
    protected String hyperlinkUrl;
    protected String hyperlinkBookmark;
    private static final String URL_IMAGE_TYPE_SVG = "image/svg+xml";
    private static final String URL_PROTOCOL_TYPE_FILE = "file:";
    private static final String URL_PROTOCOL_TYPE_DATA = "data:";
    private static final String URL_PROTOCOL_TYPE_DATA_BASE = ";base64,";
    private static final String URL_PROTOCOL_TYPE_DATA_UTF8 = ";utf8,";
    private static final String URL_PROTOCOL_URL_ENCODED_SPACE = "%20";
    private static final String STYLE_OVERLAY_DEFAULT_UNIT = "mm";
    private static final double DOTS_PER_INCH = 96.0;

    public CellContentHandler(IContentEmitter emitter, Logger log, IHandler parent, ICellContent cell) {
        super(log, parent, cell);
        this.contentVisitor = new ContentEmitterVisitor(emitter);
        this.colSpan = 1;
    }

    @Override
    public void startCell(HandlerState state, ICellContent cell) throws BirtException {
        if (cell.getBookmark() != null) {
            System.err.println("Bookmark: " + cell.getBookmark());
        }
    }

    protected void endCellContent(HandlerState state, ICellContent birtCell, IContent element, Cell cell, Area area) {
        float rowSpanHeightRequirement;
        AreaBorders mergedRegionBorders;
        Hyperlink hyperlink;
        StyleManager sm = state.getSm();
        StyleManagerUtils smu = state.getSmu();
        BirtStyle birtCellStyle = null;
        boolean isStyleExactCopy = false;
        if (birtCell != null) {
            birtCellStyle = new BirtStyle(birtCell);
            if (element != null) {
                birtCellStyle.overlay(element);
            }
        } else if (element != null) {
            birtCellStyle = new BirtStyle(element);
            isStyleExactCopy = true;
        } else {
            birtCellStyle = new BirtStyle(state.getSm().getCssEngine());
        }
        if (this.preferredAlignment != null) {
            birtCellStyle.setProperty(37, this.preferredAlignment);
        }
        if ("transparent".equals(birtCellStyle.getString(41)) && this.parent != null) {
            birtCellStyle.setProperty(41, this.parent.getBackgroundColour());
        }
        birtCellStyle.setTextIndentInUse(EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), element, "ExcelEmitter.DisplayTextIndent", true));
        birtCellStyle.setTextIndentMode(EmitterServices.stringOption((ITaskOption)state.getRenderOptions(), element, "ExcelEmitter.TextIndentMode", "SpacingAll"));
        if (this.hyperlinkUrl != null) {
            hyperlink = cell.getSheet().getWorkbook().getCreationHelper().createHyperlink(HyperlinkType.URL);
            hyperlink.setAddress(this.hyperlinkUrl);
            cell.setHyperlink(hyperlink);
            if (birtCellStyle.getProperty(40).getCssText().equals("normal")) {
                birtCellStyle.setProperty(66, new StringValue(19, "blue"));
                birtCellStyle.setProperty(60, new StringValue(19, "underline"));
            }
        }
        if (this.hyperlinkBookmark != null) {
            hyperlink = cell.getSheet().getWorkbook().getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
            hyperlink.setAddress(CellContentHandler.prepareName(this.hyperlinkBookmark));
            cell.setHyperlink(hyperlink);
            if (birtCellStyle.getProperty(40).getCssText().equals("normal")) {
                birtCellStyle.setProperty(66, new StringValue(19, "blue"));
                birtCellStyle.setProperty(60, new StringValue(19, "underline"));
            }
        }
        if (this.lastFormula != null && this.lastValue == null) {
            this.setCellContents(cell, null, this.lastFormula);
        }
        if (this.lastValue != null) {
            if (this.lastValue instanceof String) {
                String lastString = (String)this.lastValue;
                smu.correctFontColorIfBackground(birtCellStyle);
                for (RichTextRun run : this.richTextRuns) {
                    run.font = smu.correctFontColorIfBackground(sm.getFontManager(), state.getWb(), birtCellStyle, run.font);
                }
                if (!this.richTextRuns.isEmpty()) {
                    RichTextString rich = smu.createRichTextString(lastString);
                    int runStart = this.richTextRuns.get((int)0).startIndex;
                    Font lastFont = this.richTextRuns.get((int)0).font;
                    int i = 0;
                    while (i < this.richTextRuns.size()) {
                        RichTextRun run = this.richTextRuns.get(i);
                        this.log.debug("Run: ", run.startIndex, " font :", run.font);
                        if (!lastFont.equals(run.font)) {
                            this.log.debug("Applying ", runStart, " - ", run.startIndex);
                            rich.applyFont(runStart, run.startIndex, lastFont);
                            runStart = run.startIndex;
                            lastFont = this.richTextRuns.get((int)i).font;
                        }
                        ++i;
                    }
                    this.log.debug("Finalising with ", runStart, " - ", lastString.length());
                    rich.applyFont(runStart, lastString.length(), lastFont);
                    this.setCellContents(cell, rich, this.lastFormula);
                } else {
                    this.setCellContents(cell, lastString, this.lastFormula);
                }
                if (birtCell != null) {
                    if (lastString.contains("\n") && !"nowrap".equals(this.lastElement.getStyle().getWhiteSpace())) {
                        birtCellStyle.setProperty(61, new StringValue(19, "pre"));
                    }
                    if (this.preferredAlignment != null) {
                        birtCellStyle.setProperty(37, this.preferredAlignment);
                    }
                }
            } else {
                this.setCellContents(cell, this.lastValue, this.lastFormula);
            }
        }
        if (birtCell != null && birtCell.getDiagonalNumber() >= 1 && !"none".equalsIgnoreCase(birtCell.getDiagonalStyle())) {
            String diagonalWidth = null;
            if (birtCell.getDiagonalWidth() != null) {
                diagonalWidth = birtCell.getDiagonalWidth().toString();
            }
            birtCellStyle.setProperty(11, new StringValue(19, diagonalWidth));
            birtCellStyle.setProperty(7, new StringValue(19, birtCell.getDiagonalColor()));
            birtCellStyle.setProperty(22, new StringValue(19, birtCell.getDiagonalStyle()));
        }
        if (birtCell != null && birtCell.getAntidiagonalNumber() >= 1 && !"none".equalsIgnoreCase(birtCell.getAntidiagonalStyle())) {
            String antidiagonalWidth = null;
            if (birtCell.getAntidiagonalWidth() != null) {
                antidiagonalWidth = birtCell.getAntidiagonalWidth().toString();
            }
            birtCellStyle.setProperty(18, new StringValue(19, antidiagonalWidth));
            birtCellStyle.setProperty(14, new StringValue(19, birtCell.getAntidiagonalColor()));
            birtCellStyle.setProperty(25, new StringValue(19, birtCell.getAntidiagonalStyle()));
        }
        int colIndex = cell.getColumnIndex();
        if (birtCellStyle != null) {
            state.getSmu().applyAreaBordersToCell(state.areaBorders, cell, birtCellStyle, state.rowNum, colIndex);
        }
        if (birtCell != null && (birtCell.getColSpan() > 1 || birtCell.getRowSpan() > 1) && (mergedRegionBorders = AreaBorders.createForMergedCells(state.rowNum + birtCell.getRowSpan() - 1, colIndex, colIndex + birtCell.getColSpan() - 1, state.rowNum, 1, 1, birtCellStyle)) != null) {
            state.insertBorderOverload(mergedRegionBorders);
        }
        if (birtCellStyle != null) {
            String customNumberFormat = EmitterServices.stringOption((ITaskOption)state.getRenderOptions(), element, "ExcelEmitter.CustomNumberFormat", null);
            if (customNumberFormat != null) {
                StyleManagerUtils.setNumberFormat(birtCellStyle, "ExcelEmitter.CustomNumberFormat" + customNumberFormat, null);
            }
            this.overlayBirtCellStyleSpacing(smu, birtCellStyle, element, isStyleExactCopy);
            this.setCellStyle(sm, cell, birtCellStyle, this.lastValue);
        }
        if ((this.colSpan > 1 || state.rowHasSpans(state.rowNum)) && (this.lastValue instanceof String || this.lastValue instanceof RichTextString)) {
            int spannedRowAlgorithm = EmitterServices.integerOption(state.getRenderOptions(), element, "ExcelEmitter.SpannedRowHeight", 0);
            Font defaultFont = state.getWb().getFontAt(cell.getCellStyle().getFontIndex());
            double cellWidth = this.spanWidthMillimetres(state.currentSheet, cell.getColumnIndex(), cell.getColumnIndex() + this.colSpan - 1);
            float cellDesiredHeight = smu.calculateTextHeightPoints(cell.getStringCellValue(), defaultFont, cellWidth, this.richTextRuns, cell.getCellStyle().getWrapText());
            if (cellDesiredHeight > state.requiredRowHeightInPoints) {
                int rowSpan = birtCell.getRowSpan();
                if (rowSpan < 2) {
                    state.requiredRowHeightInPoints = cellDesiredHeight;
                } else {
                    switch (spannedRowAlgorithm) {
                        case 1: {
                            state.requiredRowHeightInPoints = cellDesiredHeight;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            if (area == null) break;
                            area.setHeight(cellDesiredHeight);
                        }
                    }
                }
            }
        }
        if ((rowSpanHeightRequirement = state.calculateRowSpanHeightRequirement(state.rowNum)) > state.requiredRowHeightInPoints) {
            state.requiredRowHeightInPoints = rowSpanHeightRequirement;
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), element, "ExcelEmitter.FreezePanes", false) && state.currentSheet.getPaneInformation() == null) {
            state.currentSheet.createFreezePane(state.colNum, state.rowNum);
        }
        this.lastValue = null;
        this.lastFormula = null;
        this.lastElement = null;
        this.richTextRuns.clear();
    }

    private BirtStyle overlayBirtCellStyleSpacing(StyleManagerUtils smu, BirtStyle birtCellStyle, IContent element, boolean isStyleExactCopy) {
        if (element != null && element.getStyle() != null) {
            IStyle elemStyle = element.getStyle();
            IContent fc = null;
            double paddingLeftValueElementContent = 0.0;
            double paddingRightValueElementContent = 0.0;
            try {
                fc = (IContent)element.getParent().getParent();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fc != null && fc instanceof IForeignContent && fc.getStyle() != null) {
                elemStyle = fc.getStyle();
            }
            if (!isStyleExactCopy) {
                String paddingLeftElementContent = elemStyle.getProperty(12) != null ? elemStyle.getProperty(12).getCssText() : "0mm";
                String paddingRightElementContent = elemStyle.getProperty(16) != null ? elemStyle.getProperty(16).getCssText() : "0mm";
                paddingLeftValueElementContent = smu.convertDimensionToMillimetres(DimensionType.parserUnit(paddingLeftElementContent));
                paddingRightValueElementContent = smu.convertDimensionToMillimetres(DimensionType.parserUnit(paddingRightElementContent));
            }
            CSSValue marginLeftElementContent = elemStyle.getProperty(0);
            CSSValue marginRightElementContent = elemStyle.getProperty(1);
            String paddingLeftCellContent = birtCellStyle.getProperty(12) != null ? birtCellStyle.getProperty(12).getCssText() : "0mm";
            String paddingRightCellContent = birtCellStyle.getProperty(16) != null ? birtCellStyle.getProperty(16).getCssText() : "0mm";
            double paddingLeftValueCellContent = smu.convertDimensionToMillimetres(DimensionType.parserUnit(paddingLeftCellContent));
            double paddingRightValueCellContent = smu.convertDimensionToMillimetres(DimensionType.parserUnit(paddingRightCellContent));
            if (birtCellStyle.getTextIndentMode().equals("SpacingCell")) {
                marginLeftElementContent = new StringValue(19, "0mm");
                marginRightElementContent = new StringValue(19, "0mm");
                paddingLeftValueElementContent = 0.0;
                paddingRightValueElementContent = 0.0;
            } else if (birtCellStyle.getTextIndentMode().equals("SpacingElement")) {
                paddingLeftValueCellContent = 0.0;
                paddingRightValueCellContent = 0.0;
            }
            double paddingLeftValueNew = (double)Math.round((paddingLeftValueElementContent + paddingLeftValueCellContent) * 1000.0) / 1000.0;
            double paddingRightValueNew = (double)Math.round((paddingRightValueElementContent + paddingRightValueCellContent) * 1000.0) / 1000.0;
            birtCellStyle.setProperty(0, marginLeftElementContent);
            birtCellStyle.setProperty(1, marginRightElementContent);
            birtCellStyle.setProperty(12, new StringValue(19, paddingLeftValueNew + STYLE_OVERLAY_DEFAULT_UNIT));
            birtCellStyle.setProperty(16, new StringValue(19, paddingRightValueNew + STYLE_OVERLAY_DEFAULT_UNIT));
            if (elemStyle.getProperty(41) != null) {
                birtCellStyle.setProperty(41, elemStyle.getProperty(41));
            }
            if (elemStyle.getProperty(66) != null) {
                birtCellStyle.setProperty(66, elemStyle.getProperty(66));
            }
        }
        return birtCellStyle;
    }

    private double spanWidthMillimetres(Sheet sheet, int startCol, int endCol) {
        int result = 0;
        int columnIndex = startCol;
        while (columnIndex <= endCol) {
            result += sheet.getColumnWidth(columnIndex);
            ++columnIndex;
        }
        return ClientAnchorConversions.widthUnits2Millimetres(result);
    }

    private <T> void setCellContents(Cell cell, Object value, String formula) {
        this.log.debug("Setting cell[", cell.getRow().getRowNum(), ",", cell.getColumnIndex(), "] value to ", value);
        if (formula != null) {
            if ((formula = formula.trim()).startsWith("=")) {
                formula = formula.substring(1).trim();
                cell.setCellFormula(formula);
            } else {
                value = formula;
                formula = null;
            }
        }
        if (value != null) {
            if (value instanceof Double) {
                cell.setCellValue(((Double)value).doubleValue());
                this.lastValue = value;
            } else if (value instanceof Integer) {
                cell.setCellValue((double)((Integer)value).intValue());
                this.lastValue = value;
            } else if (value instanceof Long) {
                cell.setCellValue((double)((Long)value).longValue());
                this.lastValue = value;
            } else if (value instanceof Date) {
                cell.setCellValue((Date)value);
                this.lastValue = value;
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
                this.lastValue = value;
            } else if (value instanceof BigDecimal) {
                cell.setCellValue(((BigDecimal)value).doubleValue());
                this.lastValue = value;
            } else if (value instanceof String) {
                cell.setCellValue((String)value);
                this.lastValue = value;
            } else if (value instanceof RichTextString) {
                cell.setCellValue((RichTextString)value);
                this.lastValue = value;
            } else if (value != null) {
                this.log.debug("Unhandled data: ", value == null ? "<null>" : value);
                cell.setCellValue(value.toString());
                this.lastValue = value;
            }
        }
    }

    private void setCellStyle(StyleManager sm, Cell cell, BirtStyle birtStyle, Object value) {
        if (StyleManagerUtils.getNumberFormat(birtStyle) == null && StyleManagerUtils.getDateFormat(birtStyle) == null && StyleManagerUtils.getDateTimeFormat(birtStyle) == null && StyleManagerUtils.getTimeFormat(birtStyle) == null && value != null && value instanceof Date) {
            long time = ((Date)value).getTime();
            if ((time -= (long)(((Date)value).getTimezoneOffset() * 60000)) % 86400000L == 0L) {
                StyleManagerUtils.setDateFormat(birtStyle, "Short Date", null);
            } else if (time < 86400000L) {
                StyleManagerUtils.setTimeFormat(birtStyle, "Short Time", null);
            } else {
                StyleManagerUtils.setDateTimeFormat(birtStyle, "General Date", null);
            }
        }
        CellStyle cellStyle = sm.getStyle(birtStyle);
        cell.setCellStyle(cellStyle);
    }

    private CSSValue preferredAlignment(BirtStyle elementStyle) {
        CSSValue newAlign = elementStyle.getProperty(37);
        if (newAlign == null) {
            newAlign = new StringValue(19, "left");
        }
        if (this.preferredAlignment == null) {
            return newAlign;
        }
        if ("left".equals(newAlign.getCssText())) {
            return newAlign;
        }
        if ("right".equals(newAlign.getCssText())) {
            if ("center".equals(this.preferredAlignment.getCssText())) {
                return newAlign;
            }
            return this.preferredAlignment;
        }
        return this.preferredAlignment;
    }

    protected void emitContent(HandlerState state, IContent element, Object value, boolean asBlock) {
        String formula;
        if (value == null) {
            return;
        }
        if (element.getBookmark() != null) {
            this.createName(state, CellContentHandler.prepareName(element.getBookmark()), state.rowNum, state.colNum, state.rowNum, state.colNum);
        }
        if ((formula = EmitterServices.stringOption(null, element, "ExcelEmitter.Formula", null)) == null && EmitterServices.booleanOption(null, element, "ExcelEmitter.ValueAsFormula", false)) {
            formula = value != null ? value.toString() : null;
            value = null;
        }
        if (this.lastFormula == null && formula != null) {
            this.lastFormula = formula;
        }
        if (value == null && formula == null) {
            return;
        }
        if (this.lastValue == null && (value != null || formula != null)) {
            this.lastValue = value != null ? value : formula;
            this.lastElement = element;
            this.lastCellContentsWasBlock = asBlock;
            IHyperlinkAction birtHyperlink = element.getHyperlinkAction();
            if (birtHyperlink != null) {
                switch (birtHyperlink.getType()) {
                    case 1: {
                        this.hyperlinkUrl = birtHyperlink.getHyperlink();
                        break;
                    }
                    case 2: {
                        this.hyperlinkBookmark = birtHyperlink.getBookmark();
                        break;
                    }
                    case 3: {
                        IHTMLActionHandler handler = state.getRenderOptions().getActionHandler();
                        if (handler == null) break;
                        this.hyperlinkUrl = handler.getURL((IAction)new Action(null, birtHyperlink), element.getReportContent().getReportContext());
                        break;
                    }
                    default: {
                        this.log.debug("Unhandled hyperlink type: {}", birtHyperlink.getType());
                    }
                }
            }
            return;
        }
        StyleManager sm = state.getSm();
        if (this.lastValue != null && (value != null || formula != null)) {
            String newFormula;
            value = value != null ? value : formula;
            Object oldValue = this.lastValue.toString();
            String newComponent = value.toString();
            if (this.lastCellContentsWasBlock && !newComponent.startsWith("\n") && !((String)oldValue).endsWith("\n")) {
                oldValue = (String)oldValue + "\n";
                this.lastCellContentsWasBlock = false;
            }
            if (this.lastCellContentsRequiresSpace && !newComponent.startsWith("\n") && !((String)oldValue).endsWith("\n")) {
                oldValue = (String)oldValue + " ";
                this.lastCellContentsRequiresSpace = false;
            }
            String newValue = (String)oldValue + newComponent;
            this.lastValue = newValue;
            String oldformula = this.lastFormula != null ? this.lastFormula.toString() : this.lastFormula;
            String string = newFormula = formula != null ? formula.toString() : formula;
            if (oldformula != null) {
                this.lastFormula = oldformula + "\n";
            }
            if (newFormula != null) {
                this.lastFormula = String.valueOf(this.lastFormula) + newFormula;
            }
            if (element != null) {
                BirtStyle elementStyle = new BirtStyle(element);
                Font newFont = sm.getFontManager().getFont(elementStyle);
                this.richTextRuns.add(new RichTextRun(((String)oldValue).length(), newFont));
                this.preferredAlignment = this.preferredAlignment(elementStyle);
            }
        }
        this.lastCellContentsWasBlock = asBlock;
        this.hyperlinkUrl = null;
    }

    public void recordImage(HandlerState state, Coordinate location, IImageContent image, boolean spanColumns) throws BirtException {
        byte[] data = image.getData();
        this.log.debug("startImage: [" + image.getMIMEType() + "] {" + String.valueOf(image.getWidth()) + " x " + String.valueOf(image.getHeight()) + "} " + (String)(data == null ? "(no data) " : "(" + data.length + " bytes) ") + image.getURI());
        StyleManagerUtils smu = state.getSmu();
        Workbook wb = state.getWb();
        String mimeType = image.getMIMEType();
        String stringURI = image.getURI();
        if (stringURI != null && (stringURI.toLowerCase().endsWith(".svg") || stringURI.toLowerCase().contains(URL_IMAGE_TYPE_SVG)) || mimeType != null && mimeType.toLowerCase().equals(URL_IMAGE_TYPE_SVG)) {
            try {
                String encodedImg = null;
                String decodedImg = null;
                if (stringURI != null && stringURI.toLowerCase().contains(URL_IMAGE_TYPE_SVG)) {
                    String svgSplitter = "svg\\+xml,";
                    if (stringURI.contains("image/svg+xml;utf8,")) {
                        svgSplitter = "svg\\+xml;utf8,";
                    } else if (stringURI.contains("image/svg+xml;base64,")) {
                        svgSplitter = "svg\\+xml;base64,";
                    }
                    String[] uriParts = stringURI.split(svgSplitter);
                    if (uriParts.length >= 2) {
                        decodedImg = encodedImg = uriParts[1];
                        if (stringURI.contains(URL_PROTOCOL_TYPE_DATA_BASE)) {
                            decodedImg = new String(Base64.getDecoder().decode(encodedImg.getBytes(StandardCharsets.UTF_8)));
                        }
                    }
                } else {
                    if (data == null && stringURI != null) {
                        String uri = this.verifyURI(stringURI);
                        URL imageUrl = new URL(uri);
                        URLConnection conn = imageUrl.openConnection();
                        conn.connect();
                        data = smu.downloadImage(conn);
                        image.setData(data);
                    }
                    decodedImg = new String(image.getData());
                }
                try {
                    decodedImg = URLDecoder.decode(decodedImg, StandardCharsets.UTF_8);
                }
                catch (IllegalArgumentException uri) {
                    // empty catch block
                }
                data = SvgFile.transSvgToArray(new ByteArrayInputStream(decodedImg.getBytes()));
            }
            catch (Exception encodedImg) {}
        } else if (stringURI != null && stringURI.startsWith(URL_PROTOCOL_TYPE_DATA) && stringURI.contains(URL_PROTOCOL_TYPE_DATA_BASE)) {
            String[] base64 = image.getURI().toString().split(URL_PROTOCOL_TYPE_DATA_BASE);
            if (base64.length >= 2) {
                data = Base64.getDecoder().decode(base64[1]);
            }
        } else if (data == null && image.getURI() != null) {
            try {
                URL imageUrl = new URL(this.verifyURI(image.getURI()));
                URLConnection conn = imageUrl.openConnection();
                conn.connect();
                mimeType = conn.getContentType();
                int imageType = smu.poiImageTypeFromMimeType(mimeType, null);
                if (imageType == 0) {
                    this.log.debug("Unrecognised/unhandled image MIME type: " + mimeType);
                } else {
                    data = smu.downloadImage(conn);
                    image.setData(data);
                }
            }
            catch (IOException ex) {
                this.log.debug(ex.getClass(), ": ", ex.getMessage());
                ex.printStackTrace();
            }
        }
        if (data != null) {
            int imageType = smu.poiImageTypeFromMimeType(mimeType, data);
            if (imageType == 0) {
                this.log.debug("Unrecognised/unhandled image MIME type: ", image.getMIMEType());
            } else {
                int imageIdx = wb.addPicture(data, imageType);
                if (image.getHeight() == null || image.getWidth() == null) {
                    Image birtImage = new Image();
                    birtImage.setInput(data);
                    birtImage.check();
                    this.log.debug("Calculated image dimensions " + birtImage.getWidth() + " (@" + birtImage.getPhysicalWidthDpi() + "dpi=" + birtImage.getPhysicalWidthInch() + "in) x " + birtImage.getHeight() + " (@" + birtImage.getPhysicalHeightDpi() + "dpi=" + birtImage.getPhysicalHeightInch() + "in)");
                    if (image.getWidth() == null) {
                        DimensionType Width;
                        if (image.getHeight() != null) {
                            double factor = (double)birtImage.getWidth() * 1.0 / (double)birtImage.getHeight() * 1.0;
                            double imgWidth = image.getHeight().getMeasure() * factor;
                            Width = new DimensionType(imgWidth, image.getHeight().getUnits());
                        } else {
                            Width = new DimensionType(birtImage.getPhysicalWidthInch() > 0.0f ? (double)birtImage.getPhysicalWidthInch() : (double)birtImage.getWidth() / 96.0, "in");
                        }
                        image.setWidth(Width);
                    }
                    if (image.getHeight() == null && birtImage.getWidth() > 0 && birtImage.getHeight() > 0) {
                        DimensionType Height;
                        if (image.getWidth() != null) {
                            double factor = (double)birtImage.getHeight() * 1.0 / (double)birtImage.getWidth() * 1.0;
                            double imgHeight = image.getWidth().getMeasure() * factor;
                            Height = new DimensionType(imgHeight, image.getWidth().getUnits());
                        } else {
                            Height = new DimensionType(birtImage.getPhysicalHeightInch() > 0.0f ? (double)birtImage.getPhysicalHeightInch() : (double)birtImage.getHeight() / 96.0, "in");
                        }
                        image.setHeight(Height);
                    }
                }
                if (this.element != null) {
                    state.images.add(new CellImage(location, imageIdx, image, spanColumns, this.element.getComputedStyle().getTextAlign(), this.element.getComputedStyle().getVerticalAlign()));
                } else {
                    state.images.add(new CellImage(location, imageIdx, image, spanColumns));
                }
                this.lastElement = image;
            }
        }
    }

    protected void removeMergedCell(HandlerState state, int row, int col) {
        int mergeNum = 0;
        while (mergeNum < state.currentSheet.getNumMergedRegions()) {
            CellRangeAddress region = state.currentSheet.getMergedRegion(mergeNum);
            if (region.getFirstRow() == row && region.getFirstColumn() == col) {
                state.currentSheet.removeMergedRegion(mergeNum);
                break;
            }
            ++mergeNum;
        }
        Iterator<Area> iter = state.rowSpans.iterator();
        while (iter.hasNext()) {
            Area area = iter.next();
            Coordinate topLeft = area.getX();
            if (topLeft.getRow() != row && topLeft.getCol() != col) continue;
            iter.remove();
        }
    }

    private String verifyURI(String uri) {
        if (uri != null && !((String)uri).toLowerCase().startsWith(URL_PROTOCOL_TYPE_DATA)) {
            Object tmpUrl = ((String)uri).replaceAll(" ", URL_PROTOCOL_URL_ENCODED_SPACE);
            try {
                new URL((String)tmpUrl).toURI();
            }
            catch (MalformedURLException | URISyntaxException excUrl) {
                try {
                    tmpUrl = "file:///" + (String)uri;
                    new URL((String)tmpUrl).toURI();
                    uri = tmpUrl;
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        }
        return uri;
    }
}

