/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.internal.adapter;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSourceDesign;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.impl.ModelAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.DataAdapterUtil;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedPropertyHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.mozilla.javascript.Scriptable;

public class OdaDataSourceAdapter
extends OdaDataSourceDesign {
    public OdaDataSourceAdapter(OdaDataSourceHandle source, Scriptable propBindingScope, DataEngineContext dtCotnext, ModelAdapter adapter) throws BirtException {
        super(source.getQualifiedName());
        Iterator elmtIter;
        DataAdapterUtil.adaptBaseDataSource(source, this);
        String driverName = source.getExtensionID();
        if (driverName == null || driverName.length() == 0) {
            throw new AdapterException("datasource.exid.error", source.getName());
        }
        this.setExtensionID(driverName);
        Map staticProps = DataAdapterUtil.getExtensionProperties(source, source.getExtensionPropertyDefinitionList());
        if (staticProps != null && !staticProps.isEmpty()) {
            for (String propName : staticProps.keySet()) {
                Object value;
                assert (propName != null);
                String propValue = "";
                Expression expression = source.getPropertyBindingExpression(propName);
                org.eclipse.birt.data.engine.api.querydefn.ScriptExpression script = adapter.adaptExpression(expression);
                propValue = propBindingScope != null && script != null && 4 != dtCotnext.getMode() ? ((value = JavascriptEvalUtil.evaluateScript(null, propBindingScope, script.getText(), ScriptExpression.defaultID, 0)) == null ? null : value.toString()) : (String)staticProps.get(propName);
                this.addPublicProperty(propName, propValue);
            }
        }
        if ((elmtIter = source.privateDriverPropertiesIterator()) != null) {
            while (elmtIter.hasNext()) {
                ExtendedPropertyHandle modelProp = (ExtendedPropertyHandle)elmtIter.next();
                this.addPrivateProperty(modelProp.getName(), modelProp.getValue());
            }
        }
        this.addPropertyConfigurationId(this, source);
    }

    private void addPropertyConfigurationId(OdaDataSourceDesign dteSource, OdaDataSourceHandle sourceHandle) throws BirtException {
        String configIdValue = dteSource.getExtensionID() + "_" + sourceHandle.getExternalConnectionName();
        dteSource.addPublicProperty("OdaPropertyConfigId", configIdValue);
    }
}

