/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.RunningAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalRunningSum
extends AggrFunction {
    @Override
    public String getName() {
        return "RUNNINGSUM";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator(CalculatorFactory.getCalculator(this.getDataType()));
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalRunningSum.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalRunningSum.displayName");
    }

    private static class MyAccumulator
    extends RunningAccumulator {
        private boolean isRowAvailable = false;
        private Number sum = null;

        MyAccumulator(ICalculator calc) {
            super(calc);
        }

        @Override
        public void start() throws DataException {
            super.start();
            this.sum = null;
            this.isRowAvailable = false;
        }

        @Override
        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (args[0] != null) {
                this.sum = this.calculator.add(this.sum, this.calculator.getTypedObject(args[0]));
                if (!this.isRowAvailable) {
                    this.isRowAvailable = true;
                }
            }
        }

        @Override
        public Object getValue() {
            return this.isRowAvailable ? (Number)this.sum : (Number)null;
        }
    }
}

