/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrException;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalNpv
extends AggrFunction {
    @Override
    public String getName() {
        return "NPV";
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("rate", Messages.getString("TotalNpv.param.rate"), true, false, SupportedDataTypes.CALCULATABLE, "")};
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator(CalculatorFactory.getCalculator(this.getDataType()));
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalNpv.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalNpv.displayName");
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private Number npv = null;
        private double rate = 0.0;
        private int count = 1;

        MyAccumulator(ICalculator calc) {
            super(calc);
        }

        @Override
        public void start() {
            super.start();
            this.npv = null;
            this.count = 1;
        }

        @Override
        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (args[0] != null) {
                try {
                    if (this.count == 1) {
                        this.rate = args[1] != null ? DataTypeUtil.toDouble(args[1]).doubleValue() : DataTypeUtil.toDouble(0).doubleValue();
                    }
                    this.npv = this.calculator.add(this.npv, this.calculator.divide(this.calculator.getTypedObject(args[0]), this.calculator.getTypedObject(Math.pow(1.0 + this.rate, this.count++))));
                }
                catch (BirtException e) {
                    throw DataException.wrap(new AggrException("aggregation.DataConversionError", e));
                }
            }
        }

        @Override
        public Object getSummaryValue() {
            return this.count > 1 ? (Number)this.npv : (Number)null;
        }
    }
}

