/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.axis.utility;

import java.io.IOException;
import java.io.Writer;
import org.apache.axis.components.encoding.AbstractXMLEncoder;
import org.apache.axis.i18n.Messages;

public class UTF8Encoder
extends AbstractXMLEncoder {
    public String getEncoding() {
        return "UTF-8";
    }

    public void writeEncoded(Writer writer, String xmlString) throws IOException {
        if (xmlString == null) {
            return;
        }
        int length = xmlString.length();
        int i = 0;
        while (i < length) {
            char c = xmlString.charAt(i);
            switch (c) {
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '\"': {
                    writer.write("&quot;");
                    break;
                }
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                case '\n': {
                    writer.write("\n");
                    break;
                }
                case '\r': {
                    writer.write("\r");
                    break;
                }
                case '\t': {
                    writer.write("\t");
                    break;
                }
                default: {
                    if (c < ' ') {
                        throw new IllegalArgumentException(Messages.getMessage((String)"invalidXmlCharacter00", (String)Integer.toHexString(c), (String)xmlString.substring(0, i)));
                    }
                    if (c > '\ud7ff' && c < '\udc00' && i + 1 < length) {
                        char nc;
                        if ((nc = xmlString.charAt(++i)) > '\udbff' && nc < '\ue000') {
                            int rc = c - 55232 << 10 | nc & 0x3FF;
                            writer.write("&#x");
                            writer.write(Integer.toHexString(rc).toUpperCase());
                            writer.write(";");
                            break;
                        }
                        this.writeChar(writer, c);
                        this.writeChar(writer, nc);
                        break;
                    }
                    this.writeChar(writer, c);
                }
            }
            ++i;
        }
    }

    private void writeChar(Writer writer, char c) throws IOException {
        if (c > '\u007f') {
            writer.write("&#x");
            writer.write(Integer.toHexString(c).toUpperCase());
            writer.write(";");
        } else {
            writer.write(c);
        }
    }
}

