/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UserDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SYSUSERSRowFactory
extends CatalogRowFactory {
    public static final String TABLE_NAME = "SYSUSERS";
    public static final String SYSUSERS_UUID = "9810800c-0134-14a5-40c1-000004f61f90";
    public static final String PASSWORD_COL_NAME = "PASSWORD";
    private static final int SYSUSERS_COLUMN_COUNT = 4;
    public static final int USERNAME_COL_NUM = 1;
    public static final int HASHINGSCHEME_COL_NUM = 2;
    public static final int PASSWORD_COL_NUM = 3;
    public static final int LASTMODIFIED_COL_NUM = 4;
    static final int SYSUSERS_INDEX1_ID = 0;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"9810800c-0134-14a5-40c1-000004f61f90", "9810800c-0134-14a5-a609-000004f61f90", "9810800c-0134-14a5-f1cd-000004f61f90"};

    SYSUSERSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(4, TABLE_NAME, indexColumnPositions, uniqueness, uuids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        ExecRow row;
        String userName = null;
        String hashingScheme = null;
        char[] password = null;
        Timestamp lastModified = null;
        try {
            if (td != null) {
                UserDescriptor descriptor = (UserDescriptor)td;
                userName = descriptor.getUserName();
                hashingScheme = descriptor.getHashingScheme();
                password = descriptor.getAndZeroPassword();
                lastModified = descriptor.getLastModified();
            }
            row = this.getExecutionFactory().getValueRow(4);
            row.setColumn(1, new SQLVarchar(userName));
            row.setColumn(2, new SQLVarchar(hashingScheme));
            row.setColumn(3, new SQLVarchar(password));
            row.setColumn(4, new SQLTimestamp(lastModified));
            if (password == null) return row;
        }
        catch (Throwable throwable) {
            if (password == null) throw throwable;
            Arrays.fill(password, '\u0000');
            throw throwable;
        }
        Arrays.fill(password, '\u0000');
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        UserDescriptor result;
        SQLChar passwordCol;
        block6: {
            if (row.nColumns() != 4) {
                SanityManager.THROWASSERT("Wrong number of columns for a SYSUSERS row: " + row.nColumns());
            }
            DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
            char[] password = null;
            passwordCol = null;
            try {
                DataValueDescriptor col = row.getColumn(1);
                String userName = col.getString();
                col = row.getColumn(2);
                String hashingScheme = col.getString();
                passwordCol = (SQLVarchar)row.getColumn(3);
                password = passwordCol.getRawDataAndZeroIt();
                col = row.getColumn(4);
                Timestamp lastModified = col.getTimestamp(new GregorianCalendar());
                result = ddg.newUserDescriptor(userName, hashingScheme, password, lastModified);
                if (password == null) break block6;
            }
            catch (Throwable throwable) {
                if (password != null) {
                    Arrays.fill(password, '\u0000');
                }
                if (passwordCol != null) {
                    passwordCol.zeroRawData();
                }
                throw throwable;
            }
            Arrays.fill(password, '\u0000');
        }
        if (passwordCol != null) {
            passwordCol.zeroRawData();
        }
        return result;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getIdentifierColumn("USERNAME", false), SystemColumnImpl.getColumn("HASHINGSCHEME", 12, false, 32672), SystemColumnImpl.getColumn(PASSWORD_COL_NAME, 12, false, 32672), SystemColumnImpl.getColumn("LASTMODIFIED", 93, false)};
    }
}

