/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de.internal;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.AbstractCrosstabModelTask;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabReportItemTask;
import org.eclipse.birt.report.item.crosstab.core.de.internal.DimensionViewTask;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class CrosstabViewTask
extends AbstractCrosstabModelTask {
    protected CrosstabViewHandle crosstabView = null;

    public CrosstabViewTask(CrosstabViewHandle focus) {
        super(focus);
        this.crosstabView = focus;
    }

    public CrosstabCellHandle addGrandTotal(List<MeasureViewHandle> measureList, List<String> functionList) throws SemanticException {
        return this.addGrandTotal(measureList, functionList, true);
    }

    CrosstabCellHandle addGrandTotal(List<MeasureViewHandle> measureList, List<String> functionList, boolean needTransaction) throws SemanticException {
        if (!this.isValidParameters(functionList, measureList)) {
            return null;
        }
        this.verifyTotalMeasureFunctions(this.crosstabView.getAxisType(), functionList, measureList);
        PropertyHandle propHandle = this.crosstabView.getGrandTotalProperty();
        CommandStack stack = null;
        if (needTransaction) {
            stack = this.crosstabView.getCommandStack();
            stack.startTrans(Messages.getString("CrosstabViewTask.msg.add.grandtotal"));
        }
        CrosstabCellHandle totalCell = null;
        try {
            CrosstabReportItemHandle crosstab;
            ExtendedItemHandle grandTotal = null;
            if (propHandle.getContentCount() <= 0) {
                grandTotal = CrosstabExtendedItemFactory.createCrosstabCell(this.crosstabView.getModuleHandle());
                propHandle.add(grandTotal);
            }
            if ((crosstab = this.crosstabView.getCrosstab()) != null && measureList != null) {
                boolean isVerticalMeasure = "vertical".equals(crosstab.getMeasureDirection());
                boolean needCheckCounterAxis = isVerticalMeasure && this.crosstabView.getAxisType() == 1 || !isVerticalMeasure && this.crosstabView.getAxisType() == 0;
                this.addMeasureAggregations(this.crosstabView.getAxisType(), measureList, functionList, needCheckCounterAxis);
                this.addTotalMeasureHeader(this.crosstabView.getAxisType(), null, measureList);
            }
            this.validateCrosstab();
            if (measureList != null && functionList != null) {
                int i = 0;
                while (i < measureList.size()) {
                    MeasureViewHandle mv = measureList.get(i);
                    String func = functionList.get(i);
                    this.setAggregationFunction(mv, func);
                    ++i;
                }
            }
            totalCell = (CrosstabCellHandle)CrosstabUtil.getReportItem(grandTotal);
        }
        catch (SemanticException e) {
            this.crosstabView.getLogger().log(Level.INFO, e.getMessage(), e);
            if (needTransaction) {
                stack.rollback();
            }
            throw e;
        }
        if (needTransaction) {
            stack.commit();
        }
        return totalCell;
    }

    private void setAggregationFunction(MeasureViewHandle measureView, String function) throws SemanticException {
        if (this.crosstabView.getGrandTotal() == null || measureView == null || this.crosstab == null || this.crosstab != measureView.getCrosstab()) {
            return;
        }
        int axisType = this.crosstabView.getAxisType();
        String propName = CrosstabModelUtil.getAggregationOnPropName(axisType);
        CommandStack stack = this.crosstab.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemTask.msg.set.aggregate.function"));
        try {
            int j = 0;
            while (j < measureView.getAggregationCount()) {
                AggregationCellHandle cell = measureView.getAggregationCell(j);
                if (cell.getModelHandle().getStringProperty(propName) == null) {
                    CrosstabModelUtil.setAggregationFunction(this.crosstab, cell, function);
                }
                ++j;
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void removeGrandTotal() throws SemanticException {
        this.removeGrandTotal(true);
    }

    public void removeGrandTotal(int measureIndex) throws SemanticException {
        this.removeGrandTotal(measureIndex, true);
    }

    void removeGrandTotal(int measureIndex, boolean needTransaction) throws SemanticException {
        PropertyHandle propHandle = this.crosstabView.getGrandTotalProperty();
        if (propHandle.getContentCount() > 0) {
            CommandStack stack = null;
            if (needTransaction) {
                stack = this.crosstabView.getCommandStack();
                stack.startTrans(Messages.getString("CrosstabViewTask.msg.remove.grandtotal"));
            }
            try {
                this.removeTotalMeasureHeader(this.crosstabView.getAxisType(), null, measureIndex);
                this.removeMeasureAggregations(this.crosstabView.getAxisType(), measureIndex);
                if (new CrosstabReportItemTask(this.crosstab).getAggregationMeasures(this.crosstabView.getAxisType()).size() == 0) {
                    propHandle.drop(0);
                }
            }
            catch (SemanticException e) {
                this.crosstabView.getLogger().log(Level.INFO, e.getMessage(), e);
                if (needTransaction) {
                    stack.rollback();
                }
                throw e;
            }
            if (needTransaction) {
                stack.commit();
            }
        }
    }

    void removeGrandTotal(boolean needTransaction) throws SemanticException {
        PropertyHandle propHandle = this.crosstabView.getGrandTotalProperty();
        if (propHandle.getContentCount() > 0) {
            CommandStack stack = null;
            if (needTransaction) {
                stack = this.crosstabView.getCommandStack();
                stack.startTrans(Messages.getString("CrosstabViewTask.msg.remove.grandtotal"));
            }
            try {
                if (this.crosstab != null) {
                    this.removeTotalMeasureHeader(this.crosstabView.getAxisType(), null);
                    this.removeMeasureAggregations(this.crosstabView.getAxisType());
                }
                propHandle.drop(0);
            }
            catch (SemanticException e) {
                this.crosstabView.getLogger().log(Level.INFO, e.getMessage(), e);
                if (needTransaction) {
                    stack.rollback();
                }
                throw e;
            }
            if (needTransaction) {
                stack.commit();
            }
        }
    }

    public void removeDimension(String name) throws SemanticException {
        DimensionViewHandle dimensionView = this.crosstabView.getDimension(name);
        if (dimensionView == null) {
            this.crosstabView.getLogger().log(Level.SEVERE, "Error.CrosstabException.DIMENSION_NOT_FOUND", name);
            throw new CrosstabException(this.crosstabView.getModelHandle().getElement(), Messages.getString("Error.CrosstabException.DIMENSION_NOT_FOUND", name));
        }
        this.removeDimension(dimensionView, true);
    }

    public void removeDimension(int index) throws SemanticException {
        DimensionViewHandle dimensionView = this.crosstabView.getDimension(index);
        if (dimensionView == null) {
            this.crosstabView.getLogger().log(Level.SEVERE, "Error.CrosstabException.DIMENSION_NOT_FOUND", String.valueOf(index));
            return;
        }
        this.removeDimension(dimensionView, true);
    }

    public void removeDimension(DimensionViewHandle dimensionView) throws SemanticException {
        this.removeDimension(dimensionView, true);
    }

    void removeDimension(DimensionViewHandle dimensionView, boolean needTransaction) throws SemanticException {
        if (dimensionView == null || dimensionView.getContainer() != this.crosstabView) {
            return;
        }
        CommandStack stack = null;
        if (needTransaction) {
            stack = this.crosstabView.getCommandStack();
            stack.startTrans(Messages.getString("CrosstabViewTask.msg.remove.dimension"));
        }
        int count = dimensionView.getLevelCount();
        try {
            if (this.crosstabView.getDimensionCount() == 1) {
                this.removeGrandTotal(false);
            }
            if (this.crosstab != null) {
                DimensionViewTask dimTask = new DimensionViewTask(dimensionView);
                int i = 0;
                while (i < count) {
                    LevelViewHandle lv = dimensionView.getLevel(0);
                    if (lv != null) {
                        dimTask.removeLevel(lv, false);
                    }
                    ++i;
                }
            }
            dimensionView.getModelHandle().drop();
        }
        catch (SemanticException e) {
            if (needTransaction) {
                stack.rollback();
            }
            throw e;
        }
        if (needTransaction) {
            stack.commit();
        }
    }

    public void addDimension(DimensionViewHandle dimensionView, int targetIndex, boolean needTransaction) throws SemanticException {
        if (dimensionView == null) {
            return;
        }
        CommandStack stack = null;
        if (needTransaction) {
            stack = this.crosstabView.getCommandStack();
            stack.startTrans(Messages.getString("CrosstabViewTask.msg.add.dimension"));
        }
        try {
            LevelViewHandle lastLevelView;
            int axisType = this.crosstabView.getAxisType();
            LevelViewHandle oldLevelView = CrosstabModelUtil.getInnerMostLevel(this.crosstab, axisType);
            int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
            this.crosstabView.getViewsProperty().add(dimensionView.getModelHandle(), targetIndex);
            if ((this.crosstab.getGrandTotal(counterAxisType) != null || CrosstabModelUtil.getAllLevelCount(this.crosstab, counterAxisType) == 0) && (lastLevelView = dimensionView.getLevel(dimensionView.getLevelCount() - 1)) != null && lastLevelView.isInnerMost()) {
                List<MeasureViewHandle> measureList = this.crosstab.getAggregationMeasures(counterAxisType);
                AbstractCrosstabModelTask.AggregationInfo oldInfo = this.getAggregationInfo(oldLevelView, null);
                AbstractCrosstabModelTask.AggregationInfo info = this.getAggregationInfo(lastLevelView, null);
                int i = 0;
                while (i < measureList.size()) {
                    MeasureViewHandle measureView = measureList.get(i);
                    AggregationCellHandle cell = measureView.getAggregationCell(oldInfo.getRowDimension(), oldInfo.getRowLevel(), oldInfo.getColDimension(), oldInfo.getColLevel());
                    if (cell != null) {
                        cell.getModelHandle().drop();
                    }
                    String function = this.crosstab.getAggregationFunction(counterAxisType, measureView);
                    this.validateSingleMeasureAggregation(this.crosstab, measureView, function, info.getRowDimension(), info.getRowLevel(), info.getColDimension(), info.getColLevel());
                    ++i;
                }
            }
        }
        catch (SemanticException e) {
            if (needTransaction) {
                stack.rollback();
            }
            throw e;
        }
        if (needTransaction) {
            stack.commit();
        }
    }
}

