/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v3;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;

public class ReportContentReaderV3 {
    protected static Logger logger = Logger.getLogger(ReportContentReaderV3.class.getName());
    protected ReportContent reportContent;
    protected RAInputStream stream;
    protected int version = -1;
    protected static final int INDEX_ENTRY_SIZE_V0 = 40;
    protected static final int INDEX_ENTRY_SIZE_V1 = 24;
    protected static final int VERSION_0 = 0;
    protected static final int VERSION_1 = 1;
    protected static final int VERSION_SIZE = 4;
    protected long offset;
    protected long rootOffset;
    protected boolean isEmpty = false;
    protected ClassLoader loader;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReportContentReaderV3(ReportContent reportContent, RAInputStream stream, ClassLoader loader) throws IOException {
        this.reportContent = reportContent;
        this.loader = loader;
        this.stream = stream;
        long length = stream.length();
        if (this.stream.length() < 4L) throw new IOException("unrecognized stream version!");
        stream.seek(0L);
        this.version = stream.readInt();
        if (this.version == -1) {
            this.version = 0;
            return;
        } else {
            if (this.version != 1) throw new IOException("unrecognized stream version!");
            if (length == 4L) {
                this.isEmpty = true;
                return;
            } else {
                this.loadReport();
            }
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed to close the reader", ex);
            }
            this.stream = null;
        }
    }

    public long getRoot() {
        return this.rootOffset;
    }

    private void loadReport() throws IOException {
        this.readDocumentExtensionV1(0L);
        int size = this.stream.readInt();
        if (size != -1) {
            byte[] buffer = new byte[size];
            this.stream.readFully(buffer, 0, size);
            DataInputStream oi = new DataInputStream(new ByteArrayInputStream(buffer));
            int contentType = IOUtil.readInt(oi);
            if (contentType == 0) {
                this.reportContent.readContent(oi, this.loader);
                this.offset += (long)(28 + size);
                this.rootOffset = this.offset;
            }
        }
    }

    protected IContent readObject(long offset) throws IOException {
        if (this.version == 0) {
            this.stream.seek(offset);
        } else if (1 == this.version) {
            this.stream.seek(4L + offset);
        }
        int size = this.stream.readInt();
        byte[] buffer = new byte[size];
        this.stream.readFully(buffer, 0, size);
        DataInputStream oi = new DataInputStream(new ByteArrayInputStream(buffer));
        AbstractContent object = null;
        int contentType = IOUtil.readInt(oi);
        switch (contentType) {
            case 1: {
                object = (AbstractContent)((Object)this.reportContent.createCellContent());
                break;
            }
            case 2: {
                object = (AbstractContent)((Object)this.reportContent.createContainerContent());
                break;
            }
            case 3: {
                object = (AbstractContent)((Object)this.reportContent.createDataContent());
                break;
            }
            case 4: {
                object = (AbstractContent)((Object)this.reportContent.createForeignContent());
                break;
            }
            case 5: {
                object = (AbstractContent)((Object)this.reportContent.createImageContent());
                break;
            }
            case 6: {
                object = (AbstractContent)((Object)this.reportContent.createLabelContent());
                break;
            }
            case 7: {
                object = (AbstractContent)((Object)this.reportContent.createPageContent());
                break;
            }
            case 8: {
                object = (AbstractContent)((Object)this.reportContent.createRowContent());
                break;
            }
            case 9: {
                object = (AbstractContent)((Object)this.reportContent.createTableBandContent());
                break;
            }
            case 10: {
                object = (AbstractContent)((Object)this.reportContent.createTableContent());
                break;
            }
            case 11: {
                object = (AbstractContent)((Object)this.reportContent.createTextContent());
                break;
            }
            case 12: {
                object = (AbstractContent)((Object)this.reportContent.createAutoTextContent());
                break;
            }
            case 13: {
                object = (AbstractContent)((Object)this.reportContent.createListContent());
                break;
            }
            case 14: {
                object = (AbstractContent)((Object)this.reportContent.createListBandContent());
                break;
            }
            case 16: {
                object = (AbstractContent)((Object)this.reportContent.createListGroupContent());
                break;
            }
            case 17: {
                object = (AbstractContent)((Object)this.reportContent.createTableGroupContent());
                break;
            }
            default: {
                throw new IOException("Found invalid contentType" + contentType + " at object offset " + offset);
            }
        }
        object.setVersion(this.version);
        object.readContent(oi, this.loader);
        return object;
    }

    public IContent readContent() throws IOException {
        long index = this.offset;
        IContent content = this.readContent(index);
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt.getFirstChild() != -1L) {
            this.offset = docExt.getFirstChild();
            return content;
        }
        if (docExt.getNext() != -1L) {
            this.offset = docExt.getNext();
            return content;
        }
        docExt = this.readDocumentExtension(docExt.getParent());
        while (docExt != null) {
            if (docExt.getNext() != -1L) {
                this.offset = docExt.getNext();
                return content;
            }
            docExt = this.readDocumentExtension(docExt.getParent());
        }
        this.offset = -1L;
        return content;
    }

    public IContent readContent(long index) throws IOException {
        if (this.version == 0) {
            return this.readContentV0(index);
        }
        if (1 == this.version) {
            return this.readContentV1(index);
        }
        throw new IOException("unrecognized stream version!");
    }

    private IContent readContentV0(long index) throws IOException {
        if (index >= this.stream.length() || index < 0L) {
            throw new IOException("Invalid content offset:" + index);
        }
        DocumentExtension docExt = this.readDocumentExtensionV0(index);
        IContent content = this.readObject(index + 40L);
        if (content != null) {
            content.setExtension(0, docExt);
        }
        return content;
    }

    private IContent readContentV1(long index) throws IOException {
        DocumentExtension docExt = this.readDocumentExtensionV1(index);
        IContent content = this.readObject(index + 24L);
        if (content != null) {
            content.setExtension(0, docExt);
        }
        return content;
    }

    private DocumentExtension readDocumentExtension(long index) throws IOException {
        if (this.version == 0) {
            return this.readDocumentExtensionV0(index);
        }
        if (1 == this.version) {
            return this.readDocumentExtensionV1(index);
        }
        throw new IOException("unrecognized stream version!");
    }

    private DocumentExtension readDocumentExtensionV0(long index) throws IOException {
        this.stream.seek(index);
        index = this.stream.readLong();
        long parent = this.stream.readLong();
        long previous = this.stream.readLong();
        long next = this.stream.readLong();
        long child = this.stream.readLong();
        DocumentExtension docExt = new DocumentExtension(index);
        docExt.setParent(parent);
        docExt.setPrevious(previous);
        docExt.setNext(next);
        docExt.setFirstChild(child);
        return docExt;
    }

    private DocumentExtension readDocumentExtensionV1(long index) throws IOException {
        this.stream.seek(4L + index);
        long parent = this.stream.readLong();
        long next = this.stream.readLong();
        long child = this.stream.readLong();
        DocumentExtension docExt = new DocumentExtension(index);
        docExt.setParent(parent);
        docExt.setNext(next);
        docExt.setFirstChild(child);
        return docExt;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void dump() throws IOException {
        IContent content = this.readContent(0L);
        this.dumpContent(0, content);
    }

    protected void dumpContent(int level, IContent content) throws IOException {
        long nextOffset;
        int i = 0;
        while (i < level) {
            System.out.print("  ");
            ++i;
        }
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        long index = docExt.getIndex();
        System.out.print(index);
        System.out.print(":");
        System.out.println(content.getInstanceID());
        long firstChild = docExt.getFirstChild();
        if (firstChild != -1L) {
            IContent child = this.readContent(firstChild);
            this.dumpContent(level + 1, child);
        }
        if ((nextOffset = docExt.getNext()) != -1L) {
            IContent next = this.readContent(nextOffset);
            this.dumpContent(level, next);
        }
    }
}

