/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;

public class RunStatusWriter {
    protected RAOutputStream runStatusStream;
    protected static Logger logger = Logger.getLogger(RunStatusWriter.class.getName());
    private ByteArrayOutputStream writeBuffer = new ByteArrayOutputStream();
    private DataOutputStream out = new DataOutputStream(this.writeBuffer);

    public RunStatusWriter(IDocArchiveWriter writer) {
        try {
            this.runStatusStream = writer.createRandomAccessStream("/runStatus");
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Unable to create stream to write run task status");
            this.close();
        }
    }

    public void close() {
        try {
            if (this.runStatusStream != null) {
                this.runStatusStream.close();
                this.runStatusStream = null;
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Unable to close the stream used to write run task status");
        }
    }

    public void writeRunTaskStatus(ArrayList<String> messages) {
        if (this.runStatusStream == null) {
            return;
        }
        try {
            this.writeBuffer.reset();
            this.runStatusStream.writeInt(messages.size());
            for (String message : messages) {
                this.writeBuffer.reset();
                IOUtil.writeString(this.out, message);
                this.runStatusStream.write(this.writeBuffer.toByteArray());
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception occured during writing run task status");
        }
    }
}

