/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.group;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.DateTimeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.impl.group.GroupCalculator;

abstract class DateGroupCalculator
extends GroupCalculator {
    protected Date defaultStart;
    protected ULocale locale;
    protected TimeZone timeZone;
    protected DateTimeUtil dateTimeUtil;
    private int range;

    public DateGroupCalculator(Object intervalStart, double intervalRange, ULocale locale, TimeZone timeZone) throws BirtException {
        super(intervalStart, intervalRange);
        this.range = (int)Math.round(intervalRange);
        int n = this.range = this.range == 0 ? 1 : this.range;
        if (intervalStart != null) {
            this.intervalStart = DataTypeUtil.toDate(intervalStart);
        }
        this.locale = locale == null ? ULocale.getDefault() : locale;
        this.timeZone = timeZone == null ? TimeZone.getDefault() : timeZone;
        Calendar c = Calendar.getInstance((ULocale)this.locale);
        c.setTimeZone(this.timeZone);
        c.clear();
        c.set(1970, 0, 1);
        this.defaultStart = c.getTime();
        this.dateTimeUtil = new DateTimeUtil(this.locale, this.timeZone);
    }

    protected int getDateIntervalRange() {
        return this.range;
    }

    protected Date getDate(Object value) throws BirtException {
        return DataTypeUtil.toDate(value);
    }
}

