/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.session;

import java.io.File;
import java.io.Serializable;

public class ViewingCache
implements Serializable {
    private static final long serialVersionUID = -348510678864943788L;
    private static final String PREFIX_SUB_DOC_FOLDER = "BIRTDOC";
    private static final String PREFIX_SUB_IMAGE_FOLDER = "BIRTIMG";
    public String documentFolder = null;
    public String imageFolder = null;

    public ViewingCache(String documentFolder, String imageFolder) {
        this.documentFolder = documentFolder;
        this.imageFolder = imageFolder;
        if (!documentFolder.endsWith(File.separator)) {
            this.documentFolder = String.valueOf(this.documentFolder) + File.separator;
        }
        if (!imageFolder.endsWith(File.separator)) {
            this.imageFolder = String.valueOf(this.imageFolder) + File.separator;
        }
        this.clearTempFiles();
    }

    public String createDocumentPath(String sessionId, String subSessionId, String filePath) {
        String documentName = null;
        if (filePath == null || filePath.length() == 0) {
            return "";
        }
        String fileSeparator = "\\";
        if (filePath.lastIndexOf(fileSeparator) == -1) {
            fileSeparator = "/";
        }
        documentName = filePath.lastIndexOf(fileSeparator) != -1 ? filePath.substring(filePath.lastIndexOf(fileSeparator) + 1) : filePath;
        return this.documentFolder + this.getSessionSubfolder(PREFIX_SUB_DOC_FOLDER, sessionId, subSessionId) + documentName;
    }

    private String getSessionSubfolder(String prefix, String sessionId, String subSessionId) {
        Object folder = "";
        if (sessionId != null) {
            folder = prefix + sessionId + File.separator;
            if (subSessionId != null) {
                folder = (String)folder + subSessionId + File.separator;
            }
        } else {
            folder = "";
        }
        return folder;
    }

    public String getImageTempFolder(String sessionId, String subSessionId) {
        return this.imageFolder + this.getSessionSubfolder(PREFIX_SUB_IMAGE_FOLDER, sessionId, subSessionId);
    }

    public void clearSession(String sessionId, String subSessionId) {
        if (sessionId == null) {
            return;
        }
        ViewingCache.deleteDir(this.documentFolder + this.getSessionSubfolder(PREFIX_SUB_DOC_FOLDER, sessionId, subSessionId));
        ViewingCache.deleteDir(this.imageFolder + this.getSessionSubfolder(PREFIX_SUB_IMAGE_FOLDER, sessionId, subSessionId));
    }

    private void clearTempFiles() {
        int i;
        String[] children;
        File file = new File(this.documentFolder);
        if (file != null && file.isDirectory()) {
            children = file.list();
            i = 0;
            while (i < children.length) {
                if (children[i].startsWith(PREFIX_SUB_DOC_FOLDER)) {
                    ViewingCache.deleteDir(new File(file, children[i]));
                }
                ++i;
            }
        }
        if ((file = new File(this.imageFolder)) != null && file.isDirectory()) {
            children = file.list();
            i = 0;
            while (i < children.length) {
                if (children[i].startsWith(PREFIX_SUB_IMAGE_FOLDER)) {
                    ViewingCache.deleteDir(new File(file, children[i]));
                }
                ++i;
            }
        }
    }

    private static boolean deleteDir(String dirName) {
        return ViewingCache.deleteDir(new File(dirName));
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = ViewingCache.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    private static String generateDocumentFromReport(String reportName, String id) {
        if (reportName == null) {
            return null;
        }
        Object documentFile = reportName;
        if (reportName.indexOf(46) >= 0) {
            documentFile = reportName.substring(0, reportName.lastIndexOf(46));
        }
        documentFile = id != null && id.length() > 0 ? (String)documentFile + id + ".rptdocument" : (String)documentFile + ".rptdocument";
        return documentFile;
    }

    public String getReportDocument(String reportFile, String sessionId, String subSessionId, String viewerId) {
        if (reportFile == null) {
            return null;
        }
        String documentFile = ViewingCache.generateDocumentFromReport(reportFile, viewerId);
        documentFile = this.createDocumentPath(sessionId, subSessionId, documentFile);
        return documentFile;
    }
}

