/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.io.IOException;
import java.io.InputStream;

public class UnicodeUtil {
    public static final String SIGNATURE_UTF_8 = "UTF-8";
    public static final String SIGNATURE_UNICODE_BIG = "UnicodeBig";
    public static final String SIGNATURE_UNICODE_LITTLE = "UnicodeLittle";
    public static final String SIGNATURE_UCS4_BIG = "UCS-4Big";
    public static final String SIGNATURE_UCS4_LITTLE = "UCS-4Little";

    public static String checkUTFSignature(InputStream inputStream) throws IOException {
        inputStream.mark(1024);
        int byte1 = inputStream.read();
        int byte2 = inputStream.read();
        if (byte1 == 254 && byte2 == 255) {
            return SIGNATURE_UNICODE_BIG;
        }
        if (byte1 == 255 && byte2 == 254) {
            return SIGNATURE_UNICODE_LITTLE;
        }
        int byte3 = inputStream.read();
        if (byte1 == 239 && byte2 == 187 && byte3 == 191) {
            return SIGNATURE_UTF_8;
        }
        int byte4 = inputStream.read();
        if (byte1 == 0 && byte2 == 0 && byte3 == 254 && byte4 == 255) {
            return SIGNATURE_UCS4_BIG;
        }
        if (byte1 == 0 && byte2 == 0 && byte3 == 255 && byte4 == 254) {
            return SIGNATURE_UCS4_LITTLE;
        }
        inputStream.reset();
        return null;
    }
}

