/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.PropertyBindingHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.EncryptionUtil;

public class PropertyBinding
extends Structure {
    public static final String PROPERTY_BINDING_STRUCT = "PropertyBinding";
    public static final String NAME_MEMBER = "name";
    public static final String ID_MEMBER = "id";
    public static final String VALUE_MEMBER = "value";
    protected String name = null;
    protected BigDecimal id = null;
    protected Expression value = null;
    protected String encryptionID = null;

    @Override
    protected Object getIntrinsicProperty(String propName) {
        if (NAME_MEMBER.equalsIgnoreCase(propName)) {
            return this.name;
        }
        if (ID_MEMBER.equalsIgnoreCase(propName)) {
            return this.id;
        }
        if (VALUE_MEMBER.equalsIgnoreCase(propName)) {
            if (this.encryptionID == null) {
                return this.value;
            }
            if (this.value != null) {
                Object decoded = EncryptionUtil.decrypt((PropertyDefn)this.getDefn().getMember(VALUE_MEMBER), this.encryptionID, (Object)this.value);
                return new Expression(decoded, this.value.getUserDefinedType());
            }
            return this.value;
        }
        assert (false);
        return null;
    }

    @Override
    protected void setIntrinsicProperty(String propName, Object value) {
        if (NAME_MEMBER.equalsIgnoreCase(propName)) {
            this.name = (String)value;
        } else if (ID_MEMBER.equalsIgnoreCase(propName)) {
            this.id = (BigDecimal)value;
        } else if (VALUE_MEMBER.equalsIgnoreCase(propName)) {
            this.value = (Expression)value;
        } else assert (false);
    }

    @Override
    protected StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new PropertyBindingHandle(valueHandle, index);
    }

    @Override
    public String getStructName() {
        return PROPERTY_BINDING_STRUCT;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setID(long id) {
        this.id = new BigDecimal((double)id);
    }

    public BigDecimal getID() {
        return this.id;
    }

    public String getValue() {
        Expression tmpValue = (Expression)this.getIntrinsicProperty(VALUE_MEMBER);
        return tmpValue == null ? null : tmpValue.getStringExpression();
    }

    public void setValue(String expression) {
        String tmpType = this.value == null ? null : this.value.getUserDefinedType();
        this.value = !StringUtil.isBlank(expression) || tmpType != null ? new Expression(expression, tmpType) : null;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        if (StringUtil.isBlank(this.getName())) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(NAME_MEMBER), null, "Error.PropertyValueException.VALUE_REQUIRED"));
        } else if (this.id == null || module.getElementByID(this.id.longValue()) == null) {
            list.add(new SemanticError(element, new String[]{this.getName()}, "Error.SemanticError.INVALID_PROPERTY_BINDING_ID"));
        } else if (module.getElementByID(this.id.longValue()).getPropertyDefn(this.getName()) == null) {
            list.add(new SemanticError(element, new String[]{this.getName()}, "Error.SemanticError.INVALID_PROPERTY_NAME"));
        }
        return list;
    }

    public void setEncryption(String encryptionID) {
        this.encryptionID = encryptionID;
    }

    public String getEncryption() {
        return this.encryptionID;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this.encryptionID == null) {
            return ((PropertyBinding)obj).encryptionID == null;
        }
        return this.encryptionID.equals(((PropertyBinding)obj).encryptionID);
    }
}

