/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.util;

import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.component.LifeCycle;

public class ServerConnectorListener
implements LifeCycle.Listener {
    private Path _filePath;
    private String _sysPropertyName;

    public void lifeCycleStarted(LifeCycle event) {
        if (this.getFilePath() != null) {
            try (FileWriter writer = new FileWriter(this.getFilePath().toFile());){
                Files.deleteIfExists(this._filePath);
                writer.write(((ServerConnector)event).getLocalPort());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSysPropertyName() != null) {
            System.setProperty(this._sysPropertyName, String.valueOf(((ServerConnector)event).getLocalPort()));
        }
    }

    public Path getFilePath() {
        return this._filePath;
    }

    public void setFilePath(Path filePath) {
        this._filePath = filePath;
    }

    public String getSysPropertyName() {
        return this._sysPropertyName;
    }

    public void setSysPropertyName(String sysPropertyName) {
        this._sysPropertyName = sysPropertyName;
    }
}

