/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.ChangeSetLabelDecorator;
import org.eclipse.team.internal.ui.synchronize.ChangeSetModelProvider;
import org.eclipse.team.internal.ui.synchronize.HierarchicalModelManager;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class ChangeSetModelManager
extends HierarchicalModelManager
implements IPropertyChangeListener {
    private static final String P_COMMIT_SET_ENABLED = "org.eclipse.team.ui.P_COMMIT_SET_ENABLED";
    public static final String CHANGE_SET_GROUP = "ChangeSet";
    boolean enabled = false;
    private ToggleCommitSetAction toggleCommitSetAction;

    public ChangeSetModelManager(ISynchronizePageConfiguration configuration) {
        super(configuration);
        configuration.addPropertyChangeListener(this);
        configuration.addMenuGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", CHANGE_SET_GROUP);
        configuration.addActionContribution(new CommitSetActionContribution());
        ChangeSetCapability changeSetCapability = this.getChangeSetCapability(configuration);
        if (changeSetCapability != null && changeSetCapability.supportsActiveChangeSets()) {
            configuration.addLabelDecorator(new ChangeSetLabelDecorator(configuration));
        }
        configuration.addPropertyChangeListener(event -> {
            if (event.getProperty().equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE")) {
                this.updateEnablement();
            }
        });
    }

    private ChangeSetCapability getChangeSetCapability(ISynchronizePageConfiguration configuration) {
        ISynchronizeParticipant participant = configuration.getParticipant();
        if (participant instanceof IChangeSetProvider) {
            IChangeSetProvider provider = (IChangeSetProvider)((Object)participant);
            return provider.getChangeSetCapability();
        }
        return null;
    }

    private void updateEnablement() {
        if (this.toggleCommitSetAction != null) {
            ISynchronizePageConfiguration configuration = this.getConfiguration();
            ChangeSetCapability changeSetCapability = this.getChangeSetCapability(configuration);
            boolean enabled = changeSetCapability != null && (changeSetCapability.enableActiveChangeSetsFor(configuration) || changeSetCapability.enableCheckedInChangeSetsFor(configuration));
            this.toggleCommitSetAction.setEnabled(enabled);
        }
    }

    @Override
    public void dispose() {
        this.getConfiguration().removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    protected ISynchronizeModelProvider createModelProvider(String id) {
        if (this.enabled) {
            return new ChangeSetModelProvider(this.getConfiguration(), this.getSyncInfoSet(), id);
        }
        return super.createModelProvider(id);
    }

    @Override
    protected String getSelectedProviderId() {
        String id = super.getSelectedProviderId();
        if (id.equals("org.eclipse.team.ui.modelprovider_cvs_changelog")) {
            return ((ChangeSetModelProvider)this.getActiveModelProvider()).getSubproviderId();
        }
        return id;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    protected void saveProviderSettings(String id) {
        super.saveProviderSettings(id);
        IDialogSettings pageSettings = this.getConfiguration().getSite().getPageSettings();
        if (pageSettings != null) {
            pageSettings.put(P_COMMIT_SET_ENABLED, this.enabled);
        }
    }

    @Override
    public void initialize(ISynchronizePageConfiguration configuration) {
        IDialogSettings pageSettings = this.getConfiguration().getSite().getPageSettings();
        ChangeSetCapability changeSetCapability = this.getChangeSetCapability(this.getConfiguration());
        boolean bl = this.enabled = changeSetCapability != null && changeSetCapability.enableChangeSetsByDefault();
        if (pageSettings != null && pageSettings.get(P_COMMIT_SET_ENABLED) != null) {
            this.enabled = pageSettings.getBoolean(P_COMMIT_SET_ENABLED);
        }
        super.initialize(configuration);
    }

    public void setCommitSetsEnabled(boolean enable) {
        if (this.enabled != enable) {
            this.enabled = enable;
            this.setInput(this.getSelectedProviderId(), null);
        }
    }

    @Override
    public ISynchronizeModelProvider getActiveModelProvider() {
        return super.getActiveModelProvider();
    }

    private class CommitSetActionContribution
    extends SynchronizePageActionGroup {
        private CommitSetActionContribution() {
        }

        @Override
        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            ChangeSetModelManager.this.toggleCommitSetAction = new ToggleCommitSetAction();
            this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", ChangeSetModelManager.CHANGE_SET_GROUP, (IAction)ChangeSetModelManager.this.toggleCommitSetAction);
            ChangeSetModelManager.this.updateEnablement();
        }
    }

    private class ToggleCommitSetAction
    extends Action {
        public ToggleCommitSetAction() {
            super(TeamUIMessages.ChangeLogModelManager_0, TeamUIPlugin.getImageDescriptor("obj/changeset_obj.png"));
            this.setToolTipText(TeamUIMessages.ChangeLogModelManager_0);
            this.update();
        }

        public void run() {
            ChangeSetModelManager.this.setCommitSetsEnabled(!ChangeSetModelManager.this.enabled);
            this.update();
        }

        private void update() {
            this.setChecked(ChangeSetModelManager.this.enabled);
        }
    }
}

