/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.apache.internal.derby.catalog;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.apache.internal.derby.catalog.DerbySchemaLoader;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.impl.ColumnImpl;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DerbyCatalogColumn
extends ColumnImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257570602843189304L;
    private boolean identityLoaded = false;

    public void refresh() {
        this.identityLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    public Database getCatalogDatabase() {
        Table table = (Table)this.eContainer;
        return table.getSchema().getCatalog().getDatabase();
    }

    public IdentitySpecifier getIdentitySpecifier() {
        if (!this.identityLoaded) {
            this.loadIdentity();
        }
        return this.identitySpecifier;
    }

    public String getDefaultValue() {
        if (!this.identityLoaded) {
            this.loadIdentity();
        }
        return this.defaultValue;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 11) {
            this.getIdentitySpecifier();
        } else if (id == 15) {
            this.getDefaultValue();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadIdentity() {
        if (this.identityLoaded) {
            return;
        }
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        this.loadIdentity(connection, (Column)this);
        this.eSetDeliver(deliver);
    }

    public void loadIdentity(Connection connection, Column column) {
        try {
            Table table = (Table)column.eContainer();
            Database database = table.getSchema().getCatalog().getDatabase();
            DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
            DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
            Statement s = connection.createStatement();
            String currentSchema = DerbySchemaLoader.setSchema(s, "SYS");
            String query = "SELECT COLUMNDEFAULT,AUTOINCREMENTVALUE,AUTOINCREMENTSTART FROM SYS.SYSCOLUMNS A, SYS.SYSTABLES B, SYS.SYSSCHEMAS C WHERE A.REFERENCEID=B.TABLEID AND B.TABLENAME='" + column.getTable().getName() + "'" + " AND B.SCHEMAID=C.SCHEMAID" + " AND C.SCHEMANAME='" + column.getTable().getSchema().getName() + "'" + " AND A.COLUMNNAME='" + column.getName() + "'";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                long increment;
                Serializable defaultValue = (Serializable)r.getObject("COLUMNDEFAULT");
                if (defaultValue != null) {
                    column.setDefaultValue(defaultValue.toString());
                }
                if ((increment = r.getLong("AUTOINCREMENTVALUE")) == 0L) continue;
                IdentitySpecifier identitySpecifier = (IdentitySpecifier)factory.create(SQLSchemaPackage.eINSTANCE.getIdentitySpecifier());
                identitySpecifier.setStartValue(BigInteger.valueOf(r.getLong("AUTOINCREMENTSTART")));
                identitySpecifier.setIncrement(BigInteger.valueOf(increment));
                column.setIdentitySpecifier(identitySpecifier);
            }
            r.close();
            DerbySchemaLoader.setSchema(s, currentSchema);
            s.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

