/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.dscache;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheObjectWithDummyData;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory;
import org.eclipse.birt.data.engine.executor.dscache.ILoadUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;

public class DummyDataCacheLoadUtil
implements ILoadUtil {
    private DataSetCacheObjectWithDummyData cacheObject;
    private ILoadUtil sourceLoadUtil;
    private int rowID;

    public DummyDataCacheLoadUtil(DataSetCacheObjectWithDummyData cacheObject, DataEngineSession session) throws DataException {
        this.cacheObject = cacheObject;
        this.sourceLoadUtil = CacheUtilFactory.createLoadUtil(cacheObject.getSourceDataSetCacheObject(), session);
        this.rowID = 0;
    }

    @Override
    public IResultObject loadObject() throws DataException {
        IResultObject source = this.sourceLoadUtil.loadObject();
        if (source == null) {
            return null;
        }
        ++this.rowID;
        IResultClass actualResultClass = this.cacheObject.getResultClass();
        Object[] actual = new Object[actualResultClass.getFieldCount()];
        int i = 1;
        while (i <= actual.length) {
            String fieldName = actualResultClass.getFieldName(i);
            int index = source.getResultClass().getFieldIndex(fieldName);
            actual[i - 1] = index != -1 ? source.getFieldValue(index) : this.populateDataWithType(actualResultClass.getFieldValueClass(i), actualResultClass.getFieldLabel(i));
            ++i;
        }
        return new ResultObject(actualResultClass, actual);
    }

    private Object populateDataWithType(Class dataType, String displayName) {
        if (dataType == Integer.class) {
            return 1234;
        }
        if (dataType == Double.class) {
            return 1234.0;
        }
        if (dataType == String.class) {
            return displayName == null ? "Lorem Ipsum" : displayName + "_" + this.rowID;
        }
        if (dataType == BigDecimal.class) {
            return BigDecimal.valueOf(1234.56);
        }
        if (dataType == java.sql.Date.class) {
            return new java.sql.Date(System.currentTimeMillis());
        }
        if (dataType == Time.class) {
            return new Time(System.currentTimeMillis());
        }
        if (dataType == Date.class) {
            return new Date(System.currentTimeMillis());
        }
        if (dataType == Timestamp.class) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (dataType == IBlob.class) {
            return null;
        }
        if (dataType == IClob.class) {
            return null;
        }
        if (dataType == Boolean.class) {
            return false;
        }
        if (dataType == Object.class) {
            return null;
        }
        return null;
    }

    @Override
    public IResultClass loadResultClass() throws DataException {
        return this.cacheObject.getResultClass();
    }

    @Override
    public void close() throws DataException {
        this.sourceLoadUtil.close();
    }
}

