/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;

public class BlockParent
extends Area {
    private static final long serialVersionUID = 7076916890348533805L;
    protected int xOffset;
    protected int yOffset;
    protected List<Area> children;

    @Override
    public void addChildArea(Area childArea) {
        if (this.children == null) {
            this.children = new ArrayList<Area>();
        }
        this.children.add(childArea);
    }

    public void addBlock(Block block) {
        this.addChildArea(block);
    }

    public List getChildAreas() {
        return this.children;
    }

    public boolean isEmpty() {
        return this.children == null || this.children.size() == 0;
    }

    public void setXOffset(int off) {
        this.xOffset = off;
    }

    public void setYOffset(int off) {
        this.yOffset = off;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    @Override
    public int getEffectiveIPD() {
        int maxIPD = 0;
        if (this.children != null) {
            for (Area area : this.children) {
                int effectiveIPD = area.getEffectiveIPD();
                if (effectiveIPD <= maxIPD) continue;
                maxIPD = effectiveIPD;
            }
        }
        return maxIPD;
    }

    @Override
    public void activateEffectiveIPD() {
        if (this.children != null) {
            for (Area area : this.children) {
                area.activateEffectiveIPD();
            }
        }
    }
}

