/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.EngineStatement;
import org.apache.derby.shared.common.error.ExceptionFactory;

public class BrokeredStatement
implements EngineStatement {
    final BrokeredStatementControl control;
    final int resultSetType;
    final int resultSetConcurrency;
    final int resultSetHoldability;
    private String cursorName;
    private Boolean escapeProcessing;

    BrokeredStatement(BrokeredStatementControl control) throws SQLException {
        this.control = control;
        this.resultSetType = this.getResultSetType();
        this.resultSetConcurrency = this.getResultSetConcurrency();
        this.resultSetHoldability = this.getResultSetHoldability();
    }

    @Override
    public final void addBatch(String sql) throws SQLException {
        this.getStatement().addBatch(sql);
    }

    @Override
    public final void clearBatch() throws SQLException {
        this.getStatement().clearBatch();
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        return this.getStatement().executeBatch();
    }

    @Override
    public final void cancel() throws SQLException {
        this.getStatement().cancel();
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        return this.getStatement().execute(sql);
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        return this.wrapResultSet(this.getStatement().executeQuery(sql));
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        return this.getStatement().executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        this.control.closeRealStatement();
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.getStatement().getConnection();
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        return this.getStatement().getFetchDirection();
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.getStatement().getFetchSize();
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.getStatement().getMaxFieldSize();
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.getStatement().getMaxRows();
    }

    @Override
    public final int getResultSetConcurrency() throws SQLException {
        return this.getStatement().getResultSetConcurrency();
    }

    @Override
    public final void setMaxFieldSize(int max) throws SQLException {
        this.getStatement().setMaxFieldSize(max);
    }

    @Override
    public final void setMaxRows(int max) throws SQLException {
        this.getStatement().setMaxRows(max);
    }

    @Override
    public final void setEscapeProcessing(boolean enable) throws SQLException {
        this.getStatement().setEscapeProcessing(enable);
        this.escapeProcessing = enable ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.getStatement().getWarnings();
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.getStatement().clearWarnings();
    }

    @Override
    public final void setCursorName(String name) throws SQLException {
        this.getStatement().setCursorName(name);
        this.cursorName = name;
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        return this.wrapResultSet(this.getStatement().getResultSet());
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        return this.getStatement().getUpdateCount();
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        return this.getStatement().getMoreResults();
    }

    @Override
    public final int getResultSetType() throws SQLException {
        return this.getStatement().getResultSetType();
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        this.getStatement().setFetchDirection(direction);
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        this.getStatement().setFetchSize(rows);
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.getStatement().getQueryTimeout();
    }

    @Override
    public final void setQueryTimeout(int seconds) throws SQLException {
        this.getStatement().setQueryTimeout(seconds);
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.getStatement().execute(sql, autoGeneratedKeys);
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.getStatement().execute(sql, columnIndexes);
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.getStatement().execute(sql, columnNames);
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int retVal = this.getStatement().executeUpdate(sql, autoGeneratedKeys);
        return retVal;
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.getStatement().executeUpdate(sql, columnIndexes);
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.getStatement().executeUpdate(sql, columnNames);
    }

    @Override
    public final boolean getMoreResults(int current) throws SQLException {
        return this.getStatement().getMoreResults(current);
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        return this.wrapResultSet(this.getStatement().getGeneratedKeys());
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        int holdability = this.getStatement().getResultSetHoldability();
        return this.controlCheck().checkHoldCursors(holdability);
    }

    public Statement createDuplicateStatement(Connection conn, Statement oldStatement) throws SQLException {
        Statement newStatement = conn.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        this.setStatementState(oldStatement, newStatement);
        return newStatement;
    }

    void setStatementState(Statement oldStatement, Statement newStatement) throws SQLException {
        if (this.cursorName != null) {
            newStatement.setCursorName(this.cursorName);
        }
        if (this.escapeProcessing != null) {
            newStatement.setEscapeProcessing(this.escapeProcessing);
        }
        newStatement.setFetchDirection(oldStatement.getFetchDirection());
        newStatement.setFetchSize(oldStatement.getFetchSize());
        newStatement.setMaxFieldSize(oldStatement.getMaxFieldSize());
        newStatement.setMaxRows(oldStatement.getMaxRows());
        newStatement.setQueryTimeout(oldStatement.getQueryTimeout());
    }

    public Statement getStatement() throws SQLException {
        return this.control.getRealStatement();
    }

    final ResultSet wrapResultSet(ResultSet rs) {
        return this.control.wrapResultSet(this, rs);
    }

    final BrokeredStatementControl controlCheck() throws SQLException {
        this.getStatement().getConnection();
        return this.control;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        this.checkIfClosed();
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkIfClosed();
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw this.unableToUnwrap(iface);
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.getStatement().isClosed();
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw ExceptionFactory.getInstance().getSQLException("XJ012.S", null, null, "Statement");
        }
    }

    final SQLException unableToUnwrap(Class iface) {
        return ExceptionFactory.getInstance().getSQLException("XJ128.S", null, null, iface);
    }

    @Override
    public final boolean isPoolable() throws SQLException {
        return this.getStatement().isPoolable();
    }

    @Override
    public final void setPoolable(boolean poolable) throws SQLException {
        this.getStatement().setPoolable(poolable);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        ((EngineStatement)this.getStatement()).closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return ((EngineStatement)this.getStatement()).isCloseOnCompletion();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeUpdate(sql, columnNames);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return ((EngineStatement)this.getStatement()).getLargeMaxRows();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return ((EngineStatement)this.getStatement()).getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        ((EngineStatement)this.getStatement()).setLargeMaxRows(max);
    }
}

