/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.awt.Color;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.LocalProperties;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;
import org.eclipse.birt.report.engine.nLayout.area.style.BackgroundImageInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.BoxStyle;
import org.eclipse.birt.report.engine.nLayout.area.style.DiagonalInfo;
import org.eclipse.birt.report.engine.util.ResourceLocatorWrapper;
import org.w3c.dom.css.CSSValue;

public class CellArea
extends BlockContainerArea
implements IContainerArea {
    static int DEFAULT_PADDING = 1500;
    static LocalProperties CELL_DEFAULT = new LocalProperties();
    protected int rowSpan = 1;
    protected int colSpan = 1;
    protected int columnID = 0;
    protected int rowID = 0;
    protected DiagonalInfo diagonalInfo;

    static {
        CELL_DEFAULT.setPaddingTop(DEFAULT_PADDING);
        CELL_DEFAULT.setPaddingRight(DEFAULT_PADDING);
        CELL_DEFAULT.setPaddingBottom(DEFAULT_PADDING);
        CELL_DEFAULT.setPaddingLeft(DEFAULT_PADDING);
    }

    public CellArea(ContainerArea parent, LayoutContext context, IContent content) {
        super(parent, context, content);
    }

    public CellArea() {
        this.localProperties = CELL_DEFAULT;
    }

    public CellArea(CellArea cell) {
        super(cell);
        this.rowSpan = cell.rowSpan;
        this.colSpan = cell.colSpan;
        this.columnID = cell.columnID;
        this.rowID = cell.rowID;
        this.diagonalInfo = cell.diagonalInfo;
    }

    public DiagonalInfo getDiagonalInfo() {
        return this.diagonalInfo;
    }

    public void setDiagonalInfo(DiagonalInfo diagonalInfo) {
        this.diagonalInfo = diagonalInfo;
    }

    public int getColumnID() {
        return this.columnID;
    }

    public void setColumnID(int columnID) {
        this.columnID = columnID;
    }

    public int getRowID() {
        return this.rowID;
    }

    public void setRowID(int rowID) {
        this.rowID = rowID;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    @Override
    public void close() throws BirtException {
        this.height = this.currentBP + this.getOffsetY() + this.localProperties.getPaddingBottom();
        this.checkPageBreak();
        this.parent.update(this);
        this.finished = true;
        this.checkDisplayNone();
    }

    @Override
    public void initialize() {
        ICellContent cellContent = (ICellContent)this.content;
        this.rowSpan = cellContent.getRowSpan();
        this.columnID = cellContent.getColumn();
        this.colSpan = cellContent.getColSpan();
        TableArea table = this.getTable();
        this.hasStyle = true;
        this.width = table.getCellWidth(this.columnID, this.columnID + this.colSpan);
        this.buildProperties(cellContent, this.context);
        this.buildDiagonalInfo();
        table.resolveBorderConflict(this, true);
        this.maxAvaWidth = this.getContentWidth();
        boolean isLastColumn = this.columnID + this.colSpan == table.getColumnCount();
        this.isInInlineStacking = table.isInInlineStacking || !isLastColumn;
        this.bookmark = this.content.getBookmark();
        this.action = this.content.getHyperlinkAction();
        this.parent.add(this);
    }

    protected void buildDiagonalInfo() {
        ICellContent cellContent = (ICellContent)this.content;
        if (cellContent.hasDiagonalLine()) {
            int diagonalNumber = cellContent.getDiagonalNumber();
            int diagonalWidth = PropertyUtil.getDimensionValue(cellContent, cellContent.getDiagonalWidth(), this.width);
            String diagonalStyle = cellContent.getDiagonalStyle();
            if (diagonalNumber > 0 && diagonalWidth > 0 && diagonalStyle != null) {
                Color dc = PropertyUtil.getColor(cellContent.getDiagonalColor());
                if (dc == null) {
                    dc = PropertyUtil.getColor(cellContent.getComputedStyle().getProperty(0));
                }
                this.diagonalInfo = new DiagonalInfo();
                this.diagonalInfo.setDiagonal(diagonalNumber, diagonalStyle, diagonalWidth, dc);
            }
            int antidiagonalNumber = cellContent.getAntidiagonalNumber();
            int antidiagonalWidth = PropertyUtil.getDimensionValue(cellContent, cellContent.getAntidiagonalWidth(), this.width);
            String antidiagonalStyle = cellContent.getAntidiagonalStyle();
            if (antidiagonalNumber > 0 && antidiagonalWidth > 0 && antidiagonalStyle != null) {
                Color adc;
                if (this.diagonalInfo == null) {
                    this.diagonalInfo = new DiagonalInfo();
                }
                if ((adc = PropertyUtil.getColor(cellContent.getAntidiagonalColor())) == null) {
                    adc = PropertyUtil.getColor(cellContent.getComputedStyle().getProperty(0));
                }
                this.diagonalInfo.setAntiDiagonal(antidiagonalNumber, antidiagonalStyle, antidiagonalWidth, adc);
            }
        }
    }

    @Override
    protected void buildProperties(IContent content, LayoutContext context) {
        String url;
        IStyle style = content.getComputedStyle();
        this.boxStyle = new BoxStyle();
        Color color = PropertyUtil.getColor(style.getProperty(8));
        if (color != null) {
            this.boxStyle.setBackgroundColor(color);
        }
        if ((url = content.getStyle().getBackgroundImage()) != null) {
            ResourceLocatorWrapper rl = null;
            ExecutionContext exeContext = ((ReportContent)content.getReportContent()).getExecutionContext();
            if (exeContext != null) {
                rl = exeContext.getResourceLocator();
            }
            BackgroundImageInfo backgroundImage = new BackgroundImageInfo(this.getImageUrl(url), style.getProperty(9), 0, 0, 0, 0, rl, this.getCurrentModule(), style.getProperty(61));
            this.boxStyle.setBackgroundImage(backgroundImage);
        }
        this.localProperties = new LocalProperties();
        IStyle cs = content.getStyle();
        CSSValue padding = cs.getProperty(6);
        if (padding == null) {
            this.localProperties.setPaddingTop(DEFAULT_PADDING);
        } else {
            this.localProperties.setPaddingTop(this.getDimensionValue(style.getProperty(6), this.width));
        }
        padding = cs.getProperty(18);
        if (padding == null) {
            this.localProperties.setPaddingBottom(DEFAULT_PADDING);
        } else {
            this.localProperties.setPaddingBottom(this.getDimensionValue(style.getProperty(18), this.width));
        }
        padding = cs.getProperty(3);
        if (padding == null) {
            this.localProperties.setPaddingLeft(DEFAULT_PADDING);
        } else {
            this.localProperties.setPaddingLeft(this.getDimensionValue(style.getProperty(3), this.width));
        }
        padding = cs.getProperty(4);
        if (padding == null) {
            this.localProperties.setPaddingRight(DEFAULT_PADDING);
        } else {
            this.localProperties.setPaddingRight(this.getDimensionValue(style.getProperty(4), this.width));
        }
        this.textAlign = content.getComputedStyle().getProperty(23);
    }

    @Override
    public CellArea cloneArea() {
        CellArea cell = new CellArea(this);
        cell.setRowSpan(this.rowSpan);
        cell.setColSpan(this.colSpan);
        cell.setBoxStyle(new BoxStyle(cell.getBoxStyle()));
        return cell;
    }

    @Override
    public void update(AbstractArea area) throws BirtException {
        super.update(area);
        if (this.currentIP + area.getAllocatedWidth() > this.getContentWidth() || area.getX() < 0) {
            this.setNeedClip(true);
        }
    }

    @Override
    public boolean isPageBreakAfterAvoid() {
        return false;
    }

    @Override
    public boolean isPageBreakBeforeAvoid() {
        return false;
    }

    @Override
    public boolean isPageBreakInsideAvoid() {
        return false;
    }

    @Override
    public CellArea deepClone() {
        CellArea cell = (CellArea)super.deepClone();
        cell.setRowSpan(this.rowSpan);
        cell.setColSpan(this.colSpan);
        cell.setBoxStyle(new BoxStyle(cell.getBoxStyle()));
        if (this.getRowSpan() > 1) {
            cell.setHeight(this.currentBP + this.getOffsetY() + this.localProperties.getPaddingBottom());
        }
        return cell;
    }
}

