/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;

public class ReportProjectPreference
extends Preferences {
    protected static final String ENABLE_SPECIAL_SETTINGS = "Enable Special Settings";
    protected static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";
    public static final String PREFS_FILE_EXTENSION = "prefs";
    private IProject project;
    private String pluginId;

    public ReportProjectPreference(String pluginId, IProject project) {
        this.project = project;
        this.pluginId = pluginId;
        this.load();
    }

    protected IPath getLocation() {
        IPath location = this.project.getLocation();
        return location == null ? null : location.append(DEFAULT_PREFERENCES_DIRNAME).append(this.pluginId).addFileExtension(PREFS_FILE_EXTENSION);
    }

    protected boolean checkSettingLocation() {
        IPath location = this.project.getLocation();
        IPath iPath = location = location == null ? null : location.append(DEFAULT_PREFERENCES_DIRNAME);
        if (location == null) {
            return false;
        }
        File setting = location.toFile();
        if (setting.exists() && setting.isFile()) {
            setting.delete();
        }
        if (!setting.exists()) {
            setting.mkdir();
        }
        return setting.isDirectory() && setting.isDirectory();
    }

    public boolean delete() {
        File file = this.getLocation().toFile();
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public void load() {
        File file;
        if (this.getLocation() != null && (file = this.getLocation().toFile()).exists()) {
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    this.load(fis);
                }
                catch (Exception e) {
                    ExceptionUtil.handle((Throwable)e);
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean save() {
        if (this.propertyNames() == null || this.propertyNames().length == 0) {
            return this.delete();
        }
        boolean flag = false;
        if (this.getLocation() != null && this.checkSettingLocation()) {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(this.getLocation().toFile());
                    this.store(fos, null);
                    flag = true;
                }
                catch (Exception e) {
                    ExceptionUtil.handle((Throwable)e);
                    flag = false;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return flag;
    }

    public boolean hasSpecialSettings() {
        return this.getBoolean(ENABLE_SPECIAL_SETTINGS);
    }

    public void setEnableSpecialSettings(boolean enable) {
        this.setValue(ENABLE_SPECIAL_SETTINGS, enable);
    }
}

