/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.command.ContentElementInfo;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.AbstractTheme;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public class PropertySearchStrategy {
    private static final PropertySearchStrategy instance = new PropertySearchStrategy();

    protected PropertySearchStrategy() {
    }

    public static PropertySearchStrategy getInstance() {
        return instance;
    }

    public Object getPropertyExceptRomDefault(Module module, DesignElement element, ElementPropertyDefn prop) {
        if (prop.isIntrinsic()) {
            return element.getIntrinsicProperty(prop.getName());
        }
        DesignElement e = element;
        Object value = null;
        while (e != null) {
            PropertySearchStrategy tmpStrategy = e.getStrategy();
            value = tmpStrategy.getNonIntrinsicPropertyFromElement(module, e, prop);
            if (value != null) {
                return value;
            }
            if (!prop.isStyleProperty() || e.isStyle() || !tmpStrategy.isInheritableProperty(e, prop)) break;
            e = this.getStyleContainer(e);
        }
        return this.getSessionDefaultValue(module, prop);
    }

    protected DesignElement getStyleContainer(DesignElement designElement) {
        return designElement.getContainer();
    }

    public final Object getPropertyFromElement(Module module, DesignElement element, ElementPropertyDefn prop) {
        if (prop.isIntrinsic()) {
            return element.getIntrinsicProperty(prop.getName());
        }
        return this.getNonIntrinsicPropertyFromElement(module, element, prop);
    }

    protected Object getNonIntrinsicPropertyFromElement(Module module, DesignElement element, ElementPropertyDefn prop) {
        assert (!prop.isIntrinsic());
        Object value = this.getPropertyFromSelf(module, element, prop);
        if (value != null) {
            return value;
        }
        if ((this.isInheritableProperty(element, prop) || prop.isStyleProperty()) && (value = this.getPropertyFromParent(module, element, prop)) != null) {
            return value;
        }
        if (module == null) {
            return null;
        }
        if (prop.isStyleProperty()) {
            value = this.getPropertyFromSelfSelector(module, element, prop);
            if (value != null) {
                return value;
            }
            value = this.getPropertyFromSlotSelector(module, element, prop);
            if (value != null) {
                return value;
            }
            value = this.getPropertyRelatedToContainer(module, element, prop);
            if (value != null) {
                return value;
            }
        }
        return null;
    }

    protected Object getPropertyFromSelf(Module module, DesignElement element, ElementPropertyDefn prop) {
        Object value = element.getLocalProperty(module, prop);
        if (value != null) {
            this.updateContainerForContentElement(module, element, prop, value);
            return value;
        }
        if (!prop.isStyleProperty()) {
            return null;
        }
        StyleElement style = element.getStyle(module);
        if (style != null && (value = style.getLocalProperty(module, prop)) != null) {
            return value;
        }
        return null;
    }

    public Object getPropertyFromParent(Module module, DesignElement element, ElementPropertyDefn prop) {
        Object value = null;
        DesignElement e = element;
        do {
            if (e.isVirtualElement()) {
                DesignElement cur = e;
                if ((e = cur.getVirtualParent()) == null) {
                    e = cur.getDynamicVirtualParent(cur.getRoot());
                }
            } else {
                e = e.getExtendsElement();
            }
            if (e == null) continue;
            Module currentRoot = e.getRoot();
            assert (currentRoot != null);
            value = this.getPropertyFromSelf(currentRoot, e, prop);
            if (value == null) continue;
            this.updateContainerForContentElement(module, element, prop, value);
            return value;
        } while (e != null);
        return value;
    }

    private void updateContainerForContentElement(Module module, DesignElement element, ElementPropertyDefn prop, Object value) {
        if (prop.getTypeCode() != 24 && prop.getSubTypeCode() != 24) {
            return;
        }
        ContentElementInfo info = null;
        if (element instanceof ContentElement) {
            info = ((ContentElement)element).getValueContainer();
        } else if (prop.getTypeCode() == 24 || prop.getSubTypeCode() == 24) {
            info = new ContentElementInfo(element, prop);
        }
        if (value instanceof ContentElement) {
            Module root = ((ContentElement)value).getRoot();
            ContentElementInfo tmpInfo = null;
            if (root != module) {
                tmpInfo = info;
            }
            ((ContentElement)value).setValueContainer(tmpInfo);
        } else if (value instanceof List) {
            List items = (List)value;
            Module root = null;
            ContentElementInfo tmpInfo = null;
            int i = 0;
            while (i < items.size()) {
                ContentElement item = (ContentElement)items.get(i);
                if (root == null && (root = item.getRoot()) != module) {
                    tmpInfo = info;
                }
                item.setValueContainer(tmpInfo);
                ++i;
            }
        }
    }

    protected final Object getPropertyFromSelfSelector(Module module, DesignElement element, ElementPropertyDefn prop) {
        return this.getPropertyFromSelfSelector(module, element, prop, null);
    }

    public Object getPropertyFromSelfSelector(Module module, DesignElement element, ElementPropertyDefn prop, PropertyValueInfo valueInfo) {
        String selector = ((ElementDefn)element.getDefn()).getSelector();
        return this.getPropertyFromSelector(module, element, prop, selector, valueInfo);
    }

    protected final Object getPropertyFromSlotSelector(Module module, DesignElement element, ElementPropertyDefn prop) {
        return this.getPropertyFromSlotSelector(module, element, prop, null);
    }

    public Object getPropertyFromSlotSelector(Module module, DesignElement element, ElementPropertyDefn prop, PropertyValueInfo valueInfo) {
        if (element.getContainer() == null) {
            return null;
        }
        String selector = element.getContainerInfo().getSelector();
        return this.getPropertyFromSelector(module, element, prop, selector, valueInfo);
    }

    protected Object getPropertyFromSelector(Module module, DesignElement element, ElementPropertyDefn prop, String selector, PropertyValueInfo valueInfo) {
        StyleElement style;
        assert (module != null);
        if (selector == null) {
            return null;
        }
        DesignElement e = element;
        while (e != null) {
            AbstractTheme theme;
            if (e instanceof ReportItem && (theme = ((ReportItem)e).getTheme(module)) != null) {
                Object value;
                StyleElement style2 = theme.findStyle(selector);
                if (style2 == null) break;
                if (valueInfo != null) {
                    valueInfo.addSelectorStyle(style2);
                }
                if ((value = style2.getLocalProperty(module, prop)) == null) break;
                return value;
            }
            e = e.getContainer();
        }
        if ((style = module.findStyle(selector)) != null) {
            if (valueInfo != null) {
                valueInfo.addSelectorStyle(style);
            }
            return style.getLocalProperty(module, prop);
        }
        return null;
    }

    public Object getPropertyRelatedToContainer(Module module, DesignElement element, ElementPropertyDefn prop) {
        return null;
    }

    protected Object getSessionDefaultValue(Module module, ElementPropertyDefn prop) {
        if (prop.isStyleProperty()) {
            return module.getSession().getDefaultValue(prop.getName());
        }
        return null;
    }

    protected boolean isInheritableProperty(DesignElement element, ElementPropertyDefn prop) {
        assert (prop != null);
        boolean inherit = prop.canInherit();
        if (!inherit) {
            return false;
        }
        if (element instanceof ReportItem ? "boundDataColumns".equals(prop.getName()) && element.getLocalProperty(element.getRoot(), "dataSet") != null : element instanceof ScalarParameter && "boundDataColumns".equals(prop.getName()) && element.getLocalProperty(element.getRoot(), "dataSetName") != null) {
            return false;
        }
        return inherit;
    }

    public PropertyValueInfo createPropertyValueInfo() {
        return new PropertyValueInfo();
    }

    public static class PropertyValueInfo {
        List<StyleElement> selectorStyles = null;
        private Object value = null;

        PropertyValueInfo() {
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public List<StyleElement> getSelectorStyles() {
            return this.selectorStyles;
        }

        public void addSelectorStyle(StyleElement selectorStyle) {
            if (this.selectorStyles == null) {
                this.selectorStyles = new ArrayList<StyleElement>();
            }
            if (selectorStyle != null && !this.selectorStyles.contains(selectorStyle)) {
                this.selectorStyles.add(selectorStyle);
            }
        }
    }
}

