/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.dbprofile.impl;

import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.datatools.modelbase.sql.query.helper.DataTypeHelper;

public class SQLDataTypeUtility {
    private SQLDataTypeUtility() {
    }

    public static int toJDBCTypeCode(DataType varDataType) {
        int nativeTypeCode;
        if (varDataType == null) {
            return 0;
        }
        String varDataTypeName = varDataType.getName();
        if (varDataTypeName == null && varDataType instanceof PredefinedDataType) {
            varDataTypeName = DataTypeHelper.getPrimitiveTypeName((PrimitiveType)((PredefinedDataType)varDataType).getPrimitiveType());
        }
        if (varDataTypeName != null && (nativeTypeCode = DataTypeHelper.getJDBCTypeForNamedType((String)varDataTypeName)) != 0) {
            return nativeTypeCode;
        }
        if (varDataType instanceof PredefinedDataType) {
            int primitiveType = ((PredefinedDataType)varDataType).getPrimitiveType().getValue();
            switch (primitiveType) {
                case 17: {
                    return 16;
                }
                case 14: {
                    return 6;
                }
            }
        }
        return 0;
    }
}

