/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;

public class TableGroupHandleAdapter
extends DesignElementHandleAdapter {
    private static final String TRANS_LABEL_NOT_INCLUDE = Messages.getString("TableHandleAdapter.transLabel.notInclude");
    private static final String TRANS_LABEL_INCLUDE = Messages.getString("TableHandleAdapter.transLabel.include");

    public TableGroupHandleAdapter(TableGroupHandle table, IModelAdapterHelper mark) {
        super((DesignElementHandle)table, mark);
    }

    protected TableGroupHandle getTableGroupHandle() {
        return (TableGroupHandle)this.getHandle();
    }

    public boolean hasSlotHandleRow(int slotId) {
        SlotHandle slot = this.getTableGroupHandle().getSlot(slotId);
        return slot.getCount() > 0;
    }

    public void insertRowInSlotHandle(int slotId) throws ContentException, NameException {
        this.transStar(String.valueOf(TRANS_LABEL_INCLUDE) + TableHandleAdapter.getOperationName(slotId));
        RowHandle rowHandle = this.getTableGroupHandle().getElementFactory().newTableRow();
        this.getTableHandleAdapter().addCell(rowHandle);
        this.getTableGroupHandle().getSlot(slotId).add((DesignElementHandle)rowHandle);
        this.transEnd();
    }

    public void deleteRowInSlotHandle(int slotId) throws SemanticException {
        this.transStar(String.valueOf(TRANS_LABEL_NOT_INCLUDE) + TableHandleAdapter.getOperationName(slotId));
        this.deleteRows(this.getTableGroupHandle().getSlot(slotId));
        this.transEnd();
    }

    private void deleteRows(SlotHandle rowSlot) throws SemanticException {
        int[] rows = new int[]{};
        for (Object obj : rowSlot) {
            RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(obj);
            int lenegth = rows.length;
            int[] temp = new int[lenegth + 1];
            System.arraycopy(rows, 0, temp, 0, lenegth);
            temp[lenegth] = adapt.getRowNumber();
            rows = temp;
        }
        this.getTableHandleAdapter().deleteRow(rows);
    }

    protected TableHandleAdapter getTableHandleAdapter() {
        return HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableGroupHandle().getContainer());
    }
}

