/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.IAnnotatable;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.IntegerObject;
import org.eclipse.app4mc.amalthea.model.ReferenceObject;
import org.eclipse.app4mc.amalthea.model.StringObject;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.jdt.annotation.NonNull;

public final class CustomPropertyUtil {
    private static final String ARG1_MESSAGE = "First argument is null, expected instance of IAnnotatable";
    private static final String ARG2_MESSAGE = "Key is null or empty, expected non empty String";

    private CustomPropertyUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, int num) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        IntegerObject valueObject = AmaltheaFactory.eINSTANCE.createIntegerObject();
        valueObject.setValue(num);
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, String str) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        StringObject valueObject = AmaltheaFactory.eINSTANCE.createStringObject();
        valueObject.setValue(str);
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, Time time) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Time valueObject = AmaltheaFactory.eINSTANCE.createTime();
        valueObject.setValue(time.getValue());
        valueObject.setUnit(time.getUnit());
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, IReferable reference) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        ReferenceObject valueObject = AmaltheaFactory.eINSTANCE.createReferenceObject();
        valueObject.setValue(reference);
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    public static Integer customGetInteger(@NonNull IAnnotatable object, @NonNull String key) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value valueObject = (Value)object.getCustomProperties().get((Object)key);
        if (valueObject instanceof IntegerObject) {
            return ((IntegerObject)valueObject).getValue();
        }
        return null;
    }

    public static String customGetString(@NonNull IAnnotatable object, @NonNull String key) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value valueObject = (Value)object.getCustomProperties().get((Object)key);
        if (valueObject instanceof StringObject) {
            return ((StringObject)valueObject).getValue();
        }
        return null;
    }

    public static Time customGetTime(@NonNull IAnnotatable object, @NonNull String key) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value valueObject = (Value)object.getCustomProperties().get((Object)key);
        if (valueObject instanceof Time) {
            Time time = (Time)valueObject;
            Time result = AmaltheaFactory.eINSTANCE.createTime();
            result.setValue(time.getValue());
            result.setUnit(time.getUnit());
            return result;
        }
        return null;
    }

    public static IReferable customGetReference(@NonNull IAnnotatable object, @NonNull String key) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value valueObject = (Value)object.getCustomProperties().get((Object)key);
        if (valueObject instanceof ReferenceObject) {
            return ((ReferenceObject)valueObject).getValue();
        }
        return null;
    }
}

