/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.emf.AmaltheaResource;
import org.eclipse.app4mc.amalthea.model.emf.AmaltheaResourceFactory;
import org.eclipse.app4mc.amalthea.model.emf.AmaltheaResourceSetImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class AmaltheaLoader {
    private AmaltheaLoader() {
        throw new IllegalStateException("Utility class");
    }

    public static Amalthea loadFromFileNamed(String pathname) {
        if (pathname == null) {
            return null;
        }
        File file = new File(pathname);
        return AmaltheaLoader.loadFromFile(file);
    }

    public static Amalthea loadFromFile(File file) {
        if (file == null || !file.isFile() || !file.exists()) {
            return null;
        }
        URI uri = URI.createFileURI((String)file.getAbsolutePath());
        return AmaltheaLoader.loadFromURI(uri);
    }

    public static Amalthea loadFromURI(URI uri) {
        if (uri == null) {
            return null;
        }
        ResourceSet resSet = AmaltheaLoader.initializeResourceSet();
        Resource res = resSet.createResource(uri);
        if (res == null) {
            return null;
        }
        try {
            res.load(null);
        }
        catch (IOException iOException) {}
        if (res instanceof AmaltheaResource) {
            ((AmaltheaResource)res).setIntrinsicIDToEObjectMap(null);
        }
        for (EObject content : res.getContents()) {
            if (!(content instanceof Amalthea)) continue;
            return (Amalthea)content;
        }
        return null;
    }

    public static ResourceSet loadFromDirectoryNamed(String pathname) {
        if (pathname == null) {
            return null;
        }
        File folder = new File(pathname);
        return AmaltheaLoader.loadFromDirectory(folder);
    }

    public static ResourceSet loadFromDirectory(File folder) {
        if (folder == null || !folder.isDirectory() || !folder.exists()) {
            return null;
        }
        File[] fileList = folder.listFiles((file, name) -> name.endsWith(".amxmi"));
        ArrayList<URI> uriList = new ArrayList<URI>();
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File amxmiFile = fileArray[n2];
            URI uri = URI.createFileURI((String)amxmiFile.getAbsolutePath());
            if (uri != null) {
                uriList.add(uri);
            }
            ++n2;
        }
        return AmaltheaLoader.loadFromURIs(uriList);
    }

    public static ResourceSet loadFromURIs(List<URI> uriList) {
        if (uriList == null || uriList.isEmpty()) {
            return null;
        }
        ResourceSet resSet = AmaltheaLoader.initializeResourceSet();
        for (URI uri : uriList) {
            Resource res = resSet.createResource(uri);
            try {
                res.load(null);
            }
            catch (IOException iOException) {}
        }
        EcoreUtil.resolveAll((ResourceSet)resSet);
        for (Resource resource : resSet.getResources()) {
            if (!(resource instanceof AmaltheaResource)) continue;
            ((AmaltheaResource)resource).setIntrinsicIDToEObjectMap(null);
        }
        return resSet;
    }

    private static ResourceSet initializeResourceSet() {
        AmaltheaPackage.eINSTANCE.eClass();
        AmaltheaResourceSetImpl resSet = new AmaltheaResourceSetImpl();
        resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("amxmi", new AmaltheaResourceFactory());
        return resSet;
    }
}

