/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.ui.preferences.dialog;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw3d.ui.Draw3DUIPlugin;
import org.eclipse.draw3d.ui.preferences.dialog.BitFieldEditor;
import org.eclipse.draw3d.ui.preferences.dialog.KeyBindingFieldEditor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.ScaleFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CameraPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPropertyChangeListener {
    private Collection<FieldEditor> m_editors = new LinkedList<FieldEditor>();
    private FieldEditor m_invalidEditor;

    public CameraPreferencePage() {
        this.setPreferenceStore(Draw3DUIPlugin.getDefault().getPreferenceStore());
        this.setDescription("Draw3D camera preferences");
    }

    private void addEditor(FieldEditor i_editor) {
        this.m_editors.add(i_editor);
        i_editor.setPage((DialogPage)this);
        i_editor.setPropertyChangeListener((IPropertyChangeListener)this);
        i_editor.setPreferenceStore(this.getPreferenceStore());
        i_editor.load();
    }

    private void addKeyEditor(String i_prefName, String i_label, int i_keyStrokeLimit, Composite i_parent) {
        KeyBindingFieldEditor keyEditor = new KeyBindingFieldEditor(i_prefName, i_label, i_parent);
        keyEditor.setKeyStrokeLimit(i_keyStrokeLimit);
        this.addEditor((FieldEditor)keyEditor);
    }

    private void checkState() {
        for (FieldEditor editor : this.m_editors) {
            if (editor.isValid()) continue;
            this.m_invalidEditor = editor;
            this.setValid(false);
            break;
        }
    }

    protected Control createContents(Composite i_parent) {
        Composite control = new Composite(i_parent, 0);
        control.setLayout((Layout)new GridLayout(1, true));
        this.createMouseControls(control);
        this.createKeyboardControls(control);
        this.checkState();
        return control;
    }

    private void createKeyboardControls(Composite i_parent) {
        Group keyboardGroup = new Group(i_parent, 0);
        keyboardGroup.setText("Keyboard");
        keyboardGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 10;
        fillLayout.marginHeight = 10;
        keyboardGroup.setLayout((Layout)fillLayout);
        Composite editorParent = new Composite((Composite)keyboardGroup, 0);
        this.addKeyEditor("moveForwardKey", "Move forward:", 1, editorParent);
        this.addKeyEditor("moveBackwardKey", "Move backward:", 1, editorParent);
        this.addKeyEditor("leftKey", "Move left:", 1, editorParent);
        this.addKeyEditor("rightKey", "Move right:", 1, editorParent);
        this.addKeyEditor("upKey", "Move up:", 1, editorParent);
        this.addKeyEditor("downKey", "Move down:", 1, editorParent);
        this.addKeyEditor("rollLeftKey", "Roll left:", 1, editorParent);
        this.addKeyEditor("rollRightKey", "Roll right:", 1, editorParent);
        this.addKeyEditor("centerKey", "Center view", 1, editorParent);
    }

    private void createMouseControls(Composite i_parent) {
        int[] modOrbitValues;
        String[] modOrbitLabels;
        Group mouseGroup = new Group(i_parent, 0);
        mouseGroup.setText("Mouse");
        mouseGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 10;
        fillLayout.marginHeight = 10;
        mouseGroup.setLayout((Layout)fillLayout);
        Composite editorParent = new Composite((Composite)mouseGroup, 0);
        this.addEditor((FieldEditor)new ScaleFieldEditor("mouseSensitivity", "Mouse sensitivity:", editorParent, 1, 100, 1, 20));
        if ("macosx".equals(Platform.getOS())) {
            modOrbitLabels = new String[]{"Shift", "Ctrl", "Alt", "Cmd"};
            modOrbitValues = new int[]{131072, 262144, 65536, SWT.MOD1};
        } else {
            modOrbitLabels = new String[]{"Shift", "Ctrl", "Alt"};
            modOrbitValues = new int[]{131072, 262144, 65536};
        }
        this.addEditor(new BitFieldEditor("cameraOrbitMode", "Orbit key:", modOrbitLabels.length, modOrbitLabels, modOrbitValues, editorParent));
    }

    public void init(IWorkbench i_workbench) {
    }

    protected void performApply() {
        for (FieldEditor editor : this.m_editors) {
            editor.store();
        }
    }

    public boolean performCancel() {
        for (FieldEditor editor : this.m_editors) {
            editor.load();
        }
        return true;
    }

    protected void performDefaults() {
        for (FieldEditor editor : this.m_editors) {
            editor.loadDefault();
        }
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    public void propertyChange(PropertyChangeEvent i_event) {
        Object newValue;
        String property = i_event.getProperty();
        if ("field_editor_is_valid".equals(property) && (newValue = i_event.getNewValue()) instanceof Boolean) {
            boolean valid = (Boolean)newValue;
            if (valid) {
                this.checkState();
            } else {
                this.m_invalidEditor = (FieldEditor)i_event.getSource();
                this.setValid(valid);
            }
        }
    }

    public void setVisible(boolean i_visible) {
        super.setVisible(i_visible);
        if (i_visible && this.m_invalidEditor != null) {
            this.m_invalidEditor.setFocus();
        }
    }
}

