/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.ui.quickfix;

import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.model.commands.create.AddNewImportCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateInternalVariableCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateVarInOutCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.structuredtextalgorithm.resource.STAlgorithmResource;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmFactory;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmSource;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.Messages;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.STAlgorithmEditorUtils;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCoreFactory;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarTempDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.VarDeclarationKind;
import org.eclipse.fordiac.ide.structuredtextcore.ui.quickfix.STCoreQuickfixProvider;
import org.eclipse.gef.commands.Command;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class STAlgorithmQuickfixProvider
extends STCoreQuickfixProvider {
    @Fix(value="org.eclipse.fordiac.ide.structuredtextalgorithm.missingAlgorithm")
    public static void fixMissingAlgorithm(Issue issue, IssueResolutionAcceptor acceptor) {
        String algorithmName = issue.getData()[0];
        acceptor.accept(issue, MessageFormat.format(Messages.STAlgorithmQuickfixProvider_Add_missing_algorithm, algorithmName), MessageFormat.format(Messages.STAlgorithmQuickfixProvider_Add_missing_algorithm, algorithmName), null, (element, context) -> {
            if (element instanceof STAlgorithmSource) {
                STAlgorithmSource source = (STAlgorithmSource)element;
                STAlgorithm algorithm = STAlgorithmFactory.eINSTANCE.createSTAlgorithm();
                algorithm.setName(algorithmName);
                algorithm.setBody(STAlgorithmFactory.eINSTANCE.createSTAlgorithmBody());
                source.getElements().add((Object)algorithm);
            }
        });
    }

    @Fix(value="org.eclipse.fordiac.ide.structuredtextalgorithm.unusedAlgorithm")
    public static void fixUnusedAlgorithm(Issue issue, IssueResolutionAcceptor acceptor) {
        String name = issue.getData()[0];
        acceptor.accept(issue, MessageFormat.format(Messages.STAlgorithmQuickfixProvider_Remove_unused_algorithm, name), MessageFormat.format(Messages.STAlgorithmQuickfixProvider_Remove_unused_algorithm, name), null, (element, context) -> {
            EObject eObject = element.eContainer();
            if (eObject instanceof STAlgorithmSource) {
                STAlgorithmSource source = (STAlgorithmSource)eObject;
                source.getElements().remove((Object)element);
            }
        });
        acceptor.accept(issue, Messages.STAlgorithmQuickfixProvider_Remove_all_unused_algorithms, Messages.STAlgorithmQuickfixProvider_Remove_all_unused_algorithms, null, (element, context) -> {
            STAlgorithmResource resource;
            LibraryElement libraryElement;
            STAlgorithmSource source;
            Resource resource2;
            EObject eObject = element.eContainer();
            if (eObject instanceof STAlgorithmSource && (resource2 = (source = (STAlgorithmSource)eObject).eResource()) instanceof STAlgorithmResource && (libraryElement = (resource = (STAlgorithmResource)resource2).getLibraryElement()) instanceof SimpleFBType) {
                SimpleFBType fbType = (SimpleFBType)libraryElement;
                source.getElements().removeIf(sourceElement -> sourceElement instanceof STAlgorithm && fbType.getInterfaceList().getEventInputs().stream().noneMatch(event -> Objects.equals(sourceElement.getName(), event.getName())));
            }
        });
    }

    @Fix(value="org.eclipse.xtext.diagnostics.Diagnostic.Linking")
    public void createMissingVariable(Issue issue, IssueResolutionAcceptor acceptor) {
        super.createMissingVariable(issue, acceptor);
        acceptor.accept(issue, Messages.STAlgorithmQuickfixProvider_CreateMissingInternalVariable, Messages.STAlgorithmQuickfixProvider_CreateMissingInternalVariable, null, (element, context) -> this.createMissingVariable(element, VarDeclarationKind.PLAIN));
    }

    protected void createMissingVariable(ICallable callable, String name, DataType type, VarDeclarationKind kind) {
        ICallable iCallable;
        ICallable iCallable2 = callable;
        Objects.requireNonNull(iCallable2);
        ICallable iCallable3 = iCallable = iCallable2;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STAlgorithm.class, STMethod.class}, (Object)iCallable3, n)) {
                case 0: {
                    STAlgorithm algorithm = (STAlgorithm)iCallable;
                    if (kind != VarDeclarationKind.TEMP) {
                        iCallable3 = iCallable;
                        n = 1;
                        continue block4;
                    }
                    STAlgorithmQuickfixProvider.createSTVarTempDeclaration((EList<STVarTempDeclarationBlock>)algorithm.getBody().getVarTempDeclarations(), name, type);
                    break block4;
                }
                case 1: {
                    STMethod method = (STMethod)iCallable;
                    if (kind == VarDeclarationKind.PLAIN) {
                        iCallable3 = iCallable;
                        n = 2;
                        continue block4;
                    }
                    STAlgorithmQuickfixProvider.createSTVarDeclaration((EList)method.getBody().getVarDeclarations(), (String)name, (DataType)type, (VarDeclarationKind)kind);
                    break block4;
                }
                default: {
                    STAlgorithmQuickfixProvider.createVarDeclaration(callable, name, type, kind);
                }
            }
            break;
        }
    }

    protected static void createVarDeclaration(ICallable callable, String name, DataType type, VarDeclarationKind kind) {
        LibraryElementXtextResource resource;
        LibraryElement libraryElement;
        Resource resource2 = callable.eResource();
        if (resource2 instanceof LibraryElementXtextResource && (libraryElement = (resource = (LibraryElementXtextResource)resource2).getLibraryElement()) instanceof BaseFBType) {
            BaseFBType baseFBType = (BaseFBType)libraryElement;
            URI uRI = resource.getURI();
            STAlgorithmEditorUtils.executeCommand(uRI, (Command)(switch (kind) {
                case VarDeclarationKind.INPUT -> new CreateInterfaceElementCommand(type, name, baseFBType.getInterfaceList(), true, -1);
                case VarDeclarationKind.INOUT -> new CreateVarInOutCommand(type, name, baseFBType.getInterfaceList(), -1);
                case VarDeclarationKind.OUTPUT -> new CreateInterfaceElementCommand(type, name, baseFBType.getInterfaceList(), false, -1);
                case VarDeclarationKind.PLAIN -> new CreateInternalVariableCommand(baseFBType, -1, name, type);
                default -> null;
            }));
        }
    }

    protected static void createSTVarTempDeclaration(EList<STVarTempDeclarationBlock> blocks, String name, DataType type) {
        STVarTempDeclarationBlock block = STAlgorithmQuickfixProvider.getOrCreateSTVarTempDeclarationBlock(blocks);
        STVarDeclaration varDeclaration = STAlgorithmQuickfixProvider.createSTVarDeclaration((String)name, (DataType)type);
        block.getVarDeclarations().add((Object)varDeclaration);
    }

    protected static STVarTempDeclarationBlock getOrCreateSTVarTempDeclarationBlock(EList<STVarTempDeclarationBlock> blocks) {
        return blocks.stream().filter(Predicate.not(STVarDeclarationBlock::isConstant)).findFirst().orElseGet(() -> {
            STVarTempDeclarationBlock block = STCoreFactory.eINSTANCE.createSTVarTempDeclarationBlock();
            blocks.add((Object)block);
            return block;
        });
    }

    protected void createImportProposal(Issue issue, String label, String importedNamespace, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, label, label, null, (element, context) -> {
            STAlgorithmResource resource;
            Resource resource2 = element.eResource();
            if (resource2 instanceof STAlgorithmResource && !ImportHelper.matchesImports((String)importedNamespace, (LibraryElement)(resource = (STAlgorithmResource)resource2).getLibraryElement())) {
                STAlgorithmEditorUtils.executeCommand(resource.getURI(), (Command)new AddNewImportCommand(resource.getLibraryElement(), importedNamespace));
            }
        }, 100);
    }
}

