/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import org.eclipse.fordiac.ide.model.data.WcharType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyCharValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyCharsValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyWCharsValue;
import org.eclipse.fordiac.ide.model.value.WStringValueConverter;

public final class WCharValue
implements AnyCharValue,
AnyWCharsValue {
    public static final WCharValue DEFAULT = new WCharValue('\u0000');
    private final char value;

    private WCharValue(char value) {
        this.value = value;
    }

    public static WCharValue toWCharValue(char value) {
        return new WCharValue(value);
    }

    public static WCharValue toWCharValue(String value) {
        return new WCharValue(!value.isEmpty() ? value.charAt(0) : (char)'\u0000');
    }

    public static WCharValue toWCharValue(AnyCharsValue value) {
        return WCharValue.toWCharValue(value.charValue());
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public char charValue() {
        return this.value;
    }

    @Override
    public String stringValue() {
        return Character.toString(this.value);
    }

    public WcharType getType() {
        return IecTypes.ElementaryTypes.WCHAR;
    }

    public int hashCode() {
        return Character.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WCharValue other = (WCharValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return WStringValueConverter.INSTANCE.toString(this.stringValue());
    }
}

