/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.ConnectionLayoutTagger;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteErrorMarkerCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EventType;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarkerInterfaceHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableMoveFB;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.MappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.ConfigurableFBManagement;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.InterfaceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public abstract class AbstractUpdateBlockFBNElementCommand
extends Command
implements ConnectionLayoutTagger,
ScopedCommand {
    protected final CompoundCommand reconnCmds = new CompoundCommand();
    protected final CompoundCommand resourceConnCreateCmds = new CompoundCommand();
    protected Command mapCmd = null;
    protected UnmapCommand unmapCmd = null;
    protected BlockFBNetworkElement newElement;
    protected final BlockFBNetworkElement oldElement;
    protected int oldIndex;
    protected final FBNetwork network;
    protected TypeEntry entry;

    protected AbstractUpdateBlockFBNElementCommand(BlockFBNetworkElement oldElement) {
        this.oldElement = AbstractUpdateBlockFBNElementCommand.selectOldElement(oldElement);
        this.network = Objects.requireNonNull(this.oldElement.getFbNetwork(), "Element not in a network");
    }

    private static BlockFBNetworkElement selectOldElement(BlockFBNetworkElement oldElement) {
        BlockFBNetworkElement selectedElement = Objects.requireNonNull(oldElement);
        if (selectedElement.isMapped() && selectedElement.getMapping().getTo().equals(selectedElement)) {
            return selectedElement.getOpposite();
        }
        return selectedElement;
    }

    public void execute() {
        Resource resource = null;
        List<ConnData> resourceConns = null;
        if (this.oldElement.isMapped()) {
            resource = this.oldElement.getResource();
            resourceConns = this.getResourceCons();
            this.unmapCmd = new UnmapCommand((FBNetworkElement)this.oldElement);
            this.unmapCmd.execute();
        }
        this.createNewFB();
        AbstractUpdateBlockFBNElementCommand.checkGroup((FBNetworkElement)this.oldElement, (FBNetworkElement)this.newElement);
        this.oldIndex = this.network.getNetworkElements().indexOf((Object)this.oldElement);
        this.network.getNetworkElements().add(this.oldIndex, (Object)this.newElement);
        this.handleErrorMarker();
        this.handleParameters();
        this.handleConnections();
        this.reconnCmds.execute();
        InterfaceList typeInterface = this.newElement.getTypeInterface();
        if (typeInterface != null) {
            this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)typeInterface.getInputVars());
            this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)typeInterface.getOutputVars());
            this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)typeInterface.getInOutVars());
        }
        this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)this.oldElement.getInterface().getInputVars());
        this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)this.oldElement.getInterface().getOutputVars());
        this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)this.oldElement.getInterface().getInOutVars());
        this.network.getNetworkElements().remove((Object)this.oldElement);
        this.newElement.setName(this.oldElement.getName());
        if (resource != null) {
            this.mapCmd = MapToCommand.createMapToCommand((FBNetworkElement)this.newElement, (MappingTarget)resource);
            Command command = this.mapCmd;
            if (command instanceof MapToCommand) {
                MapToCommand mapToCommand = (MapToCommand)command;
                mapToCommand.setElementIndex(this.unmapCmd.getElementIndex());
            }
            if (this.mapCmd.canExecute()) {
                this.mapCmd.execute();
                this.recreateResourceConns(resourceConns);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void handleConfigurableFB() {
        BlockFBNetworkElement blockFBNetworkElement = this.newElement;
        if (!(blockFBNetworkElement instanceof ConfigurableFB)) return;
        ConfigurableFB configFb = (ConfigurableFB)blockFBNetworkElement;
        BlockFBNetworkElement blockFBNetworkElement2 = this.oldElement;
        if (!(blockFBNetworkElement2 instanceof ConfigurableFB)) {
            this.handleConFBUpdateFromErrorMarker(configFb);
            return;
        }
        ConfigurableFB oldConfigFb = (ConfigurableFB)blockFBNetworkElement2;
        configFb.setDataType(oldConfigFb.getDataType());
        if (configFb instanceof Demultiplexer) {
            Demultiplexer oldDemux;
            Demultiplexer newDemux = (Demultiplexer)configFb;
            if (oldConfigFb instanceof Demultiplexer && (oldDemux = (Demultiplexer)oldConfigFb).isIsConfigured()) {
                newDemux.loadConfiguration("VisibleChildren", ConfigurableFBManagement.buildVisibleChildrenString((EList)oldDemux.getMemberVars()));
                return;
            }
        }
        configFb.updateConfiguration();
    }

    private void handleConFBUpdateFromErrorMarker(ConfigurableFB configFb) {
        if (configFb instanceof ConfigurableMoveFB) {
            String dataTypeName = this.oldElement.getAttributeValue("DataType");
            if (dataTypeName != null) {
                configFb.loadConfiguration("DataType", dataTypeName);
                this.oldElement.deleteAttribute("DataType");
            }
        } else {
            String dataTypeName = this.oldElement.getAttributeValue("StructuredType");
            if (dataTypeName != null) {
                String visibleChildren;
                configFb.loadConfiguration("StructuredType", dataTypeName);
                this.oldElement.deleteAttribute("StructuredType");
                if (configFb instanceof Demultiplexer && (visibleChildren = this.oldElement.getAttributeValue("VisibleChildren")) != null) {
                    configFb.loadConfiguration("VisibleChildren", visibleChildren);
                    this.oldElement.deleteAttribute("VisibleChildren");
                }
            }
        }
    }

    public void redo() {
        if (this.unmapCmd != null) {
            this.unmapCmd.redo();
        }
        AbstractUpdateBlockFBNElementCommand.checkGroup((FBNetworkElement)this.oldElement, (FBNetworkElement)this.newElement);
        this.network.getNetworkElements().add(this.oldIndex, (Object)this.newElement);
        this.reconnCmds.redo();
        this.network.getNetworkElements().remove((Object)this.oldElement);
        if (this.mapCmd != null) {
            this.mapCmd.redo();
            this.resourceConnCreateCmds.redo();
        }
    }

    public void undo() {
        if (this.mapCmd != null) {
            this.resourceConnCreateCmds.undo();
            this.mapCmd.undo();
        }
        this.network.getNetworkElements().add(this.oldIndex, (Object)this.oldElement);
        this.reconnCmds.undo();
        this.network.getNetworkElements().remove((Object)this.newElement);
        AbstractUpdateBlockFBNElementCommand.checkGroup((FBNetworkElement)this.newElement, (FBNetworkElement)this.oldElement);
        if (this.unmapCmd != null) {
            this.unmapCmd.undo();
        }
    }

    private static void checkGroup(FBNetworkElement oldElem, FBNetworkElement newElem) {
        if (oldElem.isInGroup()) {
            newElem.setGroup(oldElem.getGroup());
            oldElem.setGroup(null);
        }
    }

    protected void setInterface() {
        AdapterFB adapterFB;
        InterfaceTypeEntry interfaceTypeEntry;
        InterfaceList typeInterface = this.newElement.getTypeInterface();
        BlockFBNetworkElement blockFBNetworkElement = this.newElement;
        if (blockFBNetworkElement instanceof AdapterFB && (interfaceTypeEntry = (adapterFB = (AdapterFB)blockFBNetworkElement).getTypeEntry()) instanceof AdapterTypeEntry) {
            AdapterTypeEntry adapterTypeEntry = (AdapterTypeEntry)interfaceTypeEntry;
            AdapterType adpType = adapterTypeEntry.getType();
            InterfaceList interfaceList = typeInterface = adapterFB.isPlug() ? adpType.getPlugType().getInterfaceList() : adpType.getInterfaceList();
        }
        if (typeInterface != null) {
            this.newElement.setInterface(typeInterface.copy());
        } else {
            this.newElement.setInterface(LibraryElementFactory.eINSTANCE.createInterfaceList());
        }
    }

    private void transferVisibleAndVarConfigAttributes(EList<VarDeclaration> varDeclList) {
        varDeclList.forEach(varDecl -> {
            IInterfaceElement iInterfaceElement = this.newElement.getInterfaceElement(varDecl.getName());
            if (iInterfaceElement instanceof VarDeclaration) {
                VarDeclaration newDecl = (VarDeclaration)iInterfaceElement;
                if (newDecl.isIsInput() && newDecl.getInputConnections().isEmpty() || !newDecl.isIsInput() && newDecl.getOutputConnections().isEmpty()) {
                    newDecl.setVisible(varDecl.isVisible());
                }
                if (newDecl.isInOutVar()) {
                    newDecl.setVisible(varDecl.isVisible());
                    newDecl.getInOutVarOpposite().setVisible(varDecl.getInOutVarOpposite().isVisible());
                }
                newDecl.setVarConfig(varDecl.isVarConfig());
            }
        });
    }

    private void recreateResourceConns(List<ConnData> resourceConns) {
        BlockFBNetworkElement orgMappedElement = (BlockFBNetworkElement)this.unmapCmd.getMappedFBNetworkElement();
        BlockFBNetworkElement copiedMappedElement = this.newElement.getOpposite();
        for (ConnData connData : resourceConns) {
            IInterfaceElement source = AbstractUpdateBlockFBNElementCommand.findUpdatedInterfaceElement(copiedMappedElement, orgMappedElement, connData.source);
            IInterfaceElement dest = AbstractUpdateBlockFBNElementCommand.findUpdatedInterfaceElement(copiedMappedElement, orgMappedElement, connData.dest);
            if (source == null || dest == null) continue;
            AbstractConnectionCreateCommand dccc = AbstractUpdateBlockFBNElementCommand.createConnectionCreateCommand(copiedMappedElement.getFbNetwork(), source.getType());
            dccc.setSource(source);
            dccc.setDestination(dest);
            if (!dccc.canExecute()) continue;
            dccc.execute();
            this.resourceConnCreateCmds.add((Command)dccc);
        }
    }

    private static IInterfaceElement findUpdatedInterfaceElement(BlockFBNetworkElement newElement, BlockFBNetworkElement oldElement, IInterfaceElement oldInterface) {
        if (oldInterface != null && oldInterface.getBlockFBNetworkElement() == oldElement) {
            return AbstractUpdateBlockFBNElementCommand.updateSelectedInterface(oldInterface, newElement);
        }
        return oldInterface;
    }

    private static Stream<Connection> getAllConnections(BlockFBNetworkElement element) {
        return element.getInterface().getAllInterfaceElements().stream().map(ifEle -> {
            if (ifEle.isIsInput()) {
                return ifEle.getInputConnections();
            }
            return ifEle.getOutputConnections();
        }).flatMap(Collection::stream).distinct();
    }

    private void createValues() {
        this.newElement.getInterface().getInputVars().stream().forEach(inVar -> {
            inVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
            this.checkSourceParam((VarDeclaration)inVar);
        });
    }

    private void transferInstanceComments() {
        this.oldElement.getInterface().getAllInterfaceElements().stream().filter(ie -> !ie.getComment().isBlank()).forEach(ie -> {
            IInterfaceElement newIE = this.newElement.getInterfaceElement(ie.getName());
            if (newIE != null) {
                newIE.setComment(ie.getComment());
            }
        });
    }

    private void checkSourceParam(VarDeclaration variable) {
        VarDeclaration srcVar = this.oldElement.getInterface().getVariable(variable.getName());
        if (srcVar != null && srcVar.getValue() != null) {
            variable.getValue().setValue(srcVar.getValue().getValue());
        }
    }

    protected List<ConnData> getResourceCons() {
        ArrayList<ConnData> retVal = new ArrayList<ConnData>();
        BlockFBNetworkElement resElement = this.oldElement.getOpposite();
        AbstractUpdateBlockFBNElementCommand.getAllConnections(resElement).forEach(conn -> {
            IInterfaceElement source = conn.getSource();
            IInterfaceElement dest = conn.getDestination();
            if (!source.getBlockFBNetworkElement().isMapped() || !dest.getBlockFBNetworkElement().isMapped()) {
                retVal.add(new ConnData(conn.getSource(), conn.getDestination()));
            } else if (source.getBlockFBNetworkElement() == resElement && dest.getBlockFBNetworkElement().getOpposite().getFbNetwork() != this.oldElement.getFbNetwork() || dest.getBlockFBNetworkElement() == resElement && source.getBlockFBNetworkElement().getOpposite().getFbNetwork() != this.oldElement.getFbNetwork()) {
                retVal.add(new ConnData(conn.getSource(), conn.getDestination()));
            }
        });
        return retVal;
    }

    private void handleErrorMarker() {
        if (this.oldElement instanceof ErrorMarkerFBNElement && this.newElement instanceof ErrorMarkerFBNElement) {
            this.copyErrorMarkerRef();
        }
    }

    protected void handleParameters() {
        this.processVars(this.oldElement.getInterface());
        this.processEvents(this.oldElement.getInterface());
        this.checkErrorMarkerPinParameters();
    }

    private void processEvents(InterfaceList interfaceList) {
        for (Event input : interfaceList.getEventInputs()) {
            if (!input.getInputConnections().isEmpty() || input.getAttributes().isEmpty()) continue;
            AbstractUpdateBlockFBNElementCommand.updateSelectedInterface((IInterfaceElement)input, this.newElement);
        }
        for (Event output : interfaceList.getEventOutputs()) {
            if (!output.getOutputConnections().isEmpty() || output.getAttributes().isEmpty()) continue;
            AbstractUpdateBlockFBNElementCommand.updateSelectedInterface((IInterfaceElement)output, this.newElement);
        }
    }

    private void processVars(InterfaceList interfaceList) {
        ArrayList inputs = new ArrayList();
        inputs.addAll(interfaceList.getInputVars());
        inputs.addAll(interfaceList.getInOutVars());
        ArrayList outputs = new ArrayList();
        outputs.addAll(interfaceList.getOutputVars());
        outputs.addAll(interfaceList.getOutMappedInOutVars());
        for (VarDeclaration input : inputs) {
            if (!input.getInputConnections().isEmpty() || !AbstractUpdateBlockFBNElementCommand.hasValue(input.getValue()) && (input.getAttributes().isEmpty() || !AbstractUpdateBlockFBNElementCommand.varDeclHasNonInternalAttr(input))) continue;
            AbstractUpdateBlockFBNElementCommand.updateSelectedInterface((IInterfaceElement)input, this.newElement);
        }
        for (VarDeclaration output : outputs) {
            if (!output.getOutputConnections().isEmpty() || !AbstractUpdateBlockFBNElementCommand.hasValue(output.getValue()) && (output.getAttributes().isEmpty() || !AbstractUpdateBlockFBNElementCommand.varDeclHasNonInternalAttr(output))) continue;
            AbstractUpdateBlockFBNElementCommand.updateSelectedInterface((IInterfaceElement)output, this.newElement);
        }
    }

    private static boolean varDeclHasNonInternalAttr(VarDeclaration vd) {
        return !vd.getAttributes().stream().filter(attr -> !InternalAttributeDeclarations.isInternalAttribute((Attribute)attr)).toList().isEmpty();
    }

    private void checkErrorMarkerPinParameters() {
        for (ErrorMarkerInterface erroMarker : this.oldElement.getInterface().getErrorMarker()) {
            if (!AbstractUpdateBlockFBNElementCommand.hasValue(erroMarker.getValue())) continue;
            IInterfaceElement iInterfaceElement = this.newElement.getInterfaceElement(erroMarker.getName());
            if (iInterfaceElement instanceof VarDeclaration) {
                VarDeclaration varDeclaration = (VarDeclaration)iInterfaceElement;
                Value value = LibraryElementFactory.eINSTANCE.createValue();
                value.setValue(erroMarker.getValue().getValue());
                varDeclaration.setValue(value);
                if (!erroMarker.isIsInput() || !erroMarker.getInputConnections().isEmpty()) continue;
                this.reconnCmds.add((Command)new DeleteErrorMarkerCommand(erroMarker, (FBNetworkElement)this.oldElement));
                continue;
            }
            if ((!erroMarker.isIsInput() || !erroMarker.getInputConnections().isEmpty()) && (erroMarker.isIsInput() || !erroMarker.getOutputConnections().isEmpty())) continue;
            AbstractUpdateBlockFBNElementCommand.updateSelectedInterface((IInterfaceElement)erroMarker, this.newElement);
        }
    }

    private static boolean hasValue(Value value) {
        return value != null && value.getValue() != null && !value.getValue().isBlank();
    }

    private void copyErrorMarkerRef() {
        FBNetworkElement repairedElement = ((ErrorMarkerFBNElement)this.oldElement).getRepairedElement();
        if (repairedElement != null) {
            ((ErrorMarkerFBNElement)this.newElement).setRepairedElement(repairedElement);
        }
    }

    private static ErrorMarkerInterface createMissingMarker(IInterfaceElement oldInterface, BlockFBNetworkElement element) {
        VarDeclaration oldVarDecl;
        ErrorMarkerInterface interfaceElement = FordiacErrorMarkerInterfaceHelper.createErrorMarkerInterface((DataType)oldInterface.getType(), (String)oldInterface.getName(), (boolean)oldInterface.isIsInput(), (InterfaceList)element.getInterface());
        if (oldInterface instanceof VarDeclaration && (oldVarDecl = (VarDeclaration)oldInterface).getValue() != null && !oldVarDecl.getValue().getValue().isBlank()) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            value.setValue(oldVarDecl.getValue().getValue());
            interfaceElement.setValue(value);
        }
        for (Attribute attribute : oldInterface.getAttributes()) {
            if (InternalAttributeDeclarations.isInternalAttribute((Attribute)attribute)) continue;
            interfaceElement.setAttribute(attribute.getName(), attribute.getType(), attribute.getValue(), attribute.getComment());
        }
        interfaceElement.setComment(oldInterface.getComment());
        return interfaceElement;
    }

    private static IInterfaceElement updateSelectedInterface(IInterfaceElement oldInterface, BlockFBNetworkElement newElement) {
        IInterfaceElement updatedSelected;
        IInterfaceElement iInterfaceElement = updatedSelected = oldInterface.isIsInput() ? newElement.getInput(oldInterface.getName()) : newElement.getOutput(oldInterface.getName());
        if (updatedSelected == null || updatedSelected.isIsInput() != oldInterface.isIsInput()) {
            updatedSelected = AbstractUpdateBlockFBNElementCommand.createMissingMarker(oldInterface, newElement);
        }
        return updatedSelected;
    }

    private void handleConnections() {
        AbstractUpdateBlockFBNElementCommand.getAllConnections(this.oldElement).forEach(this::handleConnection);
    }

    private void handleConnection(Connection connection) {
        IInterfaceElement source = connection.getSource();
        IInterfaceElement destination = connection.getDestination();
        if (connection.getSourceElement() == this.oldElement) {
            source = AbstractUpdateBlockFBNElementCommand.updateSelectedInterface(source, this.newElement);
        }
        if (connection.getDestinationElement() == this.oldElement) {
            destination = AbstractUpdateBlockFBNElementCommand.updateSelectedInterface(destination, this.newElement);
        }
        this.replaceConnection(connection, source, destination);
    }

    private void replaceConnection(Connection oldConn, IInterfaceElement source, IInterfaceElement dest) {
        this.reconnCmds.add((Command)new DeleteConnectionCommand(oldConn, true));
        FBNetwork fbn = oldConn.getFBNetwork();
        AbstractConnectionCreateCommand cmd = AbstractUpdateBlockFBNElementCommand.createConnectionCreateCommand(fbn, source.getType());
        cmd.setSource(source);
        cmd.setDestination(dest);
        cmd.setAttributes((List<Attribute>)oldConn.getAttributes());
        cmd.setArrangementConstraints(oldConn.getRoutingData());
        cmd.setElementIndex(fbn.getConnectionIndex(oldConn));
        this.reconnCmds.add((Command)cmd);
    }

    private static AbstractConnectionCreateCommand createConnectionCreateCommand(FBNetwork fbn, DataType type) {
        if (type instanceof EventType) {
            return new EventConnectionCreateCommand(fbn);
        }
        if (type instanceof AdapterType) {
            return new AdapterConnectionCreateCommand(fbn);
        }
        return new DataConnectionCreateCommand(fbn);
    }

    protected void createNewFB() {
        this.newElement = this.createCopiedFBEntry(this.oldElement);
        this.setInterface();
        this.handleConfigurableFB();
        this.newElement.setName(this.oldElement.getName());
        this.newElement.setPosition((Position)EcoreUtil.copy((EObject)this.oldElement.getPosition()));
        BlockFBNetworkElement blockFBNetworkElement = this.newElement;
        if (blockFBNetworkElement instanceof TypedSubApp) {
            TypedSubApp newTsa = (TypedSubApp)blockFBNetworkElement;
            BlockFBNetworkElement blockFBNetworkElement2 = this.oldElement;
            if (blockFBNetworkElement2 instanceof TypedSubApp) {
                TypedSubApp oldTsa = (TypedSubApp)blockFBNetworkElement2;
                if (this.oldElement.getTypeEntry() == this.entry) {
                    newTsa.getVarConfigParams().addAll(EcoreUtil.copyAll((Collection)oldTsa.getVarConfigParams()));
                }
            }
        }
        this.copyAttributes();
        this.createValues();
        this.transferInstanceComments();
    }

    private void copyAttributes() {
        this.newElement.getAttributes().addAll(EcoreUtil.copyAll((Collection)this.oldElement.getAttributes()));
        this.oldElement.getInterface().getAllInterfaceElements().stream().filter(ie -> !ie.getAttributes().isEmpty()).forEach(ie -> {
            IInterfaceElement newIE = this.newElement.getInterfaceElement(ie.getName());
            if (newIE != null) {
                newIE.getAttributes().addAll(EcoreUtil.copyAll((Collection)ie.getAttributes()));
            }
        });
    }

    protected abstract BlockFBNetworkElement createCopiedFBEntry(BlockFBNetworkElement var1);

    public BlockFBNetworkElement getOldElement() {
        return this.oldElement;
    }

    public BlockFBNetworkElement getNewElement() {
        return this.newElement;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.network);
    }

    protected static class ConnData {
        private final IInterfaceElement source;
        private final IInterfaceElement dest;

        public ConnData(IInterfaceElement source, IInterfaceElement dest) {
            this.source = source;
            this.dest = dest;
        }
    }
}

