/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.fordiac.ide.model.dataimport.ADPImporter;
import org.eclipse.fordiac.ide.model.dataimport.AttributeTypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.DEVImporter;
import org.eclipse.fordiac.ide.model.dataimport.DataTypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBTImporter;
import org.eclipse.fordiac.ide.model.dataimport.FCTImporter;
import org.eclipse.fordiac.ide.model.dataimport.GlobalConstantsImporter;
import org.eclipse.fordiac.ide.model.dataimport.RESImporter;
import org.eclipse.fordiac.ide.model.dataimport.SEGImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppTImporter;
import org.eclipse.fordiac.ide.model.dataimport.TypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.TextFunctionBody;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.AttributeTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DeviceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FunctionFBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.GlobalConstantsEntry;
import org.eclipse.fordiac.ide.model.typelibrary.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SegmentTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class TypeFromTemplateCreator {
    private final IFile targetTypeFile;
    private final File typeTemplate;
    private final String packageName;
    private TypeEntry entry;

    public TypeFromTemplateCreator(IFile targetTypeFile, File typeTemplate) {
        this(targetTypeFile, typeTemplate, null);
    }

    public TypeFromTemplateCreator(IFile targetTypeFile, File typeTemplate, String packageName) {
        this.targetTypeFile = targetTypeFile;
        this.typeTemplate = typeTemplate;
        this.packageName = packageName;
    }

    public void createTypeFromTemplate(IProgressMonitor monitor) {
        this.entry = TypeLibraryManager.INSTANCE.getTypeLibrary(this.targetTypeFile.getProject()).createTypeEntry(this.targetTypeFile);
        final TypeImporter importer = this.getTypeImporter(this.entry);
        if (importer != null) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation((ISchedulingRule)this.getFirstExistingParent()){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    try {
                        importer.loadElement();
                    }
                    catch (IOException | XMLStreamException | TypeImportException e) {
                        throw new InvocationTargetException(e);
                    }
                    LibraryElement type = importer.getElement();
                    type.setName(TypeEntry.getTypeNameFromFile((IFile)TypeFromTemplateCreator.this.targetTypeFile));
                    PackageNameHelper.setPackageName((LibraryElement)type, (String)TypeFromTemplateCreator.this.packageName);
                    TypeFromTemplateCreator.setupIdentifcationAndVersionInfo(type, TypeFromTemplateCreator.this.targetTypeFile.getProject());
                    TypeFromTemplateCreator.this.performTypeSpecificSetup(type);
                    TypeFromTemplateCreator.this.entry.save(type, monitor);
                }
            };
            try {
                operation.run(monitor);
            }
            catch (InvocationTargetException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        } else {
            this.entry = null;
        }
    }

    private IContainer getFirstExistingParent() {
        IContainer parent = this.targetTypeFile.getParent();
        while (parent != null && !parent.exists()) {
            parent = parent.getParent();
        }
        return parent != null ? parent : this.targetTypeFile.getProject();
    }

    protected void performTypeSpecificSetup(LibraryElement type) {
        FunctionFBType functionFBType;
        FunctionBody functionBody;
        if (type instanceof FunctionFBType && (functionBody = (functionFBType = (FunctionFBType)type).getBody()) instanceof TextFunctionBody) {
            TextFunctionBody body = (TextFunctionBody)functionBody;
            body.setText(body.getText().replace("Function", functionFBType.getName()));
        }
    }

    private TypeImporter getTypeImporter(TypeEntry entry) {
        if (entry instanceof AdapterTypeEntry) {
            return new ADPImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof AttributeTypeEntry) {
            return new AttributeTypeImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof DataTypeEntry) {
            return new DataTypeImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof DeviceTypeEntry) {
            return new DEVImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof FunctionFBTypeEntry) {
            return new FCTImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof FBTypeEntry) {
            return new FBTImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof ResourceTypeEntry) {
            return new RESImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof SegmentTypeEntry) {
            return new SEGImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof SubAppTypeEntry) {
            return new SubAppTImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof GlobalConstantsEntry) {
            return new GlobalConstantsImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        return null;
    }

    private static void setupIdentifcationAndVersionInfo(LibraryElement type, IProject project) {
        TypeManagementPreferencesHelper.setupIdentification(type, project);
        TypeManagementPreferencesHelper.setupVersionInfo(type, project);
    }

    public TypeEntry getTypeEntry() {
        return this.entry;
    }
}

