/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppInterfaceListImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;

class SubAppNetworkImporter
extends FBNetworkImporter {
    public SubAppNetworkImporter(CommonElementImporter importer) {
        super(importer);
    }

    public SubAppNetworkImporter(CommonElementImporter importer, InterfaceList interfaceList) {
        super(importer, LibraryElementFactory.eINSTANCE.createFBNetwork(), interfaceList);
    }

    protected SubAppNetworkImporter(CommonElementImporter importer, FBNetwork fbNetwork, Map<String, FBNetworkElement> fbNetworkElementMap) {
        super(importer, fbNetwork, fbNetworkElementMap);
    }

    @Override
    protected boolean handleFBNetworkChild(String name) throws XMLStreamException, TypeImportException {
        if ("SubApp".equals(name)) {
            this.parseSubApp();
            return true;
        }
        return super.handleFBNetworkChild(name);
    }

    private void parseSubApp() throws TypeImportException, XMLStreamException {
        String type = this.getAttributeValue("Type");
        SubApp subApp = type == null ? LibraryElementFactory.eINSTANCE.createUntypedSubApp() : this.createTypedSubapp(type);
        this.readNameCommentAttributes(subApp);
        this.getXandY(subApp);
        this.addFBNetworkElement(subApp);
        if (subApp instanceof UntypedSubApp) {
            SubApp untypedSubApp = subApp;
            this.parseUntypedSubapp((UntypedSubApp)untypedSubApp);
        } else {
            this.parseFBChildren(subApp, "SubApp");
        }
        for (VarDeclaration inVar : subApp.getInterface().getInputVars()) {
            if (inVar.getValue() != null) continue;
            inVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
        }
        for (VarDeclaration inVar : subApp.getInterface().getInOutVars()) {
            if (inVar.getValue() != null) continue;
            inVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
        }
        for (VarDeclaration inOutVar : subApp.getInterface().getInOutVars()) {
            if (!inOutVar.getAttributes().stream().map(INamedElement::getName).anyMatch("VisibleOutSide"::equals) || !inOutVar.getInOutVarOpposite().isVisible()) continue;
            inOutVar.getInOutVarOpposite().setVisible(false);
            inOutVar.deleteAttribute("VisibleOutSide");
        }
    }

    public TypedSubApp createTypedSubapp(String typeName) {
        SubAppTypeEntry subEntry = this.getTypeEntry(typeName, this.getTypeLibrary()::getSubAppTypeEntry);
        if (subEntry == null) {
            subEntry = (SubAppTypeEntry)this.addDependency(this.getTypeLibrary().createErrorTypeEntry(typeName, LibraryElementPackage.eINSTANCE.getSubAppType()));
        }
        TypedSubApp subApp = LibraryElementFactory.eINSTANCE.createTypedSubApp();
        subApp.setTypeEntry(subEntry);
        InterfaceList interfaceList = subEntry.getInterface();
        interfaceList = interfaceList == null ? LibraryElementFactory.eINSTANCE.createInterfaceList() : interfaceList.copy();
        subApp.setInterface(interfaceList);
        return subApp;
    }

    private void parseUntypedSubapp(UntypedSubApp subApp) throws TypeImportException, XMLStreamException {
        this.processChildren("SubApp", name -> switch (name) {
            case "SubAppInterfaceList" -> {
                SubAppInterfaceListImporter interfaceImporter = new SubAppInterfaceListImporter(this);
                subApp.setInterface(interfaceImporter.parseInterfaceList("SubAppInterfaceList"));
                yield true;
            }
            case "SubAppNetwork" -> {
                SubAppNetworkImporter subAppImporter = new SubAppNetworkImporter(this, subApp.getInterface());
                subApp.setSubAppNetwork(subAppImporter.getFbNetwork());
                subAppImporter.parseFBNetwork("SubAppNetwork");
                yield true;
            }
            case "Parameter" -> {
                this.parseParameter(subApp);
                yield true;
            }
            case "Attribute" -> {
                this.parseUntypedSubappAttributes(subApp);
                yield true;
            }
            default -> false;
        });
    }

    private void parseUntypedSubappAttributes(SubApp subApp) throws XMLStreamException, TypeImportException {
        block17: {
            block15: {
                String name = this.getAttributeValue("Name");
                if (name == null) break block15;
                switch (name) {
                    case "width": {
                        String widthValue = this.getAttributeValue("Value");
                        if (widthValue != null) {
                            subApp.setWidth(Double.parseDouble(widthValue));
                            break;
                        }
                        break block17;
                    }
                    case "height": {
                        String heightValue = this.getAttributeValue("Value");
                        if (heightValue != null) {
                            subApp.setHeight(Double.parseDouble(heightValue));
                            break;
                        }
                        break block17;
                    }
                    case "locked": {
                        String isLocked = this.getAttributeValue("Value");
                        subApp.setLocked(Boolean.parseBoolean(isLocked));
                        break;
                    }
                    default: {
                        this.parseGenericAttributeNode(subApp);
                        break;
                    }
                }
                break block17;
            }
            this.parseGenericAttributeNode(subApp);
        }
        this.proceedToEndElementNamed("Attribute");
    }
}

