/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.set.primitive.ImmutableShortSetFactory;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.impl.factory.primitive.ShortSets;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableShortEmptySet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableShortSingletonSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;

@ServiceProvider(value=ImmutableShortSetFactory.class)
public class ImmutableShortSetFactoryImpl
implements ImmutableShortSetFactory {
    public static final ImmutableShortSetFactory INSTANCE = new ImmutableShortSetFactoryImpl();

    public ImmutableShortSet empty() {
        return ImmutableShortEmptySet.INSTANCE;
    }

    public ImmutableShortSet of() {
        return this.empty();
    }

    public ImmutableShortSet with() {
        return this.empty();
    }

    public ImmutableShortSet of(short one) {
        return this.with(one);
    }

    public ImmutableShortSet with(short one) {
        return new ImmutableShortSingletonSet(one);
    }

    public ImmutableShortSet of(short ... items) {
        return this.with(items);
    }

    public ImmutableShortSet with(short ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ShortHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableShortSet ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    public ImmutableShortSet withAll(ShortIterable items) {
        if (items instanceof ImmutableShortSet) {
            return (ImmutableShortSet)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableShortSet ofAll(Iterable<Short> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableShortSet withAll(Iterable<Short> iterable) {
        return ShortSets.mutable.withAll(iterable).toImmutable();
    }
}

