/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.ui.internal.dialogs.HyperlinkSourceViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;

public class HyperlinkTokenScanner
implements ITokenScanner {
    private static final String URL_HYPERLINK_DETECTOR_KEY = "org.eclipse.ui.internal.editors.text.URLHyperlinkDetector";
    private int tokenStart;
    private int lastLineStart;
    private IToken hyperlinkToken;
    private Set<IHyperlinkDetector> hyperlinkDetectors;
    private final ISourceViewer viewer;
    private final SourceViewerConfiguration configuration;
    private final IPreferenceStore preferenceStore;
    private final List<IHyperlink> hyperlinksOnLine = new ArrayList<IHyperlink>();
    protected int currentOffset;
    protected int endOfRange;
    protected IDocument document;
    protected IToken defaultToken;

    public HyperlinkTokenScanner(SourceViewerConfiguration configuration, ISourceViewer viewer) {
        this(configuration, viewer, null);
    }

    public HyperlinkTokenScanner(SourceViewerConfiguration configuration, ISourceViewer viewer, @Nullable Token defaultToken) {
        this(configuration, viewer, null, defaultToken);
    }

    protected HyperlinkTokenScanner(SourceViewerConfiguration configuration, ISourceViewer viewer, @Nullable IPreferenceStore preferenceStore, @Nullable Token defaultToken) {
        this.viewer = viewer;
        this.configuration = configuration;
        this.preferenceStore = preferenceStore == null ? EditorsUI.getPreferenceStore() : preferenceStore;
        this.setDefaultToken(defaultToken);
    }

    public void setRange(IDocument document, int offset, int length) {
        Assert.isNotNull((Object)document);
        this.setRangeAndColor(document, offset, length, JFaceColors.getHyperlinkText((Display)this.viewer.getTextWidget().getDisplay()));
    }

    public IToken nextToken() {
        block12: {
            this.tokenStart = this.currentOffset;
            if (this.currentOffset >= this.endOfRange) {
                this.hyperlinksOnLine.clear();
                return Token.EOF;
            }
            if (this.hyperlinkDetectors != null && !this.hyperlinkDetectors.isEmpty()) {
                try {
                    IRegion currentLine = this.document.getLineInformationOfOffset(this.currentOffset);
                    if (currentLine.getOffset() != this.lastLineStart) {
                        this.hyperlinksOnLine.clear();
                        Iterator<IHyperlinkDetector> detectors = this.hyperlinkDetectors.iterator();
                        while (detectors.hasNext()) {
                            IHyperlinkDetector hyperlinkDetector = detectors.next();
                            if (hyperlinkDetector instanceof HyperlinkSourceViewer.NoMaskHyperlinkDetector) continue;
                            IHyperlink[] newLinks = null;
                            try {
                                newLinks = hyperlinkDetector.detectHyperlinks((ITextViewer)this.viewer, currentLine, false);
                            }
                            catch (RuntimeException e) {
                                detectors.remove();
                            }
                            if (newLinks == null || newLinks.length <= 0) continue;
                            Collections.addAll(this.hyperlinksOnLine, newLinks);
                        }
                        Collections.sort(this.hyperlinksOnLine, (a, b) -> {
                            int diff = a.getHyperlinkRegion().getOffset() - b.getHyperlinkRegion().getOffset();
                            if (diff != 0) {
                                return diff;
                            }
                            return a.getHyperlinkRegion().getLength() - b.getHyperlinkRegion().getLength();
                        });
                        this.lastLineStart = currentLine.getOffset();
                    }
                    if (this.hyperlinksOnLine.isEmpty()) break block12;
                    Iterator<IHyperlink> iterator = this.hyperlinksOnLine.iterator();
                    while (iterator.hasNext()) {
                        IHyperlink next = iterator.next();
                        IRegion linkRegion = next.getHyperlinkRegion();
                        int linkEnd = linkRegion.getOffset() + linkRegion.getLength();
                        if (this.currentOffset >= linkEnd) {
                            iterator.remove();
                            continue;
                        }
                        if (linkRegion.getOffset() <= this.currentOffset) {
                            iterator.remove();
                            int end = Math.min(this.endOfRange, linkEnd);
                            if (end <= this.currentOffset) continue;
                            this.currentOffset = end;
                            return this.hyperlinkToken;
                        }
                        break;
                    }
                }
                catch (BadLocationException currentLine) {
                    // empty catch block
                }
            }
        }
        int actualOffset = this.currentOffset;
        IToken token = this.scanToken();
        if (token != null && actualOffset < this.currentOffset) {
            return token;
        }
        this.currentOffset = actualOffset + 1;
        return this.defaultToken;
    }

    public int getTokenOffset() {
        return this.tokenStart;
    }

    public int getTokenLength() {
        return this.currentOffset - this.tokenStart;
    }

    public void setDefaultToken(Token token) {
        this.defaultToken = token == null ? new Token(null) : token;
    }

    protected void setRangeAndColor(@NonNull IDocument document, int offset, int length, @Nullable Color color) {
        Assert.isTrue((document == this.viewer.getDocument() ? 1 : 0) != 0);
        this.document = document;
        this.lastLineStart = -1;
        this.endOfRange = offset + length;
        this.currentOffset = offset;
        this.tokenStart = -1;
        this.hyperlinkToken = new Token((Object)new TextAttribute(color, null, 0x40000000));
        this.hyperlinkDetectors = this.getHyperlinkDetectors();
    }

    protected IToken scanToken() {
        return null;
    }

    @NonNull
    private Set<IHyperlinkDetector> getHyperlinkDetectors() {
        LinkedHashSet<IHyperlinkDetector> allDetectors = new LinkedHashSet<IHyperlinkDetector>();
        IHyperlinkDetector[] configuredDetectors = this.configuration.getHyperlinkDetectors(this.viewer);
        if (configuredDetectors != null && configuredDetectors.length > 0) {
            allDetectors.addAll(Arrays.asList(configuredDetectors));
            if (this.preferenceStore.getBoolean(URL_HYPERLINK_DETECTOR_KEY) || !this.preferenceStore.getBoolean("hyperlinksEnabled")) {
                return allDetectors;
            }
            allDetectors.add((IHyperlinkDetector)new MultiURLHyperlinkDetector());
        }
        return allDetectors;
    }

    private static class MultiURLHyperlinkDetector
    extends URLHyperlinkDetector {
        private MultiURLHyperlinkDetector() {
        }

        public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            if (region.getLength() == 0) {
                return super.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
            }
            try {
                int currentOffset;
                String line = textViewer.getDocument().get(region.getOffset(), region.getLength());
                int lineStart = currentOffset = region.getOffset();
                int regionEnd = currentOffset + region.getLength();
                ArrayList allLinks = new ArrayList();
                while (currentOffset < regionEnd) {
                    int nextCandidatePos;
                    IHyperlink[] newLinks = super.detectHyperlinks(textViewer, (IRegion)new Region(currentOffset, 0), canShowMultipleHyperlinks);
                    ++currentOffset;
                    if (newLinks != null && newLinks.length > 0) {
                        Collections.addAll(allLinks, newLinks);
                        IHyperlink[] iHyperlinkArray = newLinks;
                        int n = newLinks.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IHyperlink link = iHyperlinkArray[n2];
                            int end = link.getHyperlinkRegion().getOffset() + link.getHyperlinkRegion().getLength();
                            if (end > currentOffset) {
                                currentOffset = end;
                            }
                            ++n2;
                        }
                    }
                    if ((nextCandidatePos = lineStart + line.indexOf("://", currentOffset - lineStart)) > currentOffset) {
                        currentOffset = nextCandidatePos;
                        continue;
                    }
                    if (nextCandidatePos < currentOffset) break;
                }
                return allLinks.toArray(new IHyperlink[0]);
            }
            catch (BadLocationException e) {
                return null;
            }
        }
    }
}

