/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.nested;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.ee8.nested.AbstractHandlerContainer;
import org.eclipse.jetty.ee8.nested.Handler;
import org.eclipse.jetty.ee8.nested.Request;
import org.eclipse.jetty.server.Server;

public class HotSwapHandler
extends AbstractHandlerContainer {
    private volatile Handler _handler;

    public Handler getHandler() {
        return this._handler;
    }

    @Override
    public Handler[] getHandlers() {
        Handler handler = this._handler;
        if (handler == null) {
            return new Handler[0];
        }
        return new Handler[]{handler};
    }

    public void setHandler(Handler handler) {
        try {
            Server server = this.getServer();
            if (handler == this._handler) {
                return;
            }
            Handler oldHandler = this._handler;
            if (handler != null) {
                handler.setServer(server);
                this.addBean(handler, true);
                if (oldHandler != null && oldHandler.isStarted()) {
                    handler.start();
                }
            }
            this._handler = handler;
            if (oldHandler != null) {
                this.removeBean(oldHandler);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Handler handler = this._handler;
        if (handler != null && this.isStarted() && handler.isStarted()) {
            handler.handle(target, baseRequest, request, response);
        }
    }

    @Override
    protected void expandChildren(List<Handler> list, Class<?> byClass) {
        Handler handler = this._handler;
        if (handler != null) {
            this.expandHandler(handler, list, byClass);
        }
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler child = this.getHandler();
        if (child != null) {
            this.setHandler(null);
            child.destroy();
        }
        super.destroy();
    }
}

