/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.graph;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LGraphElement;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPadding;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.core.math.KVector;

public final class LGraph
extends LGraphElement
implements Iterable<Layer> {
    private static final long serialVersionUID = -8006835373897072852L;
    private final KVector size = new KVector();
    private final LPadding padding = new LPadding();
    private final KVector offset = new KVector();
    private final List<LNode> layerlessNodes = Lists.newArrayList();
    private final List<Layer> layers = Lists.newArrayList();
    private LNode parentNode;

    public KVector getSize() {
        return this.size;
    }

    public KVector getActualSize() {
        return new KVector(this.size.x + this.padding.left + this.padding.right, this.size.y + this.padding.top + this.padding.bottom);
    }

    public LPadding getPadding() {
        return this.padding;
    }

    public KVector getOffset() {
        return this.offset;
    }

    public List<LNode> getLayerlessNodes() {
        return this.layerlessNodes;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public LNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(LNode parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public Iterator<Layer> iterator() {
        return this.layers.iterator();
    }

    public LNode[][] toNodeArray() {
        LNode[][] lgraphArray = new LNode[this.layers.size()][];
        ListIterator<Layer> layerIter = this.layers.listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            int layerIndex = layerIter.previousIndex();
            lgraphArray[layerIndex] = LGraphUtil.toNodeArray(layer.getNodes());
        }
        return lgraphArray;
    }

    public String toString() {
        if (this.layers.isEmpty()) {
            return "G-unlayered" + this.layerlessNodes.toString();
        }
        if (this.layerlessNodes.isEmpty()) {
            return "G-layered" + this.layers.toString();
        }
        return "G[layerless" + this.layerlessNodes.toString() + ", layers" + this.layers.toString() + "]";
    }
}

