/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.eclipse.elk.alg.mrtree.TreeLayoutPhases;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.alg.AlgorithmAssembler;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class MrTree {
    private AlgorithmAssembler<TreeLayoutPhases, TGraph> algorithmAssembler = AlgorithmAssembler.create(TreeLayoutPhases.class);
    private List<ILayoutProcessor<TGraph>> algorithm;

    public TGraph doLayout(TGraph tgraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Tree layout", 1.0f);
        if (((Boolean)tgraph.getProperty(MrTreeOptions.DEBUG_MODE)).booleanValue()) {
            progressMonitor.log((Object)("MrTree! called at " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"))));
        }
        this.updateModules(tgraph);
        this.layout(tgraph, progressMonitor.subTask(1.0f));
        progressMonitor.done();
        return tgraph;
    }

    private void updateModules(TGraph graph) {
        this.algorithmAssembler.reset();
        this.algorithmAssembler.setPhase((Enum)TreeLayoutPhases.P1_TREEIFICATION, (ILayoutPhaseFactory)TreeLayoutPhases.P1_TREEIFICATION);
        this.algorithmAssembler.setPhase((Enum)TreeLayoutPhases.P2_NODE_ORDERING, (ILayoutPhaseFactory)TreeLayoutPhases.P2_NODE_ORDERING);
        this.algorithmAssembler.setPhase((Enum)TreeLayoutPhases.P3_NODE_PLACEMENT, (ILayoutPhaseFactory)TreeLayoutPhases.P3_NODE_PLACEMENT);
        this.algorithmAssembler.setPhase((Enum)TreeLayoutPhases.P4_EDGE_ROUTING, (ILayoutPhaseFactory)TreeLayoutPhases.P4_EDGE_ROUTING);
        this.algorithm = this.algorithmAssembler.build((Object)graph);
    }

    private void layout(TGraph graph, IElkProgressMonitor themonitor) {
        IElkProgressMonitor monitor = themonitor;
        if (monitor == null) {
            monitor = new BasicProgressMonitor();
        }
        monitor.begin("Layout", (float)this.algorithm.size());
        if (((Boolean)graph.getProperty(MrTreeOptions.DEBUG_MODE)).booleanValue()) {
            themonitor.log((Object)("ELK MrTree uses the following " + this.algorithm.size() + " modules:"));
            int i = 0;
            while (i < this.algorithm.size()) {
                themonitor.log((Object)("   Slot " + i + ": " + this.algorithm.get(i).getClass().getName()));
                ++i;
            }
        }
        for (ILayoutProcessor<TGraph> processor : this.algorithm) {
            if (monitor.isCanceled()) {
                return;
            }
            processor.process((Object)graph, monitor.subTask(1.0f));
        }
        monitor.done();
    }
}

