/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editparts.ConfigurableMoveFBEditPart;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.gef.widgets.TypeSelectionWidget;
import org.eclipse.fordiac.ide.model.commands.change.ConfigureFBCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableMoveFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.ui.nat.DataTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.DataTypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ConfigurableMoveFBSection
extends AbstractSection
implements CommandStackEventListener {
    protected TypeSelectionWidget typeSelectionWidget;
    protected CLabel configurableFbLabel;

    protected FBNetworkElement getInputType(Object input) {
        if (input instanceof ConfigurableMoveFBEditPart) {
            ConfigurableMoveFBEditPart ep = (ConfigurableMoveFBEditPart)((Object)input);
            return ep.getModel();
        }
        if (input instanceof ConfigurableMoveFB) {
            ConfigurableMoveFB fb = (ConfigurableMoveFB)input;
            return fb;
        }
        return null;
    }

    protected ConfigurableMoveFB getType() {
        Object object = this.type;
        if (object instanceof ConfigurableMoveFB) {
            ConfigurableMoveFB fb = (ConfigurableMoveFB)object;
            return fb;
        }
        return null;
    }

    private void createDataTypeSelector(Composite composite) {
        Composite structComp = this.getWidgetFactory().createComposite(composite);
        structComp.setLayout((Layout)new GridLayout(2, false));
        structComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.configurableFbLabel = this.getWidgetFactory().createCLabel(structComp, Messages.ConfigurableMoveFBSection_DataType);
        this.typeSelectionWidget = new TypeSelectionWidget(this.getWidgetFactory(), this::handleSelectionChanged);
        this.typeSelectionWidget.createControls(structComp);
        this.typeSelectionWidget.setEditable(true);
    }

    protected void handleSelectionChanged(String newTypeName) {
        if (this.getType() != null && this.newDataTypeSelected(newTypeName)) {
            DataType newDtp = this.getDataTypeLib().getTypeIfExists(newTypeName);
            ConfigureFBCommand cmd = new ConfigureFBCommand((ConfigurableFB)this.getType(), newDtp);
            this.executeCommand((Command)cmd);
            ConfigurableMoveFBSection.updateFB((FB)cmd.getNewElement());
        }
    }

    public boolean newDataTypeSelected(String newDtpName) {
        return !newDtpName.equalsIgnoreCase(PackageNameHelper.getFullTypeName((LibraryElement)this.getType().getDataType())) && this.getDataTypeLib().getTypeIfExists(newDtpName) != null;
    }

    protected static void updateFB(FB newFb) {
        EditorPart activeEditor = (EditorPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        GraphicalViewer viewer = (GraphicalViewer)activeEditor.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            viewer.flush();
            EditorUtils.refreshPropertySheetWithSelection((IEditorPart)activeEditor, (EditPartViewer)viewer, (Object)viewer.getEditPartForModel((Object)newFb));
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createDataTypeSelector(parent);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (this.getCurrentCommandStack() != null) {
            this.getCurrentCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        }
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.setCurrentCommandStack(part, input);
        if (this.getCurrentCommandStack() == null) {
            this.configurableFbLabel.setEnabled(false);
        }
        this.setType(input);
        this.typeSelectionWidget.initialize((ConfigurableObject)this.getType(), (ITypeSelectionContentProvider)DataTypeSelectionContentProvider.INSTANCE, (ITreeContentProvider)DataTypeSelectionTreeContentProvider.INSTANCE);
        if (this.getCurrentCommandStack() != null) {
            this.getCurrentCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.getCurrentCommandStack() != null) {
            this.getCurrentCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        }
    }

    public void stackChanged(CommandStackEvent event) {
        Display.getDefault().asyncExec(() -> {
            ConfigureFBCommand cmd;
            Command command;
            if (!(event.getDetail() != 32 && event.getDetail() != 16 || !((command = event.getCommand()) instanceof ConfigureFBCommand) || (cmd = (ConfigureFBCommand)command).getOldElement() != this.getType() && cmd.getNewElement() != this.getType())) {
                if (event.getDetail() == 32) {
                    ConfigurableMoveFBSection.updateFB((FB)cmd.getOldElement());
                } else if (event.getDetail() == 16) {
                    ConfigurableMoveFBSection.updateFB((FB)cmd.getNewElement());
                }
            }
        });
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
    }

    protected void performRefresh() {
    }
}

