/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging.watch;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.IDeploymentDebugTarget;
import org.eclipse.fordiac.ide.deployment.debug.watch.AbstractContainerWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.AdapterDeclarationWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.BlockFBNetworkElementValue;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.deployment.debug.watch.EventWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.SubAppEventWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.SubAppVarDeclarationWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.VarDeclarationWatch;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class WatchFactoryReplay {
    public static IWatch watchFor(String name, INamedElement element, DeploymentDebugDevice debugTarget) throws EvaluatorException, UnsupportedOperationException {
        IWatchWithPublicError iWatchWithPublicError;
        INamedElement iNamedElement;
        INamedElement iNamedElement2 = element;
        Objects.requireNonNull(iNamedElement2);
        INamedElement iNamedElement3 = iNamedElement = iNamedElement2;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Event.class, Event.class, VarDeclaration.class, VarDeclaration.class, AdapterDeclaration.class, BlockFBNetworkElement.class}, (Object)iNamedElement3, n)) {
                case 0: {
                    Event event = (Event)iNamedElement;
                    if (!DeploymentDebugWatchUtils.isSubAppInterfaceElement((IInterfaceElement)event)) {
                        iNamedElement3 = iNamedElement;
                        n = 1;
                        continue block8;
                    }
                    iWatchWithPublicError = new SubAppEventWatchReplay(name, event, debugTarget);
                    break block8;
                }
                case 1: {
                    Event event = (Event)iNamedElement;
                    iWatchWithPublicError = new EventWatchReplay(name, event, debugTarget);
                    break block8;
                }
                case 2: {
                    VarDeclaration varDeclaration = (VarDeclaration)iNamedElement;
                    if (!DeploymentDebugWatchUtils.isSubAppInterfaceElement((IInterfaceElement)varDeclaration)) {
                        iNamedElement3 = iNamedElement;
                        n = 3;
                        continue block8;
                    }
                    iWatchWithPublicError = new SubAppVarDeclarationWatchReplay(name, varDeclaration, debugTarget);
                    break block8;
                }
                case 3: {
                    VarDeclaration varDeclaration = (VarDeclaration)iNamedElement;
                    iWatchWithPublicError = new VarDeclarationWatchReplay(name, varDeclaration, debugTarget);
                    break block8;
                }
                case 4: {
                    AdapterDeclaration adapterDeclaration = (AdapterDeclaration)iNamedElement;
                    iWatchWithPublicError = new AdapterDeclarationWatch(name, adapterDeclaration, debugTarget);
                    break block8;
                }
                case 5: {
                    BlockFBNetworkElement networkElement = (BlockFBNetworkElement)iNamedElement;
                    iWatchWithPublicError = new FBNetworkElementWatchReplay(name, networkElement, debugTarget);
                    break block8;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported element: " + element.eClass().getName());
                }
            }
            break;
        }
        return iWatchWithPublicError;
    }

    static IWatch watchFor(String name, INamedElement element, Resource resource, String resourceRelativeName, DeploymentDebugDevice debugTarget) throws EvaluatorException, UnsupportedOperationException {
        IWatchWithPublicError iWatchWithPublicError;
        INamedElement iNamedElement;
        INamedElement iNamedElement2 = element;
        Objects.requireNonNull(iNamedElement2);
        INamedElement iNamedElement3 = iNamedElement = iNamedElement2;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IInterfaceElement.class, Event.class, VarDeclaration.class, AdapterDeclaration.class, BlockFBNetworkElement.class}, (Object)iNamedElement3, n)) {
                case 0: {
                    IInterfaceElement interfaceElement = (IInterfaceElement)iNamedElement;
                    if (!DeploymentDebugWatchUtils.isSubAppInterfaceElement((IInterfaceElement)interfaceElement)) {
                        iNamedElement3 = iNamedElement;
                        n = 1;
                        continue block7;
                    }
                    throw new UnsupportedOperationException("Unsupported element: " + element.eClass().getName());
                }
                case 1: {
                    Event event = (Event)iNamedElement;
                    iWatchWithPublicError = new EventWatchReplay(name, event, resource, resourceRelativeName, debugTarget);
                    break block7;
                }
                case 2: {
                    VarDeclaration varDeclaration = (VarDeclaration)iNamedElement;
                    iWatchWithPublicError = new VarDeclarationWatchReplay(name, varDeclaration, resource, resourceRelativeName, debugTarget);
                    break block7;
                }
                case 3: {
                    AdapterDeclaration adapterDeclaration = (AdapterDeclaration)iNamedElement;
                    iWatchWithPublicError = new AdapterDeclarationWatch(name, adapterDeclaration, resource, resourceRelativeName, debugTarget);
                    break block7;
                }
                case 4: {
                    BlockFBNetworkElement networkElement = (BlockFBNetworkElement)iNamedElement;
                    iWatchWithPublicError = new FBNetworkElementWatchReplay(name, networkElement, resource, resourceRelativeName, debugTarget);
                    break block7;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported element: " + element.eClass().getName());
                }
            }
            break;
        }
        return iWatchWithPublicError;
    }

    private static class EventWatchReplay
    extends EventWatch
    implements IWatchWithPublicError {
        public EventWatchReplay(String name, Event event, DeploymentDebugDevice debugTarget) {
            super(name, event, debugTarget);
        }

        public EventWatchReplay(String name, Event event, Resource resource, String resourceRelativeName, DeploymentDebugDevice debugTarget) {
            super(name, event, resource, resourceRelativeName, debugTarget);
        }

        @Override
        public void setError(String message) {
            super.setError(message);
        }

        @Override
        public void clearError() {
            super.clearError();
        }
    }

    public static class FBNetworkElementValueReplay
    extends BlockFBNetworkElementValue
    implements IValue {
        private static final String QUALIFIED_NAME_DELIMITER = ".";
        private final Resource resource;
        private final String resourceRelativeName;
        private final List<IWatch> watches;

        public FBNetworkElementValueReplay(BlockFBNetworkElement element, DeploymentDebugDevice target) {
            this(element, element.getResource(), DeploymentDebugWatchUtils.getResourceRelativeName((INamedElement)element, (Resource)element.getResource()), target);
        }

        public FBNetworkElementValueReplay(BlockFBNetworkElement element, Resource resource, String resourceRelativeName, DeploymentDebugDevice target) {
            super(element, resource, resourceRelativeName, target);
            this.resource = resource;
            this.resourceRelativeName = resourceRelativeName;
            this.watches = this.getSubElementsReplay().map(this::createSubWatchReplay).toList();
        }

        private Stream<INamedElement> getSubElementsReplay() throws UnsupportedOperationException {
            return Stream.concat(this.getInterfaceSubElementsReplay(), this.getAdditionalSubElementsReplay()).sorted(Comparator.comparing(INamedElement::getName));
        }

        private Stream<INamedElement> getInterfaceSubElementsReplay() throws UnsupportedOperationException {
            InterfaceList interfaceList = this.getElement().getInterface();
            return Stream.of(interfaceList.getEventInputs(), interfaceList.getEventOutputs(), interfaceList.getInputVars(), interfaceList.getOutputVars(), interfaceList.getInOutVars(), interfaceList.getSockets(), interfaceList.getPlugs()).flatMap(Collection::stream);
        }

        private Stream<? extends INamedElement> getAdditionalSubElementsReplay() throws UnsupportedOperationException {
            Stream<Object> stream;
            BlockFBNetworkElement blockFBNetworkElement;
            BlockFBNetworkElement blockFBNetworkElement2 = this.getElement();
            Objects.requireNonNull(blockFBNetworkElement2);
            BlockFBNetworkElement blockFBNetworkElement3 = blockFBNetworkElement = blockFBNetworkElement2;
            int n = 0;
            block6: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FB.class, Group.class, SubApp.class, CFBInstance.class}, (Object)blockFBNetworkElement3, n)) {
                    case 0: {
                        FB fb = (FB)blockFBNetworkElement;
                        FBType fBType = fb.getType();
                        if (!(fBType instanceof BaseFBType)) {
                            blockFBNetworkElement3 = blockFBNetworkElement;
                            n = 1;
                            continue block6;
                        }
                        BaseFBType baseFBType = (BaseFBType)fBType;
                        stream = Stream.concat(baseFBType.getInternalVars().stream(), baseFBType.getInternalFbs().stream());
                        break block6;
                    }
                    case 1: {
                        Group group = (Group)blockFBNetworkElement;
                        stream = group.getGroupElements().stream();
                        break block6;
                    }
                    case 2: {
                        SubApp subapp = (SubApp)blockFBNetworkElement;
                        stream = subapp.loadSubAppNetwork().getNetworkElements().stream();
                        break block6;
                    }
                    case 3: {
                        CFBInstance cfbInstance = (CFBInstance)blockFBNetworkElement;
                        stream = cfbInstance.loadCFBNetwork().getNetworkElements().stream().filter(Predicate.not(AdapterFB.class::isInstance));
                        break block6;
                    }
                    default: {
                        stream = Stream.empty();
                    }
                }
                break;
            }
            return stream;
        }

        private IWatch createSubWatchReplay(INamedElement element) throws EvaluatorException, UnsupportedOperationException {
            if (EcoreUtil.getRootContainer((EObject)element) instanceof FBType) {
                return WatchFactoryReplay.watchFor(element.getName(), element, this.resource, this.resourceRelativeName + QUALIFIED_NAME_DELIMITER + element.getName(), this.getDebugTarget());
            }
            return WatchFactoryReplay.watchFor(element.getName(), element, this.getDebugTarget());
        }

        public List<IWatch> getWatches() {
            return this.watches;
        }

        public String getReferenceTypeName() throws DebugException {
            return this.getElement().getTypeName();
        }

        public String getValueString() throws DebugException {
            return "";
        }

        public boolean isAllocated() throws DebugException {
            return true;
        }

        public IVariable[] getVariables() throws DebugException {
            return (IVariable[])this.watches.toArray(IVariable[]::new);
        }

        public boolean hasVariables() throws DebugException {
            return !this.watches.isEmpty();
        }
    }

    public static class FBNetworkElementWatchReplay
    extends AbstractContainerWatch
    implements IWatchWithPublicError {
        final FBNetworkElementValueReplay value;

        public FBNetworkElementWatchReplay(String name, BlockFBNetworkElement element, DeploymentDebugDevice target) {
            super(name, (ITypedElement)element, (IDeploymentDebugTarget)target);
            this.value = new FBNetworkElementValueReplay(element, target);
        }

        public FBNetworkElementWatchReplay(String name, BlockFBNetworkElement element, Resource resource, String resourceRelativeName, DeploymentDebugDevice target) {
            super(name, (ITypedElement)element, (IDeploymentDebugTarget)target);
            this.value = new FBNetworkElementValueReplay(element, resource, resourceRelativeName, target);
        }

        public BlockFBNetworkElementValue getValue() {
            return this.value;
        }

        public List<IWatch> getSubWatches() {
            return this.value.getWatches();
        }

        public FBNetworkElement getWatchedElement() {
            return (FBNetworkElement)super.getWatchedElement();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == FBNetworkElement.class) {
                return adapter.cast(this.getWatchedElement());
            }
            return (T)super.getAdapter(adapter);
        }

        @Override
        public void setError(String message) {
        }

        @Override
        public void clearError() {
        }
    }

    public static interface IWatchWithPublicError {
        public void setError(String var1);

        public void clearError();
    }

    private static class SubAppEventWatchReplay
    extends SubAppEventWatch
    implements IWatchWithPublicError {
        public SubAppEventWatchReplay(String name, Event event, DeploymentDebugDevice debugTarget) {
            super(name, event, debugTarget);
        }

        @Override
        public void setError(String message) {
            super.setError(message);
        }

        @Override
        public void clearError() {
            super.clearError();
        }
    }

    private static class SubAppVarDeclarationWatchReplay
    extends SubAppVarDeclarationWatch
    implements IWatchWithPublicError {
        public SubAppVarDeclarationWatchReplay(String name, VarDeclaration varDeclaration, DeploymentDebugDevice debugTarget) {
            super(name, varDeclaration, debugTarget);
        }

        @Override
        public void setError(String message) {
            super.setError(message);
        }

        @Override
        public void clearError() {
            super.clearError();
        }
    }

    private static class VarDeclarationWatchReplay
    extends VarDeclarationWatch
    implements IWatchWithPublicError {
        public VarDeclarationWatchReplay(String name, VarDeclaration varDeclaration, DeploymentDebugDevice debugTarget) {
            super(name, varDeclaration, debugTarget);
        }

        public VarDeclarationWatchReplay(String name, VarDeclaration varDeclaration, Resource resource, String resourceRelativeName, DeploymentDebugDevice debugTarget) {
            super(name, varDeclaration, resource, resourceRelativeName, debugTarget);
        }

        @Override
        public void setError(String message) {
            super.setError(message);
        }

        @Override
        public void clearError() {
            super.clearError();
        }
    }
}

