/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.types;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.search.AbstractLiveSearchContext;
import org.eclipse.fordiac.ide.model.search.ISearchContext;
import org.eclipse.fordiac.ide.model.search.types.IEC61499ElementSearch;
import org.eclipse.fordiac.ide.model.search.types.ISearchChildrenProvider;
import org.eclipse.fordiac.ide.model.search.types.LibraryElementSearchContext;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

public class BlockTypeInstanceSearch
extends IEC61499ElementSearch {
    public BlockTypeInstanceSearch(TypeEntry entry) {
        super(BlockTypeInstanceSearch.createSearchContext(entry), searchCanditate -> {
            TypedConfigureableObject tco;
            return searchCanditate instanceof TypedConfigureableObject && entry == (tco = (TypedConfigureableObject)searchCanditate).getTypeEntry();
        }, BlockTypeInstanceSearch.createChildrenProvider());
    }

    public BlockTypeInstanceSearch(Collection<TypeEntry> entries) {
        super(BlockTypeInstanceSearch.createSearchContext(entries.iterator().next()), searchCanditate -> {
            TypedConfigureableObject tco;
            return searchCanditate instanceof TypedConfigureableObject && entries.contains((tco = (TypedConfigureableObject)searchCanditate).getTypeEntry());
        }, BlockTypeInstanceSearch.createChildrenProvider());
    }

    public BlockTypeInstanceSearch(LibraryElement typeEditable, TypeEntry entry) {
        super(new LibraryElementSearchContext(typeEditable), searchCanditate -> {
            TypedConfigureableObject tco;
            return searchCanditate instanceof TypedConfigureableObject && entry == (tco = (TypedConfigureableObject)searchCanditate).getTypeEntry();
        }, BlockTypeInstanceSearch.createChildrenProvider());
    }

    private static ISearchContext createSearchContext(TypeEntry entry) {
        return new AbstractLiveSearchContext(entry.getFile().getProject()){

            @Override
            public Stream<URI> getTypes() {
                Stream systems = this.getTypelib().getSystems().stream();
                Stream fbs = this.getTypelib().getFbTypes().stream();
                Stream subApps = this.getTypelib().getSubAppTypes().stream();
                return Stream.concat(systems, Stream.concat(fbs, subApps)).map(TypeEntry::getURI).filter(Objects::nonNull);
            }
        };
    }

    private static ISearchChildrenProvider createChildrenProvider() {
        return new ISearchChildrenProvider(){

            @Override
            public boolean hasChildren(EObject obj) {
                return obj instanceof AutomationSystem || obj instanceof FBType || obj instanceof UntypedSubApp;
            }

            @Override
            public Stream<? extends EObject> getChildren(EObject obj) {
                if (obj instanceof AutomationSystem) {
                    AutomationSystem system = (AutomationSystem)obj;
                    return system.getApplication().stream().flatMap(app -> app.getFBNetwork().getNetworkElements().stream());
                }
                if (obj instanceof FBType) {
                    if (obj instanceof BaseFBType) {
                        BaseFBType baseFBType = (BaseFBType)obj;
                        return baseFBType.getInternalFbs().stream();
                    }
                    if (obj instanceof CompositeFBType) {
                        CompositeFBType cfbType = (CompositeFBType)obj;
                        return cfbType.getFBNetwork().getNetworkElements().stream();
                    }
                    if (obj instanceof SubAppType) {
                        SubAppType subAppType = (SubAppType)obj;
                        return subAppType.getFBNetwork().getNetworkElements().stream();
                    }
                }
                if (obj instanceof UntypedSubApp) {
                    UntypedSubApp utSubApp = (UntypedSubApp)obj;
                    return utSubApp.getSubAppNetwork().getNetworkElements().stream();
                }
                return Stream.empty();
            }
        };
    }
}

