/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.view.editparts;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.debug.preferences.FordiacDebugPreferences;
import org.eclipse.fordiac.ide.debug.ui.DebugColorProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public abstract class AbstractDebugInterfaceValueEditPart
extends AbstractGraphicalEditPart {
    private static final int DEBUG_VALUE_MIN_WIDTH = 50;
    private InterfaceEditPart referencedInterface;

    protected AbstractDebugInterfaceValueEditPart() {
    }

    public void activate() {
        super.activate();
        EditPart editPart = this.getViewer().getEditPartForModel((Object)this.getInterfaceElement());
        if (editPart instanceof InterfaceEditPart) {
            InterfaceEditPart iep;
            this.referencedInterface = iep = (InterfaceEditPart)editPart;
            this.referencedInterface.getFigure().addAncestorListener(new AncestorListener(){

                public void ancestorRemoved(IFigure ancestor) {
                }

                public void ancestorMoved(IFigure ancestor) {
                    AbstractDebugInterfaceValueEditPart.this.refreshVisuals();
                }

                public void ancestorAdded(IFigure ancestor) {
                    AbstractDebugInterfaceValueEditPart.this.refreshVisuals();
                }
            });
        }
        this.refreshPosition();
    }

    protected abstract IInterfaceElement getInterfaceElement();

    public boolean isInput() {
        return this.getInterfaceElement().isIsInput();
    }

    protected IFigure createFigure() {
        Label l = new Label(){

            protected String getTruncationString() {
                return "\u2026";
            }
        };
        l.setSize(100, -1);
        l.setOpaque(true);
        l.setBackgroundColor(DebugColorProvider.getWatchColor());
        l.setForegroundColor(DebugColorProvider.getWatchTextColor());
        l.setPreferredSize(150, 20);
        LineBorder lb = new LineBorder(){

            public Insets getInsets(IFigure figure) {
                return new Insets(1, 2, 1, 2);
            }
        };
        l.setBorder((Border)lb);
        return l;
    }

    public Label getLabelFigure() {
        return (Label)super.getFigure();
    }

    protected void createEditPolicies() {
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshPosition();
    }

    protected void refreshPosition() {
        if (this.referencedInterface != null) {
            Rectangle bounds = this.referencedInterface.getFigure().getBounds();
            int width = this.getFigureWidth();
            Rectangle newBounds = new Rectangle(0, bounds.y - bounds.height / 2, width, -1);
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)newBounds);
        }
    }

    private int getFigureWidth() {
        return Math.clamp((long)this.getFigure().getPreferredSize().width, 50, AbstractDebugInterfaceValueEditPart.getMaxWidth());
    }

    private static int getMaxWidth() {
        return FordiacDebugPreferences.getDebugViewValueMaxDisplayLength() * (int)CoordinateConverter.INSTANCE.getAverageCharacterWidth();
    }
}

