/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.OriginalSource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class GlobalConstantsExporter
extends AbstractTypeExporter {
    public GlobalConstantsExporter(GlobalConstants type) {
        super(type);
    }

    @Override
    public GlobalConstants getType() {
        return (GlobalConstants)super.getType();
    }

    @Override
    protected String getRootTag() {
        return "GlobalConstants";
    }

    @Override
    protected void createTypeSpecificXMLEntries() throws XMLStreamException {
        this.addCompilerInfo(this.getType().getCompilerInfo());
        this.addGlobalConstants((Iterable<? extends VarDeclaration>)this.getType().getConstants());
        if (this.getType().getSource() != null) {
            this.addOriginalSource(this.getType().getSource());
        }
        this.addAttributes((EList<Attribute>)this.getType().getAttributes());
    }

    private void addGlobalConstants(Iterable<? extends VarDeclaration> vars) throws XMLStreamException {
        this.addStartElement("GlobalConstants");
        for (VarDeclaration varDeclaration : vars) {
            this.addVarDeclaration(varDeclaration);
        }
        this.addEndElement();
    }

    private void addOriginalSource(OriginalSource source) throws XMLStreamException {
        this.addStartElement("OriginalSource");
        this.writeOriginalSourceText(source.getText());
        this.addInlineEndElement();
    }

    private void writeOriginalSourceText(String text) throws XMLStreamException {
        if (text != null) {
            this.writeCDataSection(text);
        } else {
            this.getWriter().writeCharacters("");
        }
    }
}

