/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editors;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.fbtypeeditor.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeXtextMessageOutline;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeXtextNavigationLocation;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.xtext.ui.editor.XtextEditor;

public abstract class FBTypeXtextEditor
extends XtextEditor
implements IFBTEditorPart {
    @Inject
    private AbstractUIPlugin languageUIPlugin;
    private boolean restoringSelection;
    private boolean performanceMode;
    private boolean performanceModeShowDialog;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.checkPerformanceMode();
        this.installFBTypeUpdater();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        this.removeFBTypeUpdater();
        super.doSetInput(input);
    }

    public void dispose() {
        this.removeFBTypeUpdater();
        super.dispose();
    }

    public void reveal(int offset, int length) {
        this.revealEditor();
        super.reveal(offset, length);
    }

    protected void selectAndReveal(int selectionStart, int selectionLength, int revealStart, int revealLength) {
        if (!this.restoringSelection) {
            this.revealEditor();
        }
        super.selectAndReveal(selectionStart, selectionLength, revealStart, revealLength);
    }

    protected void revealEditor() {
        MultiPageEditorSite multiPageEditorSite;
        MultiPageEditorPart multiPageEditor;
        IEditorSite iEditorSite = this.getEditorSite();
        if (iEditorSite instanceof MultiPageEditorSite && (multiPageEditor = (multiPageEditorSite = (MultiPageEditorSite)iEditorSite).getMultiPageEditor()).getSelectedPage() != this) {
            multiPageEditor.setActiveEditor((IEditorPart)this);
        }
    }

    protected void restoreSelection() {
        this.restoringSelection = true;
        try {
            super.restoreSelection();
        }
        finally {
            this.restoringSelection = false;
        }
    }

    public CommandStack getCommandStack() {
        IEditorSite iEditorSite = this.getEditorSite();
        if (iEditorSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iEditorSite;
            return (CommandStack)multiPageEditorSite.getMultiPageEditor().getAdapter(CommandStack.class);
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == CommandStack.class) {
            return adapter.cast(this.getCommandStack());
        }
        if (adapter == IContentOutlinePage.class && this.performanceMode) {
            return adapter.cast((Object)new FBTypeXtextMessageOutline(Messages.FBTypeXtextEditor_PerformanceModeOutlineMessage));
        }
        return (T)super.getAdapter(adapter);
    }

    public void setFocus() {
        if (this.performanceModeShowDialog) {
            this.performanceModeShowDialog = false;
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.FBTypeXtextEditor_PerformanceModeDialogTitle, (String)Messages.FBTypeXtextEditor_PerformanceModeDialogMessage);
        }
        super.setFocus();
    }

    protected void checkPerformanceMode() {
        if (this.performanceMode) {
            return;
        }
        if (this.shouldEnablePerformanceMode()) {
            this.enablePerformanceMode();
        }
    }

    protected boolean shouldEnablePerformanceMode() {
        return false;
    }

    protected void enablePerformanceMode() {
        this.performanceMode = true;
        this.performanceModeShowDialog = true;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer instanceof ProjectionViewer) {
            ProjectionViewer projectionViewer = (ProjectionViewer)iSourceViewer;
            projectionViewer.disableProjection();
        }
        this.uninstallFoldingSupport();
        this.invokeUninstallHighlightingHelper();
        ISourceViewer iSourceViewer2 = this.getSourceViewer();
        if (iSourceViewer2 instanceof SourceViewer) {
            SourceViewer sourceViewer = (SourceViewer)iSourceViewer2;
            sourceViewer.setCodeMiningProviders(null);
        }
    }

    protected void invokeUninstallHighlightingHelper() {
        try {
            Method method = XtextEditor.class.getDeclaredMethod("uninstallHighlightingHelper", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            FordiacLogHelper.logError((String)"Cannot invoke uninstallHighlightingHelper() in XtextEditor", (Throwable)e);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        return false;
    }

    public void setCommonCommandStack(CommandStack commandStack) {
    }

    public boolean isMarkerTarget(IMarker marker) {
        try {
            return marker.getType().startsWith(this.languageUIPlugin.getBundle().getSymbolicName() + "." + this.getLanguageShortName().toLowerCase());
        }
        catch (CoreException e) {
            return false;
        }
    }

    protected String getLanguageShortName() {
        String languageName = this.getLanguageName();
        return languageName.substring(languageName.lastIndexOf(46) + 1);
    }

    public void reloadType() {
        this.doRevertToSaved();
    }

    protected void handleEditorInputChanged() {
    }

    protected boolean isPrefQuickDiffAlwaysOn() {
        return false;
    }

    public Object getSelectableObject() {
        return null;
    }

    protected void markInNavigationHistory() {
        IEditorSite iEditorSite = this.getEditorSite();
        if (iEditorSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iEditorSite;
            this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)multiPageEditorSite.getMultiPageEditor());
        } else {
            super.markInNavigationHistory();
        }
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new FBTypeXtextNavigationLocation(this, false);
    }

    public INavigationLocation createNavigationLocation() {
        return new FBTypeXtextNavigationLocation(this, true);
    }

    protected abstract void removeFBTypeUpdater();

    protected abstract void installFBTypeUpdater();

    protected abstract boolean selectAndReveal(Object var1, boolean var2);
}

