/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.util;

import java.text.MessageFormat;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.deployment.Messages;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public interface DeploymentHelper {
    public static final String MGR_ID = "MGR_ID";

    public static String getVariableValue(VarDeclaration varDecl) throws DeploymentException {
        if (DeploymentHelper.hasInitalValue(varDecl)) {
            try {
                return VariableOperations.newVariable((VarDeclaration)varDecl).toString(false);
            }
            catch (Exception e) {
                if (DeploymentHelper.forceDeployement()) {
                    return varDecl.getValue().getValue();
                }
                throw new DeploymentException(MessageFormat.format(Messages.DeploymentHelper_VariableValueError, varDecl.getValue().getValue(), varDecl.getQualifiedName(), e.getMessage()), e);
            }
        }
        return null;
    }

    public static Function<VarDeclaration, String> getVariableValueRetargetable(VarDeclaration varDecl, SubApp subapp) throws DeploymentException {
        if (DeploymentHelper.hasTypeOrInstanceInitialValue(subapp, varDecl)) {
            try {
                Value value = VariableOperations.newVariable((VarDeclaration)varDecl).getValue();
                return destination -> VariableOperations.newVariable((VarDeclaration)destination, (Value)value).toString(false);
            }
            catch (Exception e) {
                if (DeploymentHelper.forceDeployement()) {
                    return unused -> varDecl.getValue().getValue();
                }
                throw new DeploymentException(MessageFormat.format(Messages.DeploymentHelper_VariableValueError, varDecl.getValue().getValue(), varDecl.getQualifiedName(), e.getMessage()), e);
            }
        }
        return null;
    }

    public static boolean hasTypeInitialValue(SubApp subApp, VarDeclaration varDec) {
        Optional<VarDeclaration> dec;
        if (subApp.isTyped() && (dec = subApp.getType().getInterfaceList().getInputVars().stream().filter(v -> v.getName().contentEquals(varDec.getName())).findAny()).isPresent()) {
            return DeploymentHelper.hasInitalValue(dec.get());
        }
        return false;
    }

    public static boolean hasTypeOrInstanceInitialValue(SubApp subApp, VarDeclaration varDec) {
        return DeploymentHelper.hasInitalValue(varDec) || DeploymentHelper.hasTypeInitialValue(subApp, varDec);
    }

    private static boolean hasInitalValue(VarDeclaration varDecl) {
        return varDecl.getValue() != null && varDecl.getValue().getValue() != null && !varDecl.getValue().getValue().isEmpty();
    }

    public static String getMgrID(Device dev) throws DeploymentException {
        for (VarDeclaration varDecl : dev.getVarDeclarations()) {
            String val;
            if (!MGR_ID.equalsIgnoreCase(varDecl.getName()) || (val = DeploymentHelper.getVariableValue(varDecl)) == null) continue;
            return val;
        }
        return "";
    }

    public static String getMgrIDSafe(Device dev) {
        try {
            return DeploymentHelper.getMgrID(dev);
        }
        catch (DeploymentException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)e);
            return "";
        }
    }

    public static boolean forceDeployement() {
        if (ForceDeploymentHelper.forceDeployment == null) {
            String[] args;
            ForceDeploymentHelper.forceDeployment = Boolean.FALSE;
            String[] stringArray = args = Platform.getCommandLineArgs();
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if ("-forceDeployment".equals(arg)) {
                    ForceDeploymentHelper.forceDeployment = Boolean.TRUE;
                    break;
                }
                ++n2;
            }
        }
        return ForceDeploymentHelper.forceDeployment;
    }

    public static class ForceDeploymentHelper {
        private static Boolean forceDeployment = null;

        private ForceDeploymentHelper() {
        }
    }
}

