/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.export.forte_ng.ForteLibraryElementTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.datatype.helper.RetainHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public abstract class ForteFBTemplate<T extends FBType>
extends ForteLibraryElementTemplate<T> {
    private final String DEFAULT_BASE_CLASS;

    public ForteFBTemplate(T type, String name, Path prefix, String baseClass, Map<?, ?> options) {
        super(type, name, prefix, options);
        this.DEFAULT_BASE_CLASS = baseClass;
    }

    protected String baseClass() {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        FBType _type = (FBType)this.getType();
        CompilerInfo _compilerInfo = null;
        if (_type != null) {
            _compilerInfo = _type.getCompilerInfo();
        }
        String _classdef = null;
        if (_compilerInfo != null) {
            _classdef = _compilerInfo.getClassdef();
        }
        boolean bl = _tripleNotEquals = _classdef != null;
        if (_tripleNotEquals) {
            String _xifexpression_1 = null;
            boolean _isEmpty = ((FBType)this.getType()).getCompilerInfo().getClassdef().trim().isEmpty();
            _xifexpression_1 = _isEmpty ? this.DEFAULT_BASE_CLASS : ((FBType)this.getType()).getCompilerInfo().getClassdef();
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = this.DEFAULT_BASE_CLASS;
        }
        return _xifexpression;
    }

    protected CharSequence generateFBClassHeader() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("class ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append(" final : public ");
        String _baseClass = this.baseClass();
        _builder.append(_baseClass);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateHeaderIncludes() {
        StringConcatenation _builder = new StringConcatenation();
        Pair _mappedTo = Pair.of((Object)"header", (Object)Boolean.TRUE);
        CharSequence _generateDependencyIncludes = this.generateDependencyIncludes(this.getDependencies(Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo}))));
        _builder.append((Object)_generateDependencyIncludes);
        _builder.newLineIfNotEmpty();
        CompilerInfo _compilerInfo = ((FBType)this.getType()).getCompilerInfo();
        String _header = null;
        if (_compilerInfo != null) {
            _header = _compilerInfo.getHeader();
        }
        _builder.append(_header);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateImplIncludes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"");
        String _fileBasename = this.getFileBasename();
        _builder.append(_fileBasename);
        _builder.append(".h\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef FORTE_ENABLE_GENERATED_SOURCE_CPP");
        _builder.newLine();
        _builder.append("#include \"");
        String _generateTypeGenIncludePath = ForteNgExportUtil.generateTypeGenIncludePath(this.getType());
        _builder.append(_generateTypeGenIncludePath);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateDependencyIncludes = this.generateDependencyIncludes(this.getDependencies(CollectionLiterals.emptyMap()));
        _builder.append((Object)_generateDependencyIncludes);
        _builder.newLineIfNotEmpty();
        CompilerInfo _compilerInfo = ((FBType)this.getType()).getCompilerInfo();
        String _header = null;
        if (_compilerInfo != null) {
            _header = _compilerInfo.getHeader();
        }
        _builder.append(_header);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateFBDeclaration() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("DECLARE_FIRMWARE_FB(");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateFBDefinition() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("DEFINE_FIRMWARE_FB(");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append(", ");
        CharSequence _generateTypeSpec = ForteNgExportUtil.generateTypeSpec(this.getType());
        _builder.append((Object)_generateTypeSpec);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateFBInterfaceDeclaration() {
        boolean _isEmpty_2;
        boolean _not_2;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = ((FBType)this.getType()).getInterfaceList().getInputVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("static const CStringDictionary::TStringId scmDataInputNames[];");
            _builder.newLine();
            _builder.append("static const CStringDictionary::TStringId scmDataInputTypeIds[];");
            _builder.newLine();
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = ((FBType)this.getType()).getInterfaceList().getOutputVars().isEmpty());
        if (_not_1) {
            _builder.append("static const CStringDictionary::TStringId scmDataOutputNames[];");
            _builder.newLine();
            _builder.append("static const CStringDictionary::TStringId scmDataOutputTypeIds[];");
            _builder.newLine();
        }
        boolean bl3 = _not_2 = !(_isEmpty_2 = ((FBType)this.getType()).getInterfaceList().getInOutVars().isEmpty());
        if (_not_2) {
            _builder.append("static const CStringDictionary::TStringId scmDataInOutNames[];");
            _builder.newLine();
            _builder.append("static const CStringDictionary::TStringId scmDataInOutTypeIds[];");
            _builder.newLine();
        }
        CharSequence _generateFBEventInputInterfaceDecl = this.generateFBEventInputInterfaceDecl();
        _builder.append((Object)_generateFBEventInputInterfaceDecl);
        _builder.newLineIfNotEmpty();
        CharSequence _generateFBEventOutputInterfaceDecl = this.generateFBEventOutputInterfaceDecl();
        _builder.append((Object)_generateFBEventOutputInterfaceDecl);
        _builder.newLineIfNotEmpty();
        if (!((FBType)this.getType()).getInterfaceList().getSockets().isEmpty() || !((FBType)this.getType()).getInterfaceList().getPlugs().isEmpty()) {
            EList _sockets = ((FBType)this.getType()).getInterfaceList().getSockets();
            for (AdapterDeclaration adapter : _sockets) {
                _builder.append("static const int scm");
                String _name = adapter.getName();
                _builder.append(_name);
                _builder.append("AdpNum = ");
                int _indexOf = ((FBType)this.getType()).getInterfaceList().getSockets().indexOf((Object)adapter);
                _builder.append((Object)_indexOf);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            EList _plugs = ((FBType)this.getType()).getInterfaceList().getPlugs();
            for (AdapterDeclaration adapter_1 : _plugs) {
                _builder.append("static const int scm");
                String _name_1 = adapter_1.getName();
                _builder.append(_name_1);
                _builder.append("AdpNum = ");
                int _size = ((FBType)this.getType()).getInterfaceList().getSockets().size();
                int _indexOf_1 = ((FBType)this.getType()).getInterfaceList().getPlugs().indexOf((Object)adapter_1);
                int _plus = _size + _indexOf_1;
                _builder.append((Object)_plus);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("static const SAdapterInstanceDef scmAdapterInstances[];");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateFBEventOutputInterfaceDecl() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = ((FBType)this.getType()).getInterfaceList().getEventOutputs().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _not_1;
            _builder.newLineIfNotEmpty();
            CharSequence _generateEventConstants = this.generateEventConstants((List<Event>)((FBType)this.getType()).getInterfaceList().getEventOutputs());
            _builder.append((Object)_generateEventConstants);
            _builder.newLineIfNotEmpty();
            boolean _hasOutputWith = this.hasOutputWith();
            if (_hasOutputWith) {
                _builder.append("static const TDataIOID scmEOWith[];");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("static const TForteInt16 scmEOWithIndexes[];");
            _builder.newLine();
            _builder.append("static const CStringDictionary::TStringId scmEventOutputNames[];");
            _builder.newLine();
            boolean _containsOnlyBasicEventType = this.containsOnlyBasicEventType((EList<Event>)((FBType)this.getType()).getInterfaceList().getEventOutputs());
            boolean bl2 = _not_1 = !_containsOnlyBasicEventType;
            if (_not_1) {
                _builder.append("static const CStringDictionary::TStringId scmEventOutputTypeIds[]; ");
                _builder.newLine();
            }
            _builder.append("\t\t");
        }
        return _builder;
    }

    protected CharSequence generateFBEventInputInterfaceDecl() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = ((FBType)this.getType()).getInterfaceList().getEventInputs().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _not_1;
            _builder.newLineIfNotEmpty();
            CharSequence _generateEventConstants = this.generateEventConstants((List<Event>)((FBType)this.getType()).getInterfaceList().getEventInputs());
            _builder.append((Object)_generateEventConstants);
            _builder.newLineIfNotEmpty();
            boolean _hasInputWith = this.hasInputWith();
            if (_hasInputWith) {
                _builder.append("static const TDataIOID scmEIWith[];");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("static const TForteInt16 scmEIWithIndexes[];");
            _builder.newLine();
            _builder.append("static const CStringDictionary::TStringId scmEventInputNames[];");
            _builder.newLine();
            boolean _containsOnlyBasicEventType = this.containsOnlyBasicEventType((EList<Event>)((FBType)this.getType()).getInterfaceList().getEventInputs());
            boolean bl2 = _not_1 = !_containsOnlyBasicEventType;
            if (_not_1) {
                _builder.append("static const CStringDictionary::TStringId scmEventInputTypeIds[]; ");
                _builder.newLine();
            }
            _builder.append("\t\t");
        }
        return _builder;
    }

    protected CharSequence generateEventConstants(List<Event> events) {
        StringConcatenation _builder = new StringConcatenation();
        for (Event event : events) {
            _builder.newLineIfNotEmpty();
            _builder.append("static const TEventID ");
            CharSequence _generateEventID = this.generateEventID(event);
            _builder.append((Object)_generateEventID);
            _builder.append(" = ");
            int _indexOf = events.indexOf(event);
            _builder.append((Object)_indexOf);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
        }
        return _builder;
    }

    protected CharSequence generateEventID(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("scmEvent");
        String _name = event.getName();
        _builder.append(_name);
        _builder.append("ID");
        return _builder;
    }

    protected CharSequence generateFBInterfaceDefinition() {
        boolean _isEmpty_5;
        boolean _not_6;
        boolean _isEmpty_3;
        boolean _not_3;
        boolean _isEmpty_2;
        boolean _not_2;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _xblockexpression = null;
        ArrayList inputWith = CollectionLiterals.newArrayList();
        ArrayList inputWithIndexes = CollectionLiterals.newArrayList();
        Consumer<Event> _function = event -> {
            Functions.Function1 _function_1 = it -> {
                boolean _isInOutVar = it.getVariables().isInOutVar();
                return !_isInOutVar;
            };
            Iterable associatedInputs = IterableExtensions.filter((Iterable)event.getWith(), (Functions.Function1)_function_1);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)associatedInputs);
            if (_isEmpty) {
                inputWithIndexes.add(-1);
            } else {
                inputWithIndexes.add(inputWith.size());
                Consumer<With> _function_2 = it -> inputWith.add(((FBType)this.getType()).getInterfaceList().getInputVars().indexOf((Object)it.getVariables()));
                associatedInputs.forEach(_function_2);
                inputWith.add("scmWithListDelimiter");
            }
        };
        ((FBType)this.getType()).getInterfaceList().getEventInputs().forEach(_function);
        ArrayList outputWith = CollectionLiterals.newArrayList();
        ArrayList outputWithIndexes = CollectionLiterals.newArrayList();
        Consumer<Event> _function_1 = event -> {
            Functions.Function1 _function_2 = it -> {
                boolean _isInOutVar = it.getVariables().isInOutVar();
                return !_isInOutVar;
            };
            Iterable associatedOutputs = IterableExtensions.filter((Iterable)event.getWith(), (Functions.Function1)_function_2);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)associatedOutputs);
            if (_isEmpty) {
                outputWithIndexes.add(-1);
            } else {
                outputWithIndexes.add(outputWith.size());
                Consumer<With> _function_3 = it -> outputWith.add(((FBType)this.getType()).getInterfaceList().getOutputVars().indexOf((Object)it.getVariables()));
                associatedOutputs.forEach(_function_3);
                outputWith.add("scmWithListDelimiter");
            }
        };
        ((FBType)this.getType()).getInterfaceList().getEventOutputs().forEach(_function_1);
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = ((FBType)this.getType()).getInterfaceList().getInputVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName = this.getFBClassName();
            _builder.append((Object)_fBClassName);
            _builder.append("::scmDataInputNames[] = {");
            String _fORTENameList = this.getFORTENameList((List<INamedElement>)((FBType)this.getType()).getInterfaceList().getInputVars());
            _builder.append(_fORTENameList);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_1 = this.getFBClassName();
            _builder.append((Object)_fBClassName_1);
            _builder.append("::scmDataInputTypeIds[] = {");
            String _fORTETypeList = this.getFORTETypeList((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getInputVars());
            _builder.append(_fORTETypeList);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = ((FBType)this.getType()).getInterfaceList().getOutputVars().isEmpty());
        if (_not_1) {
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_2 = this.getFBClassName();
            _builder.append((Object)_fBClassName_2);
            _builder.append("::scmDataOutputNames[] = {");
            String _fORTENameList_1 = this.getFORTENameList((List<INamedElement>)((FBType)this.getType()).getInterfaceList().getOutputVars());
            _builder.append(_fORTENameList_1);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_3 = this.getFBClassName();
            _builder.append((Object)_fBClassName_3);
            _builder.append("::scmDataOutputTypeIds[] = {");
            String _fORTETypeList_1 = this.getFORTETypeList((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getOutputVars());
            _builder.append(_fORTETypeList_1);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
        }
        boolean bl3 = _not_2 = !(_isEmpty_2 = ((FBType)this.getType()).getInterfaceList().getInOutVars().isEmpty());
        if (_not_2) {
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_4 = this.getFBClassName();
            _builder.append((Object)_fBClassName_4);
            _builder.append("::scmDataInOutNames[] = {");
            String _fORTENameList_2 = this.getFORTENameList((List<INamedElement>)((FBType)this.getType()).getInterfaceList().getInOutVars());
            _builder.append(_fORTENameList_2);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_5 = this.getFBClassName();
            _builder.append((Object)_fBClassName_5);
            _builder.append("::scmDataInOutTypeIds[] = {");
            String _fORTETypeList_2 = this.getFORTETypeList((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getInOutVars());
            _builder.append(_fORTETypeList_2);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
        }
        boolean bl4 = _not_3 = !(_isEmpty_3 = ((FBType)this.getType()).getInterfaceList().getEventInputs().isEmpty());
        if (_not_3) {
            boolean _not_5;
            boolean _not_4;
            boolean _isEmpty_4 = inputWith.isEmpty();
            boolean bl5 = _not_4 = !_isEmpty_4;
            if (_not_4) {
                _builder.append("const TDataIOID ");
                CharSequence _fBClassName_6 = this.getFBClassName();
                _builder.append((Object)_fBClassName_6);
                _builder.append("::scmEIWith[] = {");
                String _join = IterableExtensions.join((Iterable)inputWith, (CharSequence)", ");
                _builder.append(_join);
                _builder.append("};");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("const TForteInt16 ");
            CharSequence _fBClassName_7 = this.getFBClassName();
            _builder.append((Object)_fBClassName_7);
            _builder.append("::scmEIWithIndexes[] = {");
            String _join_1 = IterableExtensions.join((Iterable)inputWithIndexes, (CharSequence)", ");
            _builder.append(_join_1);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_8 = this.getFBClassName();
            _builder.append((Object)_fBClassName_8);
            _builder.append("::scmEventInputNames[] = {");
            String _fORTENameList_3 = this.getFORTENameList((List<INamedElement>)((FBType)this.getType()).getInterfaceList().getEventInputs());
            _builder.append(_fORTENameList_3);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            boolean _containsOnlyBasicEventType = this.containsOnlyBasicEventType((EList<Event>)((FBType)this.getType()).getInterfaceList().getEventInputs());
            boolean bl6 = _not_5 = !_containsOnlyBasicEventType;
            if (_not_5) {
                _builder.append("const CStringDictionary::TStringId ");
                CharSequence _fBClassName_9 = this.getFBClassName();
                _builder.append((Object)_fBClassName_9);
                _builder.append("::scmEventInputTypeIds[] = {");
                String _fORTEEventTypeList = this.getFORTEEventTypeList((List<Event>)((FBType)this.getType()).getInterfaceList().getEventInputs());
                _builder.append(_fORTEEventTypeList);
                _builder.append("};");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl7 = _not_6 = !(_isEmpty_5 = ((FBType)this.getType()).getInterfaceList().getEventOutputs().isEmpty());
        if (_not_6) {
            boolean _not_8;
            boolean _not_7;
            boolean _isEmpty_6 = outputWith.isEmpty();
            boolean bl8 = _not_7 = !_isEmpty_6;
            if (_not_7) {
                _builder.append("const TDataIOID ");
                CharSequence _fBClassName_10 = this.getFBClassName();
                _builder.append((Object)_fBClassName_10);
                _builder.append("::scmEOWith[] = {");
                String _join_2 = IterableExtensions.join((Iterable)outputWith, (CharSequence)", ");
                _builder.append(_join_2);
                _builder.append("};");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("const TForteInt16 ");
            CharSequence _fBClassName_11 = this.getFBClassName();
            _builder.append((Object)_fBClassName_11);
            _builder.append("::scmEOWithIndexes[] = {");
            String _join_3 = IterableExtensions.join((Iterable)outputWithIndexes, (CharSequence)", ");
            _builder.append(_join_3);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_12 = this.getFBClassName();
            _builder.append((Object)_fBClassName_12);
            _builder.append("::scmEventOutputNames[] = {");
            String _fORTENameList_4 = this.getFORTENameList((List<INamedElement>)((FBType)this.getType()).getInterfaceList().getEventOutputs());
            _builder.append(_fORTENameList_4);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            boolean _containsOnlyBasicEventType_1 = this.containsOnlyBasicEventType((EList<Event>)((FBType)this.getType()).getInterfaceList().getEventOutputs());
            boolean bl9 = _not_8 = !_containsOnlyBasicEventType_1;
            if (_not_8) {
                _builder.append("const CStringDictionary::TStringId ");
                CharSequence _fBClassName_13 = this.getFBClassName();
                _builder.append((Object)_fBClassName_13);
                _builder.append("::scmEventOutputTypeIds[] = {");
                String _fORTEEventTypeList_1 = this.getFORTEEventTypeList((List<Event>)((FBType)this.getType()).getInterfaceList().getEventOutputs());
                _builder.append(_fORTEEventTypeList_1);
                _builder.append("};");
                _builder.newLineIfNotEmpty();
            }
        }
        if (!((FBType)this.getType()).getInterfaceList().getSockets().isEmpty() || !((FBType)this.getType()).getInterfaceList().getPlugs().isEmpty()) {
            _builder.append("const SAdapterInstanceDef ");
            CharSequence _fBClassName_14 = this.getFBClassName();
            _builder.append((Object)_fBClassName_14);
            _builder.append("::scmAdapterInstances[] = {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            EList _sockets = ((FBType)this.getType()).getInterfaceList().getSockets();
            EList _plugs = ((FBType)this.getType()).getInterfaceList().getPlugs();
            Iterable _plus = Iterables.concat((Iterable)_sockets, (Iterable)_plugs);
            boolean _hasElements = false;
            for (AdapterDeclaration adapter : _plus) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",\n", "  ");
                }
                _builder.append("{");
                CharSequence _fORTEStringId = ForteNgExportUtil.getFORTEStringId(adapter.getTypeName());
                _builder.append((Object)_fORTEStringId, "  ");
                _builder.append(", ");
                CharSequence _fORTEStringId_1 = ForteNgExportUtil.getFORTEStringId(adapter.getName());
                _builder.append((Object)_fORTEStringId_1, "  ");
                _builder.append(", ");
                boolean _isIsInput = adapter.isIsInput();
                boolean _not_9 = !_isIsInput;
                _builder.append((Object)_not_9, "  ");
                _builder.append("}");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("};");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateFBInterfaceSpecDeclaration() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("static const SFBInterfaceSpec scmFBInterfaceSpec;");
        _builder.newLine();
        return _builder;
    }

    protected boolean hasInputWith() {
        Functions.Function1 _function = it -> it.getWith();
        Functions.Function1 _function_1 = it -> {
            boolean _isInOutVar = it.getVariables().isInOutVar();
            return !_isInOutVar;
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap((Iterable)((FBType)this.getType()).getInterfaceList().getEventInputs(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        return !_isEmpty;
    }

    protected boolean hasOutputWith() {
        Functions.Function1 _function = it -> it.getWith();
        Functions.Function1 _function_1 = it -> {
            boolean _isInOutVar = it.getVariables().isInOutVar();
            return !_isInOutVar;
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap((Iterable)((FBType)this.getType()).getInterfaceList().getEventOutputs(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        return !_isEmpty;
    }

    public boolean containsOnlyBasicEventType(EList<Event> events) {
        Functions.Function1 _function = it -> {
            boolean _contentEquals = it.getTypeName().contentEquals("Event");
            return !_contentEquals;
        };
        Event _findFirst = (Event)IterableExtensions.findFirst(events, (Functions.Function1)_function);
        return _findFirst == null;
    }

    protected CharSequence generateFBInterfaceSpecDefinition() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const SFBInterfaceSpec ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::scmFBInterfaceSpec = {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size = ((FBType)this.getType()).getInterfaceList().getEventInputs().size();
        _builder.append((Object)_size, "  ");
        _builder.append(", ");
        boolean _isEmpty = ((FBType)this.getType()).getInterfaceList().getEventInputs().isEmpty();
        if (_isEmpty) {
            _builder.append("nullptr, nullptr, nullptr, nullptr");
        } else {
            _builder.append("scmEventInputNames, ");
            boolean _containsOnlyBasicEventType = this.containsOnlyBasicEventType((EList<Event>)((FBType)this.getType()).getInterfaceList().getEventInputs());
            if (_containsOnlyBasicEventType) {
                _builder.append("nullptr");
            } else {
                _builder.append("scmEventInputTypeIds");
            }
            _builder.append(", ");
            boolean _hasInputWith = this.hasInputWith();
            if (_hasInputWith) {
                _builder.append("scmEIWith");
            } else {
                _builder.append("nullptr");
            }
            _builder.append(", scmEIWithIndexes");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size_1 = ((FBType)this.getType()).getInterfaceList().getEventOutputs().size();
        _builder.append((Object)_size_1, "  ");
        _builder.append(", ");
        boolean _isEmpty_1 = ((FBType)this.getType()).getInterfaceList().getEventOutputs().isEmpty();
        if (_isEmpty_1) {
            _builder.append("nullptr, nullptr, nullptr, nullptr");
        } else {
            _builder.append("scmEventOutputNames, ");
            boolean _containsOnlyBasicEventType_1 = this.containsOnlyBasicEventType((EList<Event>)((FBType)this.getType()).getInterfaceList().getEventOutputs());
            if (_containsOnlyBasicEventType_1) {
                _builder.append("nullptr");
            } else {
                _builder.append("scmEventOutputTypeIds");
            }
            _builder.append(", ");
            boolean _hasOutputWith = this.hasOutputWith();
            if (_hasOutputWith) {
                _builder.append("scmEOWith");
            } else {
                _builder.append("nullptr");
            }
            _builder.append(", scmEOWithIndexes");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size_2 = ((FBType)this.getType()).getInterfaceList().getInputVars().size();
        _builder.append((Object)_size_2, "  ");
        _builder.append(", ");
        boolean _isEmpty_2 = ((FBType)this.getType()).getInterfaceList().getInputVars().isEmpty();
        if (_isEmpty_2) {
            _builder.append("nullptr, nullptr");
        } else {
            _builder.append("scmDataInputNames, scmDataInputTypeIds");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size_3 = ((FBType)this.getType()).getInterfaceList().getOutputVars().size();
        _builder.append((Object)_size_3, "  ");
        _builder.append(", ");
        boolean _isEmpty_3 = ((FBType)this.getType()).getInterfaceList().getOutputVars().isEmpty();
        if (_isEmpty_3) {
            _builder.append("nullptr, nullptr");
        } else {
            _builder.append("scmDataOutputNames, scmDataOutputTypeIds");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size_4 = ((FBType)this.getType()).getInterfaceList().getInOutVars().size();
        _builder.append((Object)_size_4, "  ");
        _builder.append(", ");
        boolean _isEmpty_4 = ((FBType)this.getType()).getInterfaceList().getInOutVars().isEmpty();
        if (_isEmpty_4) {
            _builder.append("nullptr");
        } else {
            _builder.append("scmDataInOutNames");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size_5 = ((FBType)this.getType()).getInterfaceList().getPlugs().size();
        int _size_6 = ((FBType)this.getType()).getInterfaceList().getSockets().size();
        int _plus = _size_5 + _size_6;
        _builder.append((Object)_plus, "  ");
        _builder.append(", ");
        if (!((FBType)this.getType()).getInterfaceList().getSockets().isEmpty() || !((FBType)this.getType()).getInterfaceList().getPlugs().isEmpty()) {
            _builder.append("scmAdapterInstances");
        } else {
            _builder.append("nullptr");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateInternalVarDeclaration(BaseFBType baseFBType) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = baseFBType.getInternalVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("static const CStringDictionary::TStringId scmInternalsNames[];");
            _builder.newLine();
            _builder.append("static const CStringDictionary::TStringId scmInternalsTypeIds[];");
            _builder.newLine();
            _builder.append("static const SInternalVarsInformation scmInternalVars;");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateInternalVarDefinition(BaseFBType baseFBType) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = baseFBType.getInternalVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName = this.getFBClassName();
            _builder.append((Object)_fBClassName);
            _builder.append("::scmInternalsNames[] = {");
            String _fORTENameList = this.getFORTENameList((List<INamedElement>)baseFBType.getInternalVars());
            _builder.append(_fORTENameList);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_1 = this.getFBClassName();
            _builder.append((Object)_fBClassName_1);
            _builder.append("::scmInternalsTypeIds[] = {");
            String _fORTETypeList = this.getFORTETypeList((List<VarDeclaration>)baseFBType.getInternalVars());
            _builder.append(_fORTETypeList);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.append("const SInternalVarsInformation ");
            CharSequence _fBClassName_2 = this.getFBClassName();
            _builder.append((Object)_fBClassName_2);
            _builder.append("::scmInternalVars = {");
            int _size = baseFBType.getInternalVars().size();
            _builder.append((Object)_size);
            _builder.append(", scmInternalsNames, scmInternalsTypeIds};");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateReadInputDataDeclaration() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void readInputData(TEventID paEIID) override;");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateReadInputDataDefinition() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::readInputData(");
        Functions.Function1 _function = it -> {
            boolean _isEmpty = it.getWith().isEmpty();
            return !_isEmpty;
        };
        boolean _exists = IterableExtensions.exists((Iterable)((FBType)this.getType()).getInterfaceList().getEventInputs(), (Functions.Function1)_function);
        if (_exists) {
            _builder.append("const TEventID paEIID");
        } else {
            _builder.append("TEventID");
        }
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateReadInputDataBody = this.generateReadInputDataBody((List<Event>)((FBType)this.getType()).getInterfaceList().getEventInputs());
        _builder.append((Object)_generateReadInputDataBody, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateReadInputDataBody(List<Event> events) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            boolean _isEmpty = it.getWith().isEmpty();
            return !_isEmpty;
        };
        boolean _exists = IterableExtensions.exists(events, (Functions.Function1)_function);
        if (_exists) {
            _builder.append("switch(paEIID) {");
            _builder.newLine();
            Functions.Function1 _function_1 = it -> {
                boolean _isEmpty = it.getWith().isEmpty();
                return !_isEmpty;
            };
            Iterable _filter = IterableExtensions.filter(events, (Functions.Function1)_function_1);
            for (Event event : _filter) {
                _builder.append("  ");
                _builder.append("case ");
                CharSequence _generateEventID = this.generateEventID(event);
                _builder.append((Object)_generateEventID, "  ");
                _builder.append(": {");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function_2 = it -> this.getWithVariable((With)it);
                List _map = ListExtensions.map((List)event.getWith(), (Functions.Function1)_function_2);
                for (VarDeclaration variable : _map) {
                    _builder.append("  ");
                    _builder.append("  ");
                    _builder.append("readData(");
                    int _interfaceElementIndex = ForteNgExportUtil.getInterfaceElementIndex((IInterfaceElement)variable);
                    _builder.append((Object)_interfaceElementIndex, "    ");
                    _builder.append(", ");
                    CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
                    _builder.append((Object)_generateName, "    ");
                    _builder.append(", ");
                    boolean _isInOutVar = variable.isInOutVar();
                    if (_isInOutVar) {
                        _builder.append("&");
                    }
                    CharSequence _generateNameAsConnection = this.generateNameAsConnection(variable);
                    _builder.append((Object)_generateNameAsConnection, "    ");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("break;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("  ");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("// nothing to do");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateWriteOutputDataDeclaration() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void writeOutputData(TEventID paEIID) override;");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateWriteOutputDataDefinition() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::writeOutputData(");
        Functions.Function1 _function = it -> {
            boolean _isEmpty = it.getWith().isEmpty();
            return !_isEmpty;
        };
        boolean _exists = IterableExtensions.exists((Iterable)((FBType)this.getType()).getInterfaceList().getEventOutputs(), (Functions.Function1)_function);
        if (_exists) {
            _builder.append("const TEventID paEIID");
        } else {
            _builder.append("TEventID");
        }
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateWriteOutputDataBody = this.generateWriteOutputDataBody((List<Event>)((FBType)this.getType()).getInterfaceList().getEventOutputs());
        _builder.append((Object)_generateWriteOutputDataBody, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateWriteOutputDataBody(List<Event> events) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            boolean _isEmpty = it.getWith().isEmpty();
            return !_isEmpty;
        };
        boolean _exists = IterableExtensions.exists(events, (Functions.Function1)_function);
        if (_exists) {
            _builder.append("switch(paEIID) {");
            _builder.newLine();
            Functions.Function1 _function_1 = it -> {
                boolean _isEmpty = it.getWith().isEmpty();
                return !_isEmpty;
            };
            Iterable _filter = IterableExtensions.filter(events, (Functions.Function1)_function_1);
            for (Event event : _filter) {
                _builder.append("  ");
                _builder.append("case ");
                CharSequence _generateEventID = this.generateEventID(event);
                _builder.append((Object)_generateEventID, "  ");
                _builder.append(": {");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function_2 = it -> this.getWithVariable((With)it);
                List _map = ListExtensions.map((List)event.getWith(), (Functions.Function1)_function_2);
                for (VarDeclaration variable : _map) {
                    _builder.append("  ");
                    _builder.append("  ");
                    _builder.append("writeData(");
                    int _interfaceElementIndex = ForteNgExportUtil.getInterfaceElementIndex((IInterfaceElement)variable);
                    _builder.append((Object)_interfaceElementIndex, "    ");
                    _builder.append(", ");
                    CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
                    _builder.append((Object)_generateName, "    ");
                    _builder.append(", ");
                    CharSequence _generateNameAsConnection = this.generateNameAsConnection(variable);
                    _builder.append((Object)_generateNameAsConnection, "    ");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("break;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("  ");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("// nothing to do");
            _builder.newLine();
        }
        return _builder;
    }

    protected VarDeclaration getWithVariable(With with) {
        VarDeclaration _xblockexpression = null;
        VarDeclaration varDeclaration = with.getVariables();
        VarDeclaration _xifexpression = null;
        _xifexpression = varDeclaration.isInOutVar() && varDeclaration.isIsInput() ? varDeclaration.getInOutVarOpposite() : varDeclaration;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected CharSequence generateInterfaceDeclarations() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateInterfaceVariableAndConnectionDeclarations = this.generateInterfaceVariableAndConnectionDeclarations();
        _builder.append((Object)_generateInterfaceVariableAndConnectionDeclarations);
        _builder.newLineIfNotEmpty();
        CharSequence _generateAccessorDeclarations = this.generateAccessorDeclarations();
        _builder.append((Object)_generateAccessorDeclarations);
        _builder.newLineIfNotEmpty();
        CharSequence _generateEventAccessorDefinitions = this.generateEventAccessorDefinitions();
        _builder.append((Object)_generateEventAccessorDefinitions);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateAccessorDeclarations() {
        boolean _isEmpty_2;
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateAccessorDeclaration = this.generateAccessorDeclaration("getDI", false);
        _builder.append((Object)_generateAccessorDeclaration);
        _builder.newLineIfNotEmpty();
        CharSequence _generateAccessorDeclaration_1 = this.generateAccessorDeclaration("getDO", false);
        _builder.append((Object)_generateAccessorDeclaration_1);
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = ((FBType)this.getType()).getInterfaceList().getInOutVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            CharSequence _generateAccessorDeclaration_2 = this.generateAccessorDeclaration("getDIO", false);
            _builder.append((Object)_generateAccessorDeclaration_2);
            _builder.newLineIfNotEmpty();
        }
        if (!((FBType)this.getType()).getInterfaceList().getSockets().isEmpty() || !((FBType)this.getType()).getInterfaceList().getPlugs().isEmpty()) {
            CharSequence _generateAccessorDeclaration_3 = this.generateAccessorDeclaration("getAdapterUnchecked", "CAdapter *", false);
            _builder.append((Object)_generateAccessorDeclaration_3);
            _builder.newLineIfNotEmpty();
        }
        CharSequence _generateConnectionAccessorsDeclaration = this.generateConnectionAccessorsDeclaration("getEOConUnchecked", "CEventConnection *");
        _builder.append((Object)_generateConnectionAccessorsDeclaration);
        _builder.newLineIfNotEmpty();
        CharSequence _generateConnectionAccessorsDeclaration_1 = this.generateConnectionAccessorsDeclaration("getDIConUnchecked", "CDataConnection **");
        _builder.append((Object)_generateConnectionAccessorsDeclaration_1);
        _builder.newLineIfNotEmpty();
        CharSequence _generateConnectionAccessorsDeclaration_2 = this.generateConnectionAccessorsDeclaration("getDOConUnchecked", "CDataConnection *");
        _builder.append((Object)_generateConnectionAccessorsDeclaration_2);
        _builder.newLineIfNotEmpty();
        boolean _isEmpty_1 = ((FBType)this.getType()).getInterfaceList().getInOutVars().isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            CharSequence _generateConnectionAccessorsDeclaration_3 = this.generateConnectionAccessorsDeclaration("getDIOInConUnchecked", "CInOutDataConnection **");
            _builder.append((Object)_generateConnectionAccessorsDeclaration_3);
            _builder.newLineIfNotEmpty();
        }
        boolean bl3 = _not_2 = !(_isEmpty_2 = ((FBType)this.getType()).getInterfaceList().getInOutVars().isEmpty());
        if (_not_2) {
            CharSequence _generateConnectionAccessorsDeclaration_4 = this.generateConnectionAccessorsDeclaration("getDIOOutConUnchecked", "CInOutDataConnection *");
            _builder.append((Object)_generateConnectionAccessorsDeclaration_4);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateInterfaceVariableAndConnectionDeclarations() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateVariableDeclarations = this.generateVariableDeclarations((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getInputVars(), false);
        _builder.append((Object)_generateVariableDeclarations);
        _builder.newLineIfNotEmpty();
        CharSequence _generateVariableDeclarations_1 = this.generateVariableDeclarations((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getOutputVars(), false);
        _builder.append((Object)_generateVariableDeclarations_1);
        _builder.newLineIfNotEmpty();
        CharSequence _generateVariableDeclarations_2 = this.generateVariableDeclarations((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getInOutVars(), false);
        _builder.append((Object)_generateVariableDeclarations_2);
        _builder.newLineIfNotEmpty();
        CharSequence _generateAdapterDeclarations = this.generateAdapterDeclarations((List<AdapterDeclaration>)((FBType)this.getType()).getInterfaceList().getSockets());
        _builder.append((Object)_generateAdapterDeclarations);
        _builder.newLineIfNotEmpty();
        CharSequence _generateAdapterDeclarations_1 = this.generateAdapterDeclarations((List<AdapterDeclaration>)((FBType)this.getType()).getInterfaceList().getPlugs());
        _builder.append((Object)_generateAdapterDeclarations_1);
        _builder.newLineIfNotEmpty();
        CharSequence _generateConnectionVariableDeclarations = this.generateConnectionVariableDeclarations((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getOutputVars());
        _builder.append((Object)_generateConnectionVariableDeclarations);
        _builder.newLineIfNotEmpty();
        CharSequence _generateConnectionVariableDeclarations_1 = this.generateConnectionVariableDeclarations((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getOutMappedInOutVars());
        _builder.append((Object)_generateConnectionVariableDeclarations_1);
        _builder.newLineIfNotEmpty();
        CharSequence _generateEventConnectionDeclarations = this.generateEventConnectionDeclarations((List<Event>)((FBType)this.getType()).getInterfaceList().getEventOutputs());
        _builder.append((Object)_generateEventConnectionDeclarations);
        _builder.newLineIfNotEmpty();
        CharSequence _generateDataConnectionDeclarations = this.generateDataConnectionDeclarations((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getInputVars(), true);
        _builder.append((Object)_generateDataConnectionDeclarations);
        _builder.newLineIfNotEmpty();
        CharSequence _generateDataConnectionDeclarations_1 = this.generateDataConnectionDeclarations((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getOutputVars(), false);
        _builder.append((Object)_generateDataConnectionDeclarations_1);
        _builder.newLineIfNotEmpty();
        CharSequence _generateDataConnectionDeclarations_2 = this.generateDataConnectionDeclarations((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getInOutVars(), true);
        _builder.append((Object)_generateDataConnectionDeclarations_2);
        _builder.newLineIfNotEmpty();
        CharSequence _generateDataConnectionDeclarations_3 = this.generateDataConnectionDeclarations((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getOutMappedInOutVars(), false);
        _builder.append((Object)_generateDataConnectionDeclarations_3);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateInterfaceDefinitions() {
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateReadInputDataDefinition = this.generateReadInputDataDefinition();
        _builder.append((Object)_generateReadInputDataDefinition);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateWriteOutputDataDefinition = this.generateWriteOutputDataDefinition();
        _builder.append((Object)_generateWriteOutputDataDefinition);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateAccessorDefinition = this.generateAccessorDefinition((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getInputVars(), "getDI", false);
        _builder.append((Object)_generateAccessorDefinition);
        _builder.newLineIfNotEmpty();
        CharSequence _generateAccessorDefinition_1 = this.generateAccessorDefinition((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getOutputVars(), "getDO", false);
        _builder.append((Object)_generateAccessorDefinition_1);
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = ((FBType)this.getType()).getInterfaceList().getInOutVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            CharSequence _generateAccessorDefinition_2 = this.generateAccessorDefinition((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getInOutVars(), "getDIO", false);
            _builder.append((Object)_generateAccessorDefinition_2);
            _builder.newLineIfNotEmpty();
        }
        if (!((FBType)this.getType()).getInterfaceList().getSockets().isEmpty() || !((FBType)this.getType()).getInterfaceList().getPlugs().isEmpty()) {
            EList _sockets = ((FBType)this.getType()).getInterfaceList().getSockets();
            EList _plugs = ((FBType)this.getType()).getInterfaceList().getPlugs();
            CharSequence _generateAccessorDefinition_3 = this.generateAccessorDefinition(IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_sockets, (Iterable)_plugs)), "getAdapterUnchecked", "CAdapter *", false);
            _builder.append((Object)_generateAccessorDefinition_3);
            _builder.newLineIfNotEmpty();
        }
        CharSequence _generateConnectionAccessorsDefinition = this.generateConnectionAccessorsDefinition((List<INamedElement>)((FBType)this.getType()).getInterfaceList().getEventOutputs(), "getEOConUnchecked", "CEventConnection *");
        _builder.append((Object)_generateConnectionAccessorsDefinition);
        _builder.newLineIfNotEmpty();
        CharSequence _generateConnectionAccessorsDefinition_1 = this.generateConnectionAccessorsDefinition((List<INamedElement>)((FBType)this.getType()).getInterfaceList().getInputVars(), "getDIConUnchecked", "CDataConnection **");
        _builder.append((Object)_generateConnectionAccessorsDefinition_1);
        _builder.newLineIfNotEmpty();
        CharSequence _generateConnectionAccessorsDefinition_2 = this.generateConnectionAccessorsDefinition((List<INamedElement>)((FBType)this.getType()).getInterfaceList().getOutputVars(), "getDOConUnchecked", "CDataConnection *");
        _builder.append((Object)_generateConnectionAccessorsDefinition_2);
        _builder.newLineIfNotEmpty();
        boolean _isEmpty_1 = ((FBType)this.getType()).getInterfaceList().getInOutVars().isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            CharSequence _generateConnectionAccessorsDefinition_3 = this.generateConnectionAccessorsDefinition((List<INamedElement>)((FBType)this.getType()).getInterfaceList().getInOutVars(), "getDIOInConUnchecked", "CInOutDataConnection **");
            _builder.append((Object)_generateConnectionAccessorsDefinition_3);
        }
        _builder.newLineIfNotEmpty();
        boolean _isEmpty_2 = ((FBType)this.getType()).getInterfaceList().getInOutVars().isEmpty();
        boolean bl3 = _not_2 = !_isEmpty_2;
        if (_not_2) {
            CharSequence _generateConnectionAccessorsDefinition_4 = this.generateConnectionAccessorsDefinition((List<INamedElement>)((FBType)this.getType()).getInterfaceList().getOutMappedInOutVars(), "getDIOOutConUnchecked", "CInOutDataConnection *");
            _builder.append((Object)_generateConnectionAccessorsDefinition_4);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateSetInitialValuesDeclaration(Iterable<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _containsNonRetainedVariable = this.containsNonRetainedVariable(variables);
        if (_containsNonRetainedVariable) {
            _builder.append("void setInitialValues() override;");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateSetInitialValuesDefinition(Iterable<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _containsNonRetainedVariable = this.containsNonRetainedVariable(variables);
        if (_containsNonRetainedVariable) {
            _builder.append("void ");
            CharSequence _className = this.getClassName();
            _builder.append((Object)_className);
            _builder.append("::setInitialValues() {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            Functions.Function1 _function = it -> {
                boolean _isRetainedVariable = this.isRetainedVariable((VarDeclaration)it);
                return !_isRetainedVariable;
            };
            CharSequence _generateVariableDefaultAssignment = this.generateVariableDefaultAssignment(IterableExtensions.filter(variables, (Functions.Function1)_function));
            _builder.append((Object)_generateVariableDefaultAssignment, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    private boolean isRetainedVariable(VarDeclaration variable) {
        return variable.getAttributeValue("Retain") != null && variable.getAttributeValue("Retain").equals(RetainHelper.RetainTag.RETAIN.getString());
    }

    private boolean containsNonRetainedVariable(Iterable<VarDeclaration> variables) {
        Functions.Function1 _function = it -> {
            boolean _isRetainedVariable = this.isRetainedVariable((VarDeclaration)it);
            return !_isRetainedVariable;
        };
        return IterableExtensions.exists(variables, (Functions.Function1)_function);
    }

    private CharSequence generateVariableDefaultAssignment(Iterable<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        for (VarDeclaration variable : variables) {
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
            _builder.append((Object)_generateName);
            _builder.append(" = ");
            CharSequence _generateVariableDefaultValue = this.generateVariableDefaultValue(variable);
            _builder.append((Object)_generateVariableDefaultValue);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateConnectionVariableDeclarations(List<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
            }
            CharSequence _generateVariableTypeName = this.generateVariableTypeName(variable);
            _builder.append((Object)_generateVariableTypeName);
            _builder.append(" ");
            CharSequence _generateNameAsConnectionVariable = this.generateNameAsConnectionVariable((INamedElement)variable);
            _builder.append((Object)_generateNameAsConnectionVariable);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append("\n");
        }
        return _builder;
    }

    protected CharSequence generateConnectionVariableInitializer(Iterable<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(",\n");
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _generateNameAsConnectionVariable = this.generateNameAsConnectionVariable((INamedElement)variable);
            _builder.append((Object)_generateNameAsConnectionVariable);
            _builder.append("(");
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
            _builder.append((Object)_generateName);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence generateEventConnectionDeclarations(List<Event> elements) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Event element : elements) {
            if (!_hasElements) {
                _hasElements = true;
            }
            _builder.append("CEventConnection ");
            CharSequence _generateNameAsConnection = this.generateNameAsConnection((INamedElement)element);
            _builder.append((Object)_generateNameAsConnection);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append("\n");
        }
        return _builder;
    }

    protected CharSequence generateDataConnectionDeclarations(List<VarDeclaration> elements, boolean input) {
        return this.generateDataConnectionDeclarations(elements, input, false);
    }

    protected CharSequence generateDataConnectionDeclarations(List<VarDeclaration> elements, boolean input, boolean internalConnection) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration element : elements) {
            boolean _isInOutVar;
            if (!_hasElements) {
                _hasElements = true;
            }
            if (_isInOutVar = element.isInOutVar()) {
                _builder.append("CInOutDataConnection");
            } else {
                _builder.append("CDataConnection");
            }
            _builder.append(" ");
            if (input) {
                _builder.append("*");
            }
            CharSequence _generateNameAsConnection = this.generateNameAsConnection(element, internalConnection);
            _builder.append((Object)_generateNameAsConnection);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append("\n");
        }
        return _builder;
    }

    protected CharSequence generateConnectionInitializer() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateConnectionVariableInitializer = this.generateConnectionVariableInitializer((Iterable<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getOutputVars());
        _builder.append((Object)_generateConnectionVariableInitializer);
        CharSequence _generateEventConnectionInitializer = this.generateEventConnectionInitializer((List<Event>)((FBType)this.getType()).getInterfaceList().getEventOutputs());
        _builder.append((Object)_generateEventConnectionInitializer);
        CharSequence _generateDataConnectionPointerInitializer = this.generateDataConnectionPointerInitializer((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getInputVars());
        _builder.append((Object)_generateDataConnectionPointerInitializer);
        CharSequence _generateDataConnectionInitializer = this.generateDataConnectionInitializer((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getOutputVars());
        _builder.append((Object)_generateDataConnectionInitializer);
        CharSequence _generateDataConnectionPointerInitializer_1 = this.generateDataConnectionPointerInitializer((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getInOutVars());
        _builder.append((Object)_generateDataConnectionPointerInitializer_1);
        CharSequence _generateDataConnectionInitializer_1 = this.generateDataConnectionInitializer((List<VarDeclaration>)((FBType)this.getType()).getInterfaceList().getOutMappedInOutVars());
        _builder.append((Object)_generateDataConnectionInitializer_1);
        return _builder;
    }

    protected CharSequence generateEventConnectionInitializer(List<Event> events) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Event event : events) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(",\n");
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _generateNameAsConnection = this.generateNameAsConnection((INamedElement)event);
            _builder.append((Object)_generateNameAsConnection);
            _builder.append("(this, ");
            int _indexOf = events.indexOf(event);
            _builder.append((Object)_indexOf);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence generateDataConnectionInitializer(List<VarDeclaration> variables) {
        return this.generateDataConnectionInitializer(variables, false);
    }

    protected CharSequence generateDataConnectionInitializer(List<VarDeclaration> variables, boolean internal) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(",\n");
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _generateNameAsConnection = this.generateNameAsConnection(variable, internal);
            _builder.append((Object)_generateNameAsConnection);
            _builder.append("(this, ");
            int _indexOf = variables.indexOf(variable);
            _builder.append((Object)_indexOf);
            _builder.append(", &");
            if (internal) {
                CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
                _builder.append((Object)_generateName);
            } else {
                CharSequence _generateNameAsConnectionVariable = this.generateNameAsConnectionVariable((INamedElement)variable);
                _builder.append((Object)_generateNameAsConnectionVariable);
            }
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence generateDataConnectionPointerInitializer(List<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : variables) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(",\n");
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _generateNameAsConnection = this.generateNameAsConnection(variable);
            _builder.append((Object)_generateNameAsConnection);
            _builder.append("(nullptr)");
        }
        return _builder;
    }

    protected CharSequence generateConnectionAccessorsDeclaration(String function, String type) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(type);
        _builder.append(function);
        _builder.append("(TPortId) override;");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateConnectionAccessorsDefinition(List<? extends INamedElement> elements, String function, String type) {
        return this.generateConnectionAccessorsDefinition(elements, function, type, false);
    }

    protected CharSequence generateConnectionAccessorsDefinition(List<? extends INamedElement> elements, String function, String type, boolean internal) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = elements.isEmpty();
        if (_isEmpty) {
            _builder.append(type);
            CharSequence _className = this.getClassName();
            _builder.append((Object)_className);
            _builder.append("::");
            _builder.append(function);
            _builder.append("(TPortId) {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("return nullptr;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        } else {
            _builder.append(type);
            CharSequence _className_1 = this.getClassName();
            _builder.append((Object)_className_1);
            _builder.append("::");
            _builder.append(function);
            _builder.append("(const TPortId paIndex) {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("switch(paIndex) {");
            _builder.newLine();
            for (INamedElement iNamedElement : elements) {
                _builder.append("    ");
                _builder.append("case ");
                int _indexOf = elements.indexOf(iNamedElement);
                _builder.append((Object)_indexOf, "    ");
                _builder.append(": return &");
                CharSequence _generateNameAsConnection = this.generateNameAsConnection(iNamedElement, internal);
                _builder.append((Object)_generateNameAsConnection, "    ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("  ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("return nullptr;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateNameAsConnection(VarDeclaration varDeclaration) {
        return this.generateNameAsConnection(varDeclaration, false);
    }

    protected CharSequence generateNameAsConnection(VarDeclaration varDeclaration, boolean internal) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isInOutVar = varDeclaration.isInOutVar();
        if (_isInOutVar) {
            _builder.append("conn_");
            String _name = varDeclaration.getName();
            _builder.append(_name);
            boolean _isIsInput = varDeclaration.isIsInput();
            if (_isIsInput) {
                _builder.append("In");
            } else {
                _builder.append("Out");
            }
            if (internal) {
                _builder.append("Internal");
            }
        } else {
            _builder.append("conn_");
            String _name_1 = varDeclaration.getName();
            _builder.append(_name_1);
        }
        return _builder;
    }

    protected CharSequence generateNameAsConnection(INamedElement element, boolean internal) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (element instanceof VarDeclaration) {
            _matched = true;
            _switchResult = this.generateNameAsConnection((VarDeclaration)element, internal);
        }
        if (!_matched) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("conn_");
            String _name = element.getName();
            _builder.append(_name);
            _switchResult = _builder;
        }
        return _switchResult;
    }

    protected CharSequence generateNameAsConnection(INamedElement element) {
        return this.generateNameAsConnection(element, false);
    }

    protected CharSequence generateNameAsConnectionVariable(INamedElement element) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("var_conn_");
        String _name = element.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence generateEventAccessorDefinitions() {
        StringConcatenation _builder = new StringConcatenation();
        EList _eventInputs = ((FBType)this.getType()).getInterfaceList().getEventInputs();
        boolean _hasElements = false;
        for (Event event : _eventInputs) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("\n");
            }
            CharSequence _generateEventAccessorDefinition = this.generateEventAccessorDefinition(event);
            _builder.append((Object)_generateEventAccessorDefinition);
            _builder.newLineIfNotEmpty();
        }
        Event _head = (Event)IterableExtensions.head((Iterable)((FBType)this.getType()).getInterfaceList().getEventInputs());
        CharSequence _generateEventAccessorCallOperator = null;
        if (_head != null) {
            _generateEventAccessorCallOperator = this.generateEventAccessorCallOperator(_head);
        }
        _builder.append(_generateEventAccessorCallOperator);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateEventAccessorDefinition(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)event);
        _builder.append((Object)_generateName);
        _builder.append("(");
        CharSequence _generateEventAccessorParameters = this.generateEventAccessorParameters(event);
        _builder.append((Object)_generateEventAccessorParameters);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        EList _inputParameters = event.getInputParameters();
        EList _inOutParameters = event.getInOutParameters();
        Iterable _filter = Iterables.filter((Iterable)Iterables.concat((Iterable)_inputParameters, (Iterable)_inOutParameters), VarDeclaration.class);
        for (VarDeclaration variable : _filter) {
            _builder.append("  ");
            CharSequence _generateName_1 = ForteNgExportUtil.generateName((IInterfaceElement)variable);
            _builder.append((Object)_generateName_1, "  ");
            _builder.append(" = ");
            CharSequence _generateNameAsParameter = this.generateNameAsParameter(variable);
            _builder.append((Object)_generateNameAsParameter, "  ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("  ");
        _builder.append("executeEvent(");
        CharSequence _generateEventID = this.generateEventID(event);
        _builder.append((Object)_generateEventID, "  ");
        _builder.append(", nullptr);");
        _builder.newLineIfNotEmpty();
        EList _outputParameters = event.getOutputParameters();
        EList _inOutParameters_1 = event.getInOutParameters();
        Iterable _filter_1 = Iterables.filter((Iterable)Iterables.concat((Iterable)_outputParameters, (Iterable)_inOutParameters_1), VarDeclaration.class);
        for (VarDeclaration variable_1 : _filter_1) {
            boolean _isAnyType = IecTypes.GenericTypes.isAnyType((DataType)variable_1.getType());
            if (_isAnyType) {
                _builder.append("  ");
                CharSequence _generateNameAsParameter_1 = this.generateNameAsParameter(variable_1);
                _builder.append((Object)_generateNameAsParameter_1, "  ");
                _builder.append(".setValue(");
                CharSequence _generateName_2 = ForteNgExportUtil.generateName((IInterfaceElement)variable_1);
                _builder.append((Object)_generateName_2, "  ");
                _builder.append(".unwrap());");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("  ");
            CharSequence _generateNameAsParameter_2 = this.generateNameAsParameter(variable_1);
            _builder.append((Object)_generateNameAsParameter_2, "  ");
            _builder.append(" = ");
            CharSequence _generateName_3 = ForteNgExportUtil.generateName((IInterfaceElement)variable_1);
            _builder.append((Object)_generateName_3, "  ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateEventAccessorCallOperator(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void operator()(");
        CharSequence _generateEventAccessorParameters = this.generateEventAccessorParameters(event);
        _builder.append((Object)_generateEventAccessorParameters);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)event);
        _builder.append((Object)_generateName, "  ");
        _builder.append("(");
        CharSequence _generateEventAccessorForwardArguments = this.generateEventAccessorForwardArguments(event);
        _builder.append((Object)_generateEventAccessorForwardArguments, "  ");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateEventAccessorParameters(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<VarDeclaration> _eventAccessorParameters = this.getEventAccessorParameters(event);
        boolean _hasElements = false;
        for (VarDeclaration param : _eventAccessorParameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            if (param.isIsInput() && !param.isInOutVar()) {
                _builder.append("const ");
            }
            CharSequence _generateVariableTypeNameAsParameter = this.generateVariableTypeNameAsParameter(param);
            _builder.append((Object)_generateVariableTypeNameAsParameter);
            _builder.append(" &");
            CharSequence _generateNameAsParameter = this.generateNameAsParameter(param);
            _builder.append((Object)_generateNameAsParameter);
        }
        return _builder;
    }

    protected CharSequence generateEventAccessorForwardArguments(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<VarDeclaration> _eventAccessorParameters = this.getEventAccessorParameters(event);
        boolean _hasElements = false;
        for (VarDeclaration param : _eventAccessorParameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _generateNameAsParameter = this.generateNameAsParameter(param);
            _builder.append((Object)_generateNameAsParameter);
        }
        return _builder;
    }

    protected Iterable<VarDeclaration> getEventAccessorParameters(Event event) {
        EList _inputParameters = event.getInputParameters();
        EList _inOutParameters = event.getInOutParameters();
        Iterable _plus = Iterables.concat((Iterable)_inputParameters, (Iterable)_inOutParameters);
        EList _outputParameters = event.getOutputParameters();
        return Iterables.filter((Iterable)Iterables.concat((Iterable)_plus, (Iterable)_outputParameters), VarDeclaration.class);
    }

    protected CharSequence getFBClassName() {
        return this.getClassName();
    }

    protected CharSequence generateInitializeDeclaration() {
        StringConcatenation _builder = new StringConcatenation();
        if (!((FBType)this.getType()).getInterfaceList().getSockets().isEmpty() || !((FBType)this.getType()).getInterfaceList().getPlugs().isEmpty()) {
            _builder.append("bool initialize() override;");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateInitializeDefinition() {
        StringConcatenation _builder = new StringConcatenation();
        if (!((FBType)this.getType()).getInterfaceList().getSockets().isEmpty() || !((FBType)this.getType()).getInterfaceList().getPlugs().isEmpty()) {
            _builder.newLine();
            _builder.append("bool ");
            CharSequence _fBClassName = this.getFBClassName();
            _builder.append((Object)_fBClassName);
            _builder.append("::initialize() {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            EList _sockets = ((FBType)this.getType()).getInterfaceList().getSockets();
            EList _plugs = ((FBType)this.getType()).getInterfaceList().getPlugs();
            CharSequence _generateAdapterInitialize = this.generateAdapterInitialize(IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_sockets, (Iterable)_plugs)));
            _builder.append((Object)_generateAdapterInitialize, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("return ");
            String _baseClass = this.baseClass();
            _builder.append(_baseClass, "  ");
            _builder.append("::initialize();");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateAdapterInitialize(List<AdapterDeclaration> adapters) {
        StringConcatenation _builder = new StringConcatenation();
        for (AdapterDeclaration adapter : adapters) {
            _builder.append("if(!");
            CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)adapter);
            _builder.append((Object)_generateName);
            _builder.append(".initialize()) { return false; }");
            _builder.newLineIfNotEmpty();
        }
        for (AdapterDeclaration adapter_1 : adapters) {
            CharSequence _generateName_1 = ForteNgExportUtil.generateName((IInterfaceElement)adapter_1);
            _builder.append((Object)_generateName_1);
            _builder.append(".setParentFB(this, ");
            int _indexOf = adapters.indexOf(adapter_1);
            _builder.append((Object)_indexOf);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateInternalFBDeclarations(List<FB> internalFbs) {
        StringConcatenation _builder = new StringConcatenation();
        for (FB fb : internalFbs) {
            _builder.append("forte::core::CInternalFB<");
            CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((INamedElement)fb.getType());
            _builder.append((Object)_generateTypeName);
            _builder.append("> ");
            CharSequence _generateName = ForteNgExportUtil.generateName(fb);
            _builder.append((Object)_generateName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateInternalFBInitializer(List<FB> internalFbs) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (FB fb : internalFbs) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(",\n");
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _generateInternalFBInitializer = this.generateInternalFBInitializer(fb);
            _builder.append((Object)_generateInternalFBInitializer);
        }
        return _builder;
    }

    public CharSequence generateInternalFBInitializer(FB fb) {
        StringConcatenation _xifexpression = null;
        boolean _isGenericType = ForteNgExportUtil.isGenericType(fb.getType());
        if (_isGenericType) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _generateName = ForteNgExportUtil.generateName(fb);
            _builder.append((Object)_generateName);
            _builder.append("(");
            CharSequence _fORTEStringId = ForteNgExportUtil.getFORTEStringId(fb.getName());
            _builder.append((Object)_fORTEStringId);
            _builder.append(", \"");
            CharSequence _generateInternalFBConfigString = this.generateInternalFBConfigString(fb);
            _builder.append((Object)_generateInternalFBConfigString);
            _builder.append("\", *this)");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            CharSequence _generateName_1 = ForteNgExportUtil.generateName(fb);
            _builder_1.append((Object)_generateName_1);
            _builder_1.append("(");
            CharSequence _fORTEStringId_1 = ForteNgExportUtil.getFORTEStringId(fb.getName());
            _builder_1.append((Object)_fORTEStringId_1);
            _builder_1.append(", *this)");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    public CharSequence generateInternalFBConfigString(FB fb) {
        String _switchResult = null;
        boolean _matched = false;
        if (fb instanceof ConfigurableFB) {
            boolean _tripleNotEquals;
            DataType _dataType = ((ConfigurableFB)fb).getDataType();
            boolean bl = _tripleNotEquals = _dataType != null;
            if (_tripleNotEquals) {
                _matched = true;
                StringConcatenation _builder = new StringConcatenation();
                String _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain((INamedElement)((ConfigurableFB)fb).getType());
                _builder.append(_generateTypeNamePlain);
                _builder.append("_1");
                String _generateTypeNamePlain_1 = ForteNgExportUtil.generateTypeNamePlain((INamedElement)((ConfigurableFB)fb).getDataType());
                _builder.append(_generateTypeNamePlain_1);
                _switchResult = _builder;
            }
        }
        if (!_matched) {
            _switchResult = ForteNgExportUtil.generateTypeNamePlain((INamedElement)fb.getType());
        }
        return _switchResult;
    }

    @Override
    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        Set<INamedElement> _dependencies = super.getDependencies(options);
        EList _sockets = ((FBType)this.getType()).getInterfaceList().getSockets();
        EList _plugs = ((FBType)this.getType()).getInterfaceList().getPlugs();
        Functions.Function1 _function = it -> it.getType();
        Iterable _map = IterableExtensions.map((Iterable)Iterables.concat((Iterable)_sockets, (Iterable)_plugs), (Functions.Function1)_function);
        return IterableExtensions.toSet((Iterable)Iterables.concat(_dependencies, (Iterable)_map));
    }
}

